/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.spring.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TimeLogAspect {
    private final Logger log = LoggerFactory.getLogger(TimeLogAspect.class);

    @Around(value="@annotation(br.intelidata.uniplusweb.core.spring.aop.Timed) && execution(public * *(..))")
    public Object time(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value;
        long start = System.currentTimeMillis();
        try {
            value = proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            long duration = System.currentTimeMillis() - start;
            this.log.info("Timed " + proceedingJoinPoint.getSignature().getDeclaringType().getSimpleName() + " - " + proceedingJoinPoint.getSignature().getName() + ":" + duration);
        }
        return value;
    }
}

