/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.web.PermissaoWeb;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.TipoPermissao;
import br.intelidata.commons.modulo.ferramentas.regranegocio.RelatorioConfiguradoWebRN;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.menus.ItemMenuWeb;
import br.intelidata.uniplusweb.web.rest.menus.MenuObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class MenuManager {
    public List<ItemMenuWeb> mountMenu(List<MenuObject> itens, Map<Integer, PermissaoWeb> permissoes, Usuario usuario, MenuObject pai) {
        ArrayList<ItemMenuWeb> menus = new ArrayList<ItemMenuWeb>();
        for (MenuObject single : itens) {
            PermissaoWeb permissao;
            int programa;
            boolean visible = true;
            if (single.getMenuMapping() != null) {
                programa = single.getMenuMapping().PROGRAMA();
            } else {
                programa = single.getSubMenuMapping().PROGRAMA();
                visible = single.getSubMenuMapping().VISIBLE();
            }
            if ((permissao = permissoes.get(programa)) == null) continue;
            if (usuario.isAdministrador() || single.getMenuMapping() != null) {
                permissao.setTipoPermissao(TipoPermissao.ACESSO_LIBERADO);
            }
            if (permissao.getTipoPermissao().equals((Object)TipoPermissao.ACESSO_NEGADO)) continue;
            List filhos = null;
            if (!ListMapUtil.listNullOrEmpty((List)single.getFilhos())) {
                filhos = this.mountMenu(single.getFilhos(), permissoes, usuario, single);
                filhos.sort(Comparator.comparingInt(ItemMenuWeb::getPeso));
            }
            menus.add(new ItemMenuWeb(single.getNome(), single.getTitulo(), single.getIcone(), single.getEndpoint(), permissao.getTipoPermissao(), single.getCorTexto(), filhos, permissao.getMapAcoes(), single.isCustomAction(), programa, single.getPeso(), visible));
        }
        if (pai != null && pai.getSubMenuMapping() != null && pai.getSubMenuMapping().SUBMENU_RELATORIO()) {
            this.montarMenusRelatoriosConfigurados(pai, menus, permissoes, false);
        }
        menus.sort(Comparator.comparingInt(ItemMenuWeb::getPeso));
        return menus;
    }

    public void montarMenusRelatoriosConfigurados(MenuObject pai, List<ItemMenuWeb> menus, Map<Integer, PermissaoWeb> permissoes, boolean configuracaoPerfil) {
        List relatorios = RelatorioConfiguradoWebRN.getInstance().buscaPorLocalizacao(pai.getSubMenuMapping().PROGRAMA());
        if (!ListMapUtil.listNullOrEmpty((List)relatorios)) {
            relatorios.forEach(relatorio -> {
                boolean admOuPerfil;
                int idMenu = Integer.parseInt(900027 + relatorio.getId().toString());
                TipoPermissao permissao = null;
                PermissaoWeb permissaoWeb = (PermissaoWeb)permissoes.get(idMenu);
                if (permissaoWeb != null) {
                    permissao = permissaoWeb.getTipoPermissao();
                }
                boolean bl = admOuPerfil = configuracaoPerfil || SessaoUtil.getSessao().getUsuario().isAdministrador();
                if (permissao == null) {
                    permissao = configuracaoPerfil || !SessaoUtil.getSessao().getUsuario().isAdministrador() ? TipoPermissao.ACESSO_NEGADO : TipoPermissao.ACESSO_LIBERADO;
                }
                if (!permissao.equals((Object)TipoPermissao.ACESSO_NEGADO) || admOuPerfil) {
                    ItemMenuWeb item = new ItemMenuWeb("RelatorioConfigurado".concat(relatorio.getId().toString()), relatorio.getDescricao(), "icon-imprimir", "/relatorios-configurados-module/gerar-relatorio/" + relatorio.getId(), permissao, "texto-verde-escuro", null, null, false, idMenu, 0, true);
                    item.setIdRelatorio(relatorio.getId());
                    item.setIdMenuPai(pai.getSubMenuMapping().PROGRAMA());
                    item.setGravarMenu(true);
                    menus.add(item);
                }
            });
        }
    }
}

