/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.core.util.AssertUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class NumberUtil {
    public static final BigDecimal CEM = new BigDecimal(100);

    public static boolean isNumber(String valor) {
        return NumberUtils.isNumber((String)valor);
    }

    public static Long toLong(String valor) {
        return NumberUtils.createLong((String)valor);
    }

    public static Integer toInteger(String valor) {
        return NumberUtils.createInteger((String)valor);
    }

    public static boolean longNullOuZero(Long valor) {
        return valor == null || valor.equals(0L);
    }

    public static BigDecimal toBigDecimal(String valor) {
        try {
            return NumberUtils.createBigDecimal((String)valor);
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal toBigDecimal(Object valor) {
        try {
            return NumberUtil.toBigDecimal((String)String.valueOf(valor));
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static BigDecimal string2BigDecimal(String str) {
        BigDecimal valor;
        try {
            str = str.replace(".", "");
            str = str.replace(',', '.');
            valor = new BigDecimal(str);
        }
        catch (Exception e) {
            valor = BigDecimal.ZERO;
        }
        return valor;
    }

    public static boolean bigDecimalNullOrZero(BigDecimal numero) {
        return numero == null || numero.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean intNullOuZero(Integer valor) {
        return valor == null || valor.equals(0);
    }

    public static String apenasNumeros(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder sbRetorno = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (!"0123456789".contains(string.substring(i, i + 1))) continue;
            sbRetorno.append(string.substring(i, i + 1));
        }
        return sbRetorno.toString();
    }

    public static int getQuantidadeDigitosAntesVirgula(BigDecimal numero) {
        if (numero == null) {
            return 0;
        }
        return numero.setScale(0, 3).precision();
    }

    public static BigDecimal percentual(BigDecimal valor1, BigDecimal valor2) {
        return valor2.compareTo(BigDecimal.ZERO) > 0 ? valor1.divide(valor2, 10, 6).multiply(CEM).setScale(2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
    }

    public static BigDecimal valorDesconto(BigDecimal valor, BigDecimal percentual, int casasDecimais) {
        return valor.multiply(percentual).divide(CEM, 10, 6).setScale(casasDecimais, 6);
    }

    public static boolean intExistsIn(Integer valor, Integer[] valores) {
        for (Integer value : valores) {
            if (!valor.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static long converteVersao(String versao) {
        if (!StringUtil.stringNullOrEmpty((String)versao)) {
            String[] partes = versao.split("\\.");
            AssertUtil.isTrue((partes.length == 3 ? 1 : 0) != 0, (String)("Formato da vers\u00e3o inv\u00e1lida: " + versao));
            return NumberUtil.string2int((String)partes[0]) * 100000000 + NumberUtil.string2int((String)partes[1]) * 10000 + NumberUtil.string2int((String)partes[2]);
        }
        return 0L;
    }

    public static int string2int(String str) {
        int valor;
        try {
            valor = Integer.parseInt(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            valor = 0;
        }
        return valor;
    }

    public static long string2Long(String str) {
        long valor;
        try {
            valor = Long.parseLong(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            valor = 0L;
        }
        return valor;
    }
}

