/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.ie.InscricaoEstadual;
import br.intelidata.commons.core.util.ie.InscricaoEstadualFactory;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.swing.text.MaskFormatter;
import org.apache.xml.utils.XMLChar;
import org.springframework.util.MultiValueMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringUtil {
    private static final String CARACTERES_VALIDOS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.";
    public static final String MASCARA_VALOR = "#,###,###,##0.00";
    public static final int VALIDA_CPF = 0;
    public static final int VALIDA_CNPJ = 1;
    public static final int VALIDA_CPF_CNPJ = 2;
    public static final int LENGTH_CPF = 11;
    public static final int LENGTH_CNPJ = 14;
    public static final String fileSeparator = System.getProperties().getProperty("file.separator");
    public static final String lineSeparator = System.getProperties().getProperty("line.separator");
    public static final String CARACTERES_ACENTUADOS = "\u00e7\u00c7\u00e1\u00e9\u00ed\u00f3\u00fa\u00fd\u00c1\u00c9\u00cd\u00d3\u00da\u00dd\u00e0\u00e8\u00ec\u00f2\u00f9\u00c0\u00c8\u00cc\u00d2\u00d9\u00e3\u00f5\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00ff\u00c4\u00cb\u00cf\u00d6\u00dc\u00c3\u00d5\u00d1\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\"'";
    public static final String CARACTERES_NAO_ACENTUADOS = "cCaeiouyAEIOUYaeiouAEIOUaonaeiouyAEIOUAONaeiouAEIOU  ";

    public static boolean stringNullOrEmpty(String txt) {
        return txt == null || txt.trim().isEmpty();
    }

    public static boolean validarCaracteres(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.".contains(string.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    }

    public static String all2Atring(Object obj) {
        String valor = "";
        if (obj != null) {
            valor = String.valueOf(obj);
        }
        return valor;
    }

    public static int string2int(String str) {
        int valor;
        try {
            valor = Integer.parseInt(str);
        }
        catch (NullPointerException | NumberFormatException e) {
            valor = 0;
        }
        return valor;
    }

    public static long string2long(String str) {
        long valor = 0L;
        try {
            valor = Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            valor = 0L;
        }
        return valor;
    }

    public static String bigDecimal2String(BigDecimal valor, String mascara) {
        String retorno;
        try {
            DecimalFormat fmt = new DecimalFormat(mascara);
            retorno = fmt.format(valor);
        }
        catch (IllegalArgumentException ex) {
            retorno = "";
        }
        return retorno;
    }

    public static String getMascaraQuantidade(int casasDecimais) {
        String mascara = "#,##0";
        if (casasDecimais > 0) {
            mascara = mascara + "." + StringUtil.zeroEsquerda((String)String.valueOf("0"), (int)casasDecimais);
        }
        return mascara;
    }

    public static String zeroEsquerda(String string, int tamanho) {
        for (int i = string.length(); i < tamanho; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String formataDataHora(Temporal dataHora, String mascara) {
        if (dataHora == null) {
            return "";
        }
        try {
            DateTimeFormatter formatador = DateTimeFormatter.ofPattern(mascara);
            String dateStr = formatador.format(dataHora);
            return dateStr;
        }
        catch (DateTimeException ex) {
            return "";
        }
    }

    public static String capitalizarString(String str) {
        if (str != null && str.length() > 0) {
            StringBuilder strb = new StringBuilder(str);
            strb.setCharAt(0, Character.toTitleCase(str.charAt(0)));
            str = strb.toString();
        }
        return str;
    }

    public static String normalizar(String stringAcentuada) {
        return Normalizer.normalize(stringAcentuada, Normalizer.Form.NFC).replaceAll("[^\\p{ASCII}]", "");
    }

    public static String formataCpfCnpj(String cpfCnpj) {
        if (cpfCnpj == null) {
            return null;
        }
        cpfCnpj = (cpfCnpj = StringUtil.limpaMascara((String)cpfCnpj, (String)"./-")).length() == 11 ? cpfCnpj.replaceAll("(\\d{3})(\\d{3})(\\d{3})(\\d{2})", "$1.$2.$3-$4") : cpfCnpj.replaceAll("(\\d{2})(\\d{3})(\\d{3})(\\d{4})(\\d{2})", "$1.$2.$3/$4-$5");
        return cpfCnpj;
    }

    public static String limpaMascara(String valorOriginal, String mascara) {
        if (valorOriginal == null) {
            return null;
        }
        String valor = valorOriginal;
        for (int i = 0; i < mascara.length(); ++i) {
            valor = valor.replace(mascara.substring(i, i + 1), "");
        }
        return valor.trim();
    }

    public static boolean isCnpjFilhoDe(String cnpjFilho, String cnpjPai) {
        cnpjPai = NumberUtil.apenasNumeros((String)cnpjPai).substring(0, 8);
        return NumberUtil.apenasNumeros((String)cnpjFilho).startsWith(cnpjPai);
    }

    public static String hexToString(String hex) {
        String retorno;
        int l = hex.length();
        byte[] data = new byte[l / 2];
        for (int i = 0; i < l; i += 2) {
            if (i + 1 >= l) continue;
            data[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        try {
            retorno = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            retorno = "";
        }
        return retorno;
    }

    public static String formataNumero(BigDecimal valor, String mascara) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        DecimalFormat formatoNumero = new DecimalFormat();
        formatoNumero.applyPattern(mascara);
        return formatoNumero.format(valor);
    }

    public static String formataNumero(BigDecimal valor, int tamanho) {
        String mascara = null;
        switch (valor.scale()) {
            case 0: {
                mascara = "##########";
                break;
            }
            case 1: {
                mascara = "#######0.0";
                break;
            }
            case 2: {
                mascara = "######0.00";
                break;
            }
            case 3: {
                mascara = "#####0.000";
                break;
            }
            default: {
                mascara = "#####0.000";
            }
        }
        DecimalFormat formatoNumero = new DecimalFormat();
        formatoNumero.applyPattern(mascara);
        return StringUtil.padr((String)formatoNumero.format(valor), (int)tamanho);
    }

    public static String formataNumero(BigDecimal valor, String mascara, int tamanho) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        DecimalFormat formatoNumero = new DecimalFormat();
        formatoNumero.applyPattern(mascara);
        return StringUtil.padr((String)formatoNumero.format(valor), (int)tamanho);
    }

    public static double bigdecimal2Double(BigDecimal valor, int decimal) {
        if (valor == null) {
            valor = BigDecimal.ZERO;
        }
        valor = valor.setScale(decimal, 1);
        return valor.doubleValue();
    }

    public static String padr(String string, int tamanho) {
        StringBuilder sb = new StringBuilder(string);
        for (int i = sb.length(); i < tamanho; ++i) {
            sb.insert(0, ' ');
        }
        return sb.toString();
    }

    public static int convertFirstValueMapToInt(MultiValueMap<String, String> parametros, String field) throws UnicoMensagemUsuarioException {
        int retorno = 0;
        String value = StringUtil.getFirstMap(parametros, (String)field);
        if (!StringUtil.stringNullOrEmpty((String)value)) {
            retorno = Integer.parseInt(value);
        }
        return retorno;
    }

    public static Long convertFirstValueMapToLong(MultiValueMap<String, String> parametros, String field) throws UnicoMensagemUsuarioException {
        Long retorno = null;
        String value = StringUtil.getFirstMap(parametros, (String)field);
        if (!StringUtil.stringNullOrEmpty((String)value)) {
            retorno = Long.valueOf(value);
        }
        return retorno;
    }

    public static boolean convertFirstValueMapToBoolean(MultiValueMap<String, String> parametros, String field) throws UnicoMensagemUsuarioException {
        boolean retorno = false;
        String value = StringUtil.getFirstMap(parametros, (String)field);
        if (!StringUtil.stringNullOrEmpty((String)value)) {
            retorno = Boolean.parseBoolean(value);
        }
        return retorno;
    }

    public static List<String> getAllValuesMap(MultiValueMap<String, String> parametros, String field) throws UnicoMensagemUsuarioException {
        List values = null;
        if (!parametros.containsKey((Object)field)) {
            throw new UnicoMensagemUsuarioException("WWW178", "Par\u00e2metro [" + field + "] n\u00e3o encontrado. Verifique");
        }
        values = (List)parametros.get((Object)field);
        return values;
    }

    public static String getFirstMap(MultiValueMap<String, String> parametros, String field) throws UnicoMensagemUsuarioException {
        if (parametros.containsKey((Object)field)) {
            return (String)parametros.getFirst((Object)field);
        }
        throw new UnicoMensagemUsuarioException("WWW179", "Par\u00e2metro [" + field + "] n\u00e3o encontrado. Verifique");
    }

    public static boolean emailValido(String email) {
        try {
            InternetAddress validador = new InternetAddress(email);
            validador.validate();
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    }

    public static boolean validaIE(String ie, String uf, boolean aceitaIsento) {
        ie = ie.trim();
        if (aceitaIsento && ie.equalsIgnoreCase("ISENTO")) {
            return true;
        }
        InscricaoEstadual instanciaIE = InscricaoEstadualFactory.getInstance((String)uf);
        if (instanciaIE != null) {
            return instanciaIE.validar(ie);
        }
        return false;
    }

    public static String getDiretorioAplicacao() {
        return System.getProperty("user.dir");
    }

    public static String getArquivo(String arquivo) {
        return StringUtil.getDiretorioAplicacao() + System.getProperty("file.separator") + arquivo;
    }

    public static String removerAcentos(String texto) {
        if (texto == null) {
            return "";
        }
        texto = Normalizer.normalize(texto, Normalizer.Form.NFD);
        texto = texto.replaceAll("[^\\p{ASCII}]", "");
        texto = texto.replace("\t", " ");
        texto = texto.replace("\r\n", " ");
        texto = texto.replace("\n", " ");
        texto = texto.replace("\r", "");
        return texto;
    }

    public static String removerAcentosPesquisa(String texto) {
        int i;
        if (texto == null) {
            return "";
        }
        String acentuado = "\u00e7\u00c7\u00e1\u00e9\u00ed\u00f3\u00fa\u00fd\u00c1\u00c9\u00cd\u00d3\u00da\u00dd\u00e0\u00e8\u00ec\u00f2\u00f9\u00c0\u00c8\u00cc\u00d2\u00d9\u00e3\u00f5\u00f1\u00e4\u00eb\u00ef\u00f6\u00fc\u00ff\u00c4\u00cb\u00cf\u00d6\u00dc\u00c3\u00d5\u00d1\u00e2\u00ea\u00ee\u00f4\u00fb\u00c2\u00ca\u00ce\u00d4\u00db\"'";
        char[] tabela = new char[256];
        for (i = 0; i < tabela.length; ++i) {
            tabela[i] = (char)i;
        }
        for (i = 0; i < acentuado.length(); ++i) {
            tabela[acentuado.charAt((int)i)] = "cCaeiouyAEIOUYaeiouAEIOUaonaeiouyAEIOUAONaeiouAEIOU  ".charAt(i);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < texto.length(); ++i2) {
            char ch = texto.charAt(i2);
            char ch2 = ch < '\u0100' ? tabela[ch] : ch;
            sb.append(ch2);
        }
        return sb.toString();
    }

    public static String validaCPFCNPJ(int tipo, String valor) {
        boolean ok = false;
        String mensagem = null;
        valor = NumberUtil.apenasNumeros((String)valor);
        if (tipo == 0 || tipo == 2) {
            boolean validaNumerosRepetidosCPF = valor.matches("^(\\d)\\1{10}");
            if (valor.length() == 11 && !validaNumerosRepetidosCPF) {
                int d2 = 0;
                int d1 = 0;
                int resto = 0;
                int digito2 = 0;
                int digito1 = 0;
                for (int n_Count = 1; n_Count < valor.length() - 1; ++n_Count) {
                    int digitoCPF = Integer.parseInt(valor.substring(n_Count - 1, n_Count));
                    d1 += (11 - n_Count) * digitoCPF;
                    d2 += (12 - n_Count) * digitoCPF;
                }
                resto = d1 % 11;
                digito1 = resto < 2 ? 0 : 11 - resto;
                resto = (d2 += 2 * digito1) % 11;
                digito2 = resto < 2 ? 0 : 11 - resto;
                String nDigVerific = valor.substring(valor.length() - 2, valor.length());
                String nDigResult = String.valueOf(digito1) + String.valueOf(digito2);
                ok = nDigVerific.equals(nDigResult);
            }
        }
        if (tipo == 1 || tipo == 2) {
            boolean validaNumerosRepetidosCNPJ = valor.matches("^(\\d)\\1{13}");
            if (valor.length() == 14 && !validaNumerosRepetidosCNPJ) {
                int i;
                int soma = 0;
                String cnpj_calc = valor.substring(0, 12);
                char[] chr_cnpj = valor.toCharArray();
                for (i = 0; i < 4; ++i) {
                    if (chr_cnpj[i] - 48 < 0 || chr_cnpj[i] - 48 > 9) continue;
                    soma += (chr_cnpj[i] - 48) * (6 - (i + 1));
                }
                for (i = 0; i < 8; ++i) {
                    if (chr_cnpj[i + 4] - 48 < 0 || chr_cnpj[i + 4] - 48 > 9) continue;
                    soma += (chr_cnpj[i + 4] - 48) * (10 - (i + 1));
                }
                int dig = 11 - soma % 11;
                cnpj_calc = cnpj_calc + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
                soma = 0;
                for (i = 0; i < 5; ++i) {
                    if (chr_cnpj[i] - 48 < 0 || chr_cnpj[i] - 48 > 9) continue;
                    soma += (chr_cnpj[i] - 48) * (7 - (i + 1));
                }
                for (i = 0; i < 8; ++i) {
                    if (chr_cnpj[i + 5] - 48 < 0 || chr_cnpj[i + 5] - 48 > 9) continue;
                    soma += (chr_cnpj[i + 5] - 48) * (10 - (i + 1));
                }
                dig = 11 - soma % 11;
                cnpj_calc = cnpj_calc + (dig == 10 || dig == 11 ? "0" : Integer.toString(dig));
                ok = valor.equals(cnpj_calc);
            }
        }
        if (!ok) {
            mensagem = "CNPJ ou CPF inv\u00e1lido. Verifique";
            switch (tipo) {
                case 0: {
                    mensagem = "CPF inv\u00e1lido. Verifique";
                    break;
                }
                case 1: {
                    mensagem = "CNPJ inv\u00e1lido. Verifique";
                    break;
                }
            }
        }
        return mensagem;
    }

    public static String removerAcentosSubstituiCaracteresEspeciais(String str) {
        str = StringUtil.removerAcentos((String)str);
        str = str.replace("\u00ba", "o");
        str = str.replace("\u00aa", "a");
        str = str.replace("\ufeff", "");
        StringBuilder retorno = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (!XMLChar.isValid((int)ch)) continue;
            retorno = retorno.append(ch);
        }
        return retorno.toString();
    }

    public static boolean stringExistsIn(String valor, String[] valores) {
        for (String value : valores) {
            if (!valor.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static String formatarString(String texto, String mascara) {
        try {
            MaskFormatter mf = new MaskFormatter(mascara);
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(texto);
        }
        catch (ParseException ex) {
            return texto;
        }
    }

    public static String removeChar(String s, char c) {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            r.append(s.charAt(i));
        }
        return r.toString();
    }

    public static String byteArrayToString(byte[] byteArray) {
        String valor = new String(byteArray, StandardCharsets.UTF_8);
        return valor;
    }

    public static String replicate(String texto, int tamanho) {
        if (tamanho > 0) {
            StringBuilder sb = new StringBuilder(texto != null ? texto.length() * tamanho : tamanho);
            for (int i = 0; i < tamanho; ++i) {
                sb.append(texto);
            }
            return sb.toString();
        }
        return "";
    }
}

