/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.uniplusweb.core.util.StringUtil;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SystemUtil {
    private static final Logger log = LoggerFactory.getLogger(SystemUtil.class);
    public static final BigDecimal MIL_VINTE_QUATRO = new BigDecimal(1024);

    public static boolean isLinux() {
        return System.getProperty("os.name", "").toLowerCase().startsWith("linux");
    }

    public static boolean isMac() {
        return System.getProperty("os.name", "").toLowerCase().startsWith("mac");
    }

    public static String getDiretorioUsuario() {
        return System.getProperty("user.home");
    }

    public static String getDiretorioAplicacao() {
        return System.getProperty("user.dir");
    }

    public static String getDiretorioPostgres(String dir) {
        if (!StringUtil.stringNullOrEmpty((String)dir)) {
            if (Files.exists(Paths.get(dir = dir.trim(), new String[0]), new LinkOption[0])) {
                log.info("diretorio existe");
                dir = dir.replace("\\", "/");
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                return dir + "bin/";
            }
            log.info("diretorio n\u00e3o existe");
            return SystemUtil.getDiretorioAplicacao() + "/pg/bin/";
        }
        return SystemUtil.getDiretorioAplicacao() + "/pg/bin/";
    }

    public static BigDecimal getEspacoLivre(String diretorio) {
        File file = new File(diretorio);
        BigDecimal espacoLivre = new BigDecimal(file.getFreeSpace());
        return espacoLivre.divide(MIL_VINTE_QUATRO.multiply(MIL_VINTE_QUATRO), 6, 6).setScale(2, 6);
    }

    public static BigDecimal getEspacoTotal(String diretorio) {
        File file = new File(diretorio);
        BigDecimal espacoTotal = new BigDecimal(file.getTotalSpace());
        return espacoTotal.divide(MIL_VINTE_QUATRO.multiply(MIL_VINTE_QUATRO), 6, 6).setScale(2, 6);
    }

    public static boolean isExisteInstalacaoPostgresOuCaminhoConfigurado(String diretorio) {
        return Files.exists(Paths.get(SystemUtil.getDiretorioPostgres((String)diretorio) + "pg_dump.exe", new String[0]), new LinkOption[0]) || Files.exists(Paths.get("../pg/bin/pg_dump.exe", new String[0]), new LinkOption[0]);
    }

    public static void espera(int tempo) {
        try {
            Thread.sleep(tempo);
        }
        catch (InterruptedException ex) {
            log.error("Erro thread sleep", (Throwable)ex);
        }
    }
}

