/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AtacarejoItemInterface;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoPautaPreco;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoPromocao;
import br.intelidata.commons.domain.regranegocio.AtacarejoWeb;
import br.intelidata.commons.domain.regranegocio.CalcularItemAtacarejoWeb;
import br.intelidata.commons.domain.regranegocio.CondicaoPagamentoCommonRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.FamiliaProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.ProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.PromocaoCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.stereotype.Service;

@Service
public class AtacarejoService
implements AtacarejoWeb {
    private final FuncionalidadeService funcionalidadeService;

    public AtacarejoService(FuncionalidadeService funcionalidadeService) {
        this.funcionalidadeService = funcionalidadeService;
    }

    public ProdutoPreco getPrecoAtacarejo(Long pauta, ProdutoDTOWeb produto, Long idEmbalagem, Sessao sessao) {
        BigDecimal preco;
        ProdutoPreco produtoPreco = new ProdutoPreco();
        Embalagem embalagem = (Embalagem)EmbalagemRN.getInstance().buscarPorId(idEmbalagem);
        if (embalagem != null && !NumberUtil.bigDecimalNullOrZero((BigDecimal)(preco = embalagem.getPreco()))) {
            produtoPreco.setPreco(preco);
            return produtoPreco;
        }
        if (produto != null) {
            int casasDecimais = produto.getCasasDecimais();
            if (casasDecimais == 0) {
                casasDecimais = 2;
            }
            BigDecimal preco2 = produto.getPreco().setScale(casasDecimais, RoundingMode.HALF_EVEN);
            BigDecimal precoFilial = BigDecimal.ZERO;
            BigDecimal precoFilialGravado = FormacaoPrecoProdutoRN.getInstance().getPrecoProduto(sessao.getIdFilial(), produto.getId());
            if (precoFilialGravado != null) {
                precoFilial = precoFilialGravado;
            }
            precoFilial = precoFilial.setScale(casasDecimais, RoundingMode.HALF_EVEN);
            if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
                if (precoFilial.compareTo(BigDecimal.ZERO) > 0) {
                    produtoPreco.setPreco(precoFilial);
                } else {
                    produtoPreco.setPreco(preco2);
                }
            } else {
                produtoPreco.setPreco(preco2);
            }
            if (pauta != null && (pauta >= 1L && pauta <= 4L || FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO))) {
                BigDecimal precoCalculado = BigDecimal.ZERO;
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
                    ProdutoPautaPreco produtoPautaPreco = ProdutoPautaPrecoRN.getInstance().buscarPorIdProdutoPauta(produto.getId(), sessao.getIdFilial(), pauta);
                    if (produtoPautaPreco != null) {
                        precoCalculado = produtoPautaPreco.getPreco().setScale(casasDecimais, RoundingMode.HALF_EVEN);
                    }
                } else {
                    precoCalculado = ((BigDecimal)BeanUtil.get((Object)produto, (String)("precoPauta" + pauta), (Object[])new Object[0])).setScale(casasDecimais, RoundingMode.HALF_EVEN);
                }
                produtoPreco.setPreco(precoCalculado);
            }
            PromocaoCommonRN.getInstance().buscaPromocaoProduto(SessaoUtil.getSessao(), produtoPreco, produto.getId(), pauta, null, produto.getIdHierarquia(), produto.getIdFornecedor(), produto.getIdFamilia(), null, Integer.valueOf(casasDecimais), TipoPromocao.VALOR, null, false);
        }
        return produtoPreco;
    }

    public Long buscaPautaAtacarejo(ProdutoDTOWeb produto, BigDecimal quantidade, Sessao sessao) {
        Long pauta = -1L;
        if (this.isProdutoTemPautaQuantidadeMinima(sessao, produto)) {
            TreeMap<BigDecimal, Long> mapaOrdenadoPauta = new TreeMap<BigDecimal, Long>();
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
                List pautas = ProdutoPautaPrecoRN.getInstance().buscarListaPorIdProdutoFilial(produto.getId(), sessao.getIdFilial());
                pautas.forEach(produtoPautaPreco -> mapaOrdenadoPauta.put(produtoPautaPreco.getQuantidade(), produtoPautaPreco.getIdPauta()));
            } else {
                if (this.isPautaAtiva(sessao, 6) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta1())) {
                    mapaOrdenadoPauta.put(produto.getQuantidadePauta1(), 1L);
                }
                if (this.isPautaAtiva(sessao, 9) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta2())) {
                    mapaOrdenadoPauta.put(produto.getQuantidadePauta2(), 2L);
                }
                if (this.isPautaAtiva(sessao, 12) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta3())) {
                    mapaOrdenadoPauta.put(produto.getQuantidadePauta3(), 3L);
                }
                if (this.isPautaAtiva(sessao, 15) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta4())) {
                    mapaOrdenadoPauta.put(produto.getQuantidadePauta4(), 4L);
                }
            }
            for (Map.Entry entry : mapaOrdenadoPauta.entrySet()) {
                if (((BigDecimal)entry.getKey()).compareTo(BigDecimal.ZERO) <= 0 || quantidade.compareTo((BigDecimal)entry.getKey()) < 0) continue;
                pauta = (Long)entry.getValue();
            }
        } else {
            FamiliaProduto familia = (FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(produto.getIdFamilia());
            pauta = this.buscaPautaAtacarejoFamilia(sessao, produto, familia, quantidade);
        }
        return pauta;
    }

    public boolean isAtacarejoHabilitado(Sessao sessao, Long idEntidade) {
        boolean habilitar;
        boolean bl = habilitar = this.funcionalidadeService.isAtiva(Funcionalidade.ATACAREJO) && !sessao.getFilial().isDesabilitarAtacarejo();
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 634)) {
            if (NumberUtil.longNullOuZero((Long)idEntidade)) {
                return false;
            }
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
            return entidade != null && entidade.isClienteAtacarejo();
        }
        return habilitar;
    }

    public Long buscaPautaAtacarejoFamilia(Sessao sessao, ProdutoDTOWeb produto, FamiliaProduto familia, BigDecimal quantidade) {
        if (!this.isFamiliaTemPautaQuantidadeMinima(sessao, familia) || this.isProdutoTemPautaQuantidadeMinima(sessao, produto)) {
            return -1L;
        }
        TreeMap<BigDecimal, Long> mapaOrdenadoPauta = new TreeMap<BigDecimal, Long>();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            List pautasFamilia = FamiliaProdutoPautaPrecoRN.getInstance().buscarListaPorIdFamiliaFilial(familia.getId());
            if (!Util.listNullOrEmpty((List)pautasFamilia)) {
                pautasFamilia.forEach(f -> mapaOrdenadoPauta.put(f.getQuantidade(), f.getIdPauta()));
            }
        } else {
            if (this.isPautaAtiva(sessao, 6)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta1(), 1L);
            }
            if (this.isPautaAtiva(sessao, 9)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta2(), 2L);
            }
            if (this.isPautaAtiva(sessao, 12)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta3(), 3L);
            }
            if (this.isPautaAtiva(sessao, 15)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta4(), 4L);
            }
        }
        Long pauta = -1L;
        for (Map.Entry entry : mapaOrdenadoPauta.entrySet()) {
            if (((BigDecimal)entry.getKey()).compareTo(BigDecimal.ZERO) <= 0 || quantidade.compareTo((BigDecimal)entry.getKey()) < 0) continue;
            pauta = (Long)entry.getValue();
        }
        return pauta;
    }

    private boolean isFamiliaTemPautaQuantidadeMinima(Sessao sessao, FamiliaProduto familia) {
        boolean result = false;
        if (familia != null) {
            result = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? FamiliaProdutoPautaPrecoRN.getInstance().isPossuiQuantidadeMinima(familia.getId()) : this.temPauta(sessao, familia.getQuantidadePauta1(), familia.getQuantidadePauta2(), familia.getQuantidadePauta3(), familia.getQuantidadePauta4());
        }
        return result;
    }

    private boolean isProdutoTemPautaQuantidadeMinima(Sessao sessao, ProdutoDTOWeb produto) {
        boolean result = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO) ? ProdutoPautaPrecoRN.getInstance().isPossuiQuantidadeMinima(produto.getId(), SessaoUtil.getSessao().getIdFilial()) : this.temPauta(sessao, produto.getQuantidadePauta1(), produto.getQuantidadePauta2(), produto.getQuantidadePauta3(), produto.getQuantidadePauta4());
        return result;
    }

    private boolean temPauta(Sessao sessao, BigDecimal quantidadePauta1, BigDecimal quantidadePauta2, BigDecimal quantidadePauta3, BigDecimal quantidadePauta4) {
        BigDecimal qtd = BigDecimal.ZERO;
        if (this.isPautaAtiva(sessao, 6)) {
            qtd = qtd.add(quantidadePauta1);
        }
        if (this.isPautaAtiva(sessao, 9)) {
            qtd = qtd.add(quantidadePauta2);
        }
        if (this.isPautaAtiva(sessao, 12)) {
            qtd = qtd.add(quantidadePauta3);
        }
        if (this.isPautaAtiva(sessao, 15)) {
            qtd = qtd.add(quantidadePauta4);
        }
        boolean result = qtd.compareTo(BigDecimal.ZERO) > 0;
        return result;
    }

    private boolean isPautaAtiva(Sessao sessao, int pauta) {
        return PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), pauta);
    }

    public void atualizaProdutosAtacarejo(Sessao sessao, ProdutoDTOWeb produto, List<AtacarejoItemInterface> itens, Long idCliente, Long idCondicaoPagamento, CalcularItemAtacarejoWeb calcularItemAtacarejoWeb) {
        if (this.isProdutoTemPautaQuantidadeMinima(sessao, produto)) {
            Long pauta = this.buscaPautaAtacarejo(sessao, produto, itens);
            for (AtacarejoItemInterface item : itens) {
                if (!item.getIdProduto().equals(produto.getId())) continue;
                this.atualizaFaturamentoItemAtacarejo(sessao, produto, item, pauta, idCliente, idCondicaoPagamento, calcularItemAtacarejoWeb);
            }
        } else {
            FamiliaProduto familia = (FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(produto.getIdFamilia());
            if (!this.isFamiliaTemPautaQuantidadeMinima(sessao, familia)) {
                return;
            }
            Long pauta = this.buscaPautaAtacarejoFamilia(sessao, produto, familia, itens);
            for (AtacarejoItemInterface item : itens) {
                ProdutoDTOWeb p;
                if (item.isCancelado() || item.getIdFamilia() == null || !item.getIdFamilia().equals(produto.getIdFamilia()) || (p = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdProduto())) == null || this.isProdutoTemPautaQuantidadeMinima(sessao, p)) continue;
                this.atualizaFaturamentoItemAtacarejo(sessao, p, item, pauta, idCliente, idCondicaoPagamento, calcularItemAtacarejoWeb);
            }
        }
    }

    private void atualizaFaturamentoItemAtacarejo(Sessao sessao, ProdutoDTOWeb produto, AtacarejoItemInterface item, Long pauta, Long idCliente, Long idCondicaoPagamento, CalcularItemAtacarejoWeb calcularItemAtacarejoWeb) {
        BigDecimal preco;
        ProdutoPreco produtoPreco = null;
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        Long idCategoriaCliente = entidade != null ? entidade.getIdCategoriaCliente() : null;
        BigDecimal ultimoPrecoUnitarioInformadoPauta = item.getMapPrecoUnitarioInformadoPorPauta().getOrDefault(pauta, BigDecimal.ZERO);
        if (this.isAtacarejoHabilitado(sessao, idCliente) && !NumberUtil.longNullOuZero((Long)pauta) && pauta > 0L) {
            produtoPreco = this.getPrecoAtacarejo(pauta, produto, item.getIdEmbalagem(), sessao);
        } else if (Util.bigDecimalNullOrZero((BigDecimal)ultimoPrecoUnitarioInformadoPauta)) {
            ConsultaPrecoProduto consultaPrecoProduto = new ConsultaPrecoProduto(sessao.getFilial(), item.getIdProduto(), pauta, VariacaoRN.getInstance().stringToMap(item.getVariacoes()), item.getIdEmbalagem());
            consultaPrecoProduto.setIdCategoriaCliente(idCategoriaCliente);
            produtoPreco = ProdutoRN.getInstance().getPreco(consultaPrecoProduto);
        }
        BigDecimal descontoPromocao = BigDecimal.ZERO;
        if (produtoPreco != null) {
            if (produtoPreco.getPrecoPromocao().compareTo(BigDecimal.ZERO) > 0 && produtoPreco.getPrecoPromocao().compareTo(produtoPreco.getPreco()) < 0) {
                preco = this.calcularPrecoPorCondicaoPagamento(produtoPreco.getPrecoPromocao(), produto.getCasasDecimais(), item.getIdPromocao(), idCondicaoPagamento, sessao);
                descontoPromocao = produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao());
            } else {
                preco = this.calcularPrecoPorCondicaoPagamento(produtoPreco.getPreco(), produto.getCasasDecimais(), item.getIdPromocao(), idCondicaoPagamento, sessao);
            }
        } else {
            preco = ultimoPrecoUnitarioInformadoPauta;
        }
        if (preco.compareTo(item.getPreco()) != 0) {
            item.setPreco(preco);
            item.setDescontoPromocao(descontoPromocao);
            if (produtoPreco != null) {
                item.setIdPromocao(produtoPreco.getIdPromocao());
                item.setPrecoOriginal(produtoPreco.getPreco());
            }
            item.setPrecoComAcrecimo(item.getPreco());
            item.setDesconto(Util.valorDesconto((BigDecimal)item.getPreco().multiply(item.getQuantidade()), (BigDecimal)item.getPercentualDesconto(), (int)2));
            calcularItemAtacarejoWeb.calcular(item);
            if (!item.getMapPrecoUnitarioInformadoPorPauta().containsKey(pauta)) {
                item.getMapPrecoUnitarioInformadoPorPauta().put(pauta, item.getPrecoComAcrecimo());
            }
            item.setPautaPreco(pauta);
        }
    }

    private Long buscaPautaAtacarejo(Sessao sessao, ProdutoDTOWeb produto, List<AtacarejoItemInterface> itens) {
        if (produto == null || !this.isProdutoTemPautaQuantidadeMinima(sessao, produto)) {
            return -1L;
        }
        BigDecimal quantidade = BigDecimal.ZERO;
        for (AtacarejoItemInterface item : itens) {
            if (!item.getIdProduto().equals(produto.getId())) continue;
            quantidade = quantidade.add(item.getQuantidade());
        }
        TreeMap<BigDecimal, Long> mapaOrdenadoPauta = new TreeMap<BigDecimal, Long>();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            List pautas = ProdutoPautaPrecoRN.getInstance().buscarListaPorIdProdutoFilial(produto.getId(), SessaoUtil.getSessao().getIdFilial());
            pautas.forEach(produtoPautaPreco -> mapaOrdenadoPauta.put(produtoPautaPreco.getQuantidade(), produtoPautaPreco.getIdPauta()));
        } else {
            if (this.isPautaAtiva(sessao, 6) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta1())) {
                mapaOrdenadoPauta.put(produto.getQuantidadePauta1(), 1L);
            }
            if (this.isPautaAtiva(sessao, 9) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta2())) {
                mapaOrdenadoPauta.put(produto.getQuantidadePauta2(), 2L);
            }
            if (this.isPautaAtiva(sessao, 12) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta3())) {
                mapaOrdenadoPauta.put(produto.getQuantidadePauta3(), 3L);
            }
            if (this.isPautaAtiva(sessao, 15) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoPauta4())) {
                mapaOrdenadoPauta.put(produto.getQuantidadePauta4(), 4L);
            }
        }
        Long pauta = -1L;
        for (Map.Entry entry : mapaOrdenadoPauta.entrySet()) {
            if (((BigDecimal)entry.getKey()).compareTo(BigDecimal.ZERO) <= 0 || quantidade.compareTo((BigDecimal)entry.getKey()) < 0) continue;
            pauta = (Long)entry.getValue();
        }
        return pauta;
    }

    private Long buscaPautaAtacarejoFamilia(Sessao sessao, ProdutoDTOWeb produto, FamiliaProduto familia, List<AtacarejoItemInterface> items) {
        if (!this.isFamiliaTemPautaQuantidadeMinima(sessao, familia) || this.isProdutoTemPautaQuantidadeMinima(sessao, produto)) {
            return -1L;
        }
        BigDecimal quantidade = BigDecimal.ZERO;
        for (AtacarejoItemInterface item : items) {
            ProdutoDTOWeb p;
            if (item.isCancelado() || item.getIdFamilia() == null || !item.getIdFamilia().equals(familia.getId()) || (p = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, item.getIdProduto())) == null || this.isProdutoTemPautaQuantidadeMinima(sessao, p)) continue;
            quantidade = quantidade.add(item.getQuantidade());
        }
        TreeMap<BigDecimal, Long> mapaOrdenadoPauta = new TreeMap<BigDecimal, Long>();
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            List pautasFamilia = FamiliaProdutoPautaPrecoRN.getInstance().buscarListaPorIdFamiliaFilial(familia.getId());
            if (!Util.listNullOrEmpty((List)pautasFamilia)) {
                pautasFamilia.forEach(f -> mapaOrdenadoPauta.put(f.getQuantidade(), f.getIdPauta()));
            }
        } else {
            if (this.isPautaAtiva(sessao, 6)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta1(), 1L);
            }
            if (this.isPautaAtiva(sessao, 9)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta2(), 2L);
            }
            if (this.isPautaAtiva(sessao, 12)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta3(), 3L);
            }
            if (this.isPautaAtiva(sessao, 15)) {
                mapaOrdenadoPauta.put(familia.getQuantidadePauta4(), 4L);
            }
        }
        Long pauta = -1L;
        for (Map.Entry entry : mapaOrdenadoPauta.entrySet()) {
            if (((BigDecimal)entry.getKey()).compareTo(BigDecimal.ZERO) <= 0 || quantidade.compareTo((BigDecimal)entry.getKey()) < 0) continue;
            pauta = (Long)entry.getValue();
        }
        return pauta;
    }

    private BigDecimal calcularPrecoPorCondicaoPagamento(BigDecimal preco, int casasDecimaisPrecoProduto, Long idPromocao, Long idCondicaoPagamento, Sessao sessao) {
        CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoCommonRN.getInstance().buscarPorId(idCondicaoPagamento);
        if (condicaoPagamento != null && (DescontoRN.getInstance().isPermiteDescontoCondicaoPagamento(sessao.getFilial(), condicaoPagamento) || Util.longNullOuZero((Long)idPromocao)) && condicaoPagamento.getFator().compareTo(BigDecimal.ZERO) > 0) {
            if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) > 0) {
                return condicaoPagamento.getFator().multiply(preco).setScale(casasDecimaisPrecoProduto, RoundingMode.DOWN);
            }
            if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) < 0) {
                return preco.subtract(condicaoPagamento.getFator().multiply(preco).setScale(casasDecimaisPrecoProduto, RoundingMode.DOWN));
            }
        }
        return preco;
    }
}

