/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Pedido;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.uniplusshop.TextoEmailDefaultShop;
import br.intelidata.core.base.IEmailCompraShop;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"taskManager"})
@Service
public class EmailCompraShop
implements IEmailCompraShop {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TaskManager taskManager;

    public EmailCompraShop(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public void enviarEmailCompra(Long codPedido) {
        Pedido pedido = (Pedido)PedidoRN.getInstance().buscarPorCodigoLong(codPedido);
        Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(pedido.getIdCliente());
        if (cliente != null && !Util.stringNullOrEmpty((String)cliente.getEmail())) {
            TextoGenerico textoGenerico = TextoEmailDefaultShop.replaceCompraPedido((Pedido)pedido);
            try {
                ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessao(), (String)cliente.getEmail(), null, (String)textoGenerico.getAssunto(), (String)textoGenerico.getTexto());
                CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Envio de mercadoria");
                taskEmail.createTask((Object)parametrosEmailWeb, parametrosEmailWeb.getAssunto());
            }
            catch (UnicoMensagemUsuarioException e) {
                this.log.error("Erro ao enviar email de confirma\u00e7\u00e3o de compra.", (Throwable)e);
            }
        }
    }
}

