/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.regranegocio.ConfiguradorFuncionalidadeCommonRN;
import br.intelidata.core.dashboard.base.interfaces.IFuncionalidadeSistema;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.TipoCache;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class FuncionalidadeService
implements IFuncionalidadeSistema {
    private final CacheService cacheService;

    public FuncionalidadeService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public boolean isAtiva(Funcionalidade funcionalidade) {
        if (!funcionalidade.isValidarNoBanco()) {
            return funcionalidade.getInterfaceFuncionalidade().isLicenciado();
        }
        Boolean ativa = (Boolean)this.getMapFuncionalidade().get(funcionalidade.getId());
        if (ativa == null) {
            Boolean valorPropriedade;
            try {
                valorPropriedade = ConfiguradorFuncionalidadeCommonRN.getInstance().getValorPreferenciaSubstituta(funcionalidade);
            }
            catch (Throwable ex) {
                valorPropriedade = null;
            }
            ativa = valorPropriedade != null ? valorPropriedade : Boolean.valueOf(funcionalidade.getInterfaceFuncionalidade().isLicenciado() && funcionalidade.getInterfaceFuncionalidade().isValorDefault());
            this.getMapFuncionalidade().put(funcionalidade.getId(), ativa);
        }
        return ativa;
    }

    public Map<String, Boolean> getMapFuncionalidadeAtivas() {
        return Stream.of(Funcionalidade.values()).filter(f -> f.getInterfaceFuncionalidade().isAtivado()).collect(Collectors.toMap(Enum::name, f -> true, (f1, f2) -> f2, LinkedHashMap::new));
    }

    public boolean programacaoPreco(Sessao sessao) {
        return this.isAtiva(Funcionalidade.PROGRAMAR_PRECO) && PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 348);
    }

    public synchronized Map<Integer, Boolean> getMapFuncionalidade() {
        Map mapFuncionalidades = null;
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_FUNCIONALIDADE.getId());
        if (wrapper != null) {
            mapFuncionalidades = (Map)wrapper.get();
        }
        if (mapFuncionalidades == null) {
            mapFuncionalidades = ConfiguradorFuncionalidadeCommonRN.getInstance().buscarMapFuncionalidades();
            this.cacheService.put((Object)TipoCache.ID_FUNCIONALIDADE.getId(), (Object)mapFuncionalidades);
        }
        return mapFuncionalidades;
    }
}

