/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TenantLocalService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String token;
    private final JdbcTemplate jdbcTemplate;
    private final DataSource dataSource;
    private final ConnectionOAuth2Service connectionOAuth2Service;
    private final UnipluswebProperties unipluswebProperties;

    public TenantLocalService(@Value(value="${uniplusweb.ambiente.tokenInstancia}") String token, DataSource dataSource, ConnectionOAuth2Service connectionOAuth2Service, UnipluswebProperties unipluswebProperties) {
        this.token = token;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        this.dataSource = dataSource;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.unipluswebProperties = unipluswebProperties;
    }

    public boolean atualizarTenants() {
        boolean tenantsAtualizados;
        block19: {
            if (!StringUtil.stringNullOrEmpty((String)this.unipluswebProperties.getTenantLocal().getTenant()) && !StringUtil.stringNullOrEmpty((String)this.unipluswebProperties.getTenantLocal().getNomeBase())) {
                Object id;
                String tenant = this.unipluswebProperties.getTenantLocal().getTenant();
                String nomeBase = this.unipluswebProperties.getTenantLocal().getNomeBase();
                try {
                    id = this.jdbcTemplate.queryForObject("SELECT id FROM tenant WHERE codigo = ?", Object.class, new Object[]{tenant});
                }
                catch (EmptyResultDataAccessException ex) {
                    id = null;
                }
                if (id == null || id.toString().isEmpty()) {
                    this.jdbcTemplate.update("INSERT INTO tenant(codigo, descricao, inativo, inicializado, urldatabase) values (?, ?, ?, ?, ?)", new Object[]{tenant, tenant, 0, 0, "jdbc:postgresql://localhost:5432/" + nomeBase});
                }
            }
            tenantsAtualizados = false;
            if (!StringUtil.stringNullOrEmpty((String)this.token)) {
                this.log.info("Verificando tenants configurados no Logtracker");
                try {
                    ResponseEntity response = this.connectionOAuth2Service.get("/tenants-locais-2/" + this.token, List.class, new Object[0]);
                    if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
                        List responseBody = (List)response.getBody();
                        List tenants = responseBody.stream().map(map -> new Tenant((String)map.get("codigo"), (String)map.get("descricao"), 0, 0)).collect(Collectors.toList());
                        if (ListMapUtil.listNullOrEmpty(tenants)) {
                            this.jdbcTemplate.update("UPDATE tenant SET inativo = 1");
                            return true;
                        }
                        for (Tenant tenant : tenants) {
                            String codigoTenant = tenant.getCodigo();
                            String descricaoTenant = tenant.getDescricao();
                            try {
                                Object id;
                                try {
                                    id = this.jdbcTemplate.queryForObject("SELECT id FROM tenant WHERE codigo = ?", Object.class, new Object[]{codigoTenant});
                                }
                                catch (EmptyResultDataAccessException ex) {
                                    id = null;
                                }
                                if (id == null || id.toString().isEmpty()) {
                                    String database = "uniplusweb_" + codigoTenant.toLowerCase();
                                    if (!this.existeDataBase(database)) {
                                        this.jdbcTemplate.execute("CREATE DATABASE " + database);
                                    }
                                    this.jdbcTemplate.update("INSERT INTO tenant(codigo, descricao, inativo, inicializado, urldatabase) values (?, ?, ?, ?, ?)", new Object[]{codigoTenant, descricaoTenant, 0, 0, "jdbc:postgresql://localhost:5432/" + database});
                                    continue;
                                }
                                long idTenant = Long.parseLong(id.toString());
                                this.jdbcTemplate.update("UPDATE tenant SET inativo = 0, descricao = ? WHERE id = ?", new Object[]{descricaoTenant, idTenant});
                            }
                            catch (Exception ex) {
                                this.log.error("N\u00e3o foi poss\u00edvel gravar o tenant: " + codigoTenant, (Throwable)ex);
                            }
                        }
                        NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(this.dataSource);
                        List idsNaoExistentes = template.queryForList("SELECT id FROM tenant WHERE codigo NOT IN (:codigos)", Collections.singletonMap("codigos", tenants.stream().map(Tenant::getCodigo).collect(Collectors.toList())), Long.class);
                        if (!ListMapUtil.listNullOrEmpty((List)idsNaoExistentes)) {
                            for (Long id : idsNaoExistentes) {
                                this.jdbcTemplate.update("UPDATE tenant SET inativo = 1 WHERE id = ?", new Object[]{id});
                            }
                        }
                        tenantsAtualizados = true;
                        this.log.info("Verifica\u00e7\u00e3o de tenants conclu\u00edda com sucesso.");
                        break block19;
                    }
                    this.log.error("N\u00e3o foi poss\u00edvel se conectar ao Logtracker para buscar os tenants da instancia: {}", (Object)this.token);
                }
                catch (Exception ex) {
                    this.log.error("N\u00e3o foi poss\u00edvel se conectar ao Logtracker para buscar os tenants da instancia: " + this.token, (Throwable)ex);
                }
            } else {
                this.log.info("Token n\u00e3o informado para buscar os tenants na inst\u00e2ncia.");
            }
        }
        return tenantsAtualizados;
    }

    public boolean existeDataBase(String nomeDataBase) {
        String database;
        try {
            database = (String)this.jdbcTemplate.queryForObject("SELECT datname FROM pg_database WHERE datname=?", String.class, new Object[]{nomeDataBase});
        }
        catch (EmptyResultDataAccessException ex) {
            database = null;
        }
        return !StringUtil.stringNullOrEmpty(database);
    }
}

