/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.whatsapp.TipoIntegracaoWhatsAppEnum;
import br.intelidata.commons.core.whatsapp.WhatsApp;
import br.intelidata.commons.core.whatsapp.WhatsGW;
import br.intelidata.commons.domain.pojo.enuns.TipoMascara;
import br.intelidata.commons.domain.pojo.whatsapp.ConfiguracaoWhatsApp;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoWhatsAppRN;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.StorageService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class WhatsAppService {
    private final StorageService storageService;

    public WhatsAppService(StorageService storageService) {
        this.storageService = storageService;
    }

    public String enviarWhatsApp(List<Notificacao> notificacoes, Sessao sessao) throws UnicoMensagemUsuarioException {
        ConfiguracaoWhatsApp configuracaoWhatsApp = ConfiguracaoWhatsAppRN.getInstance().buscaConfiguracaoUsuario(sessao);
        if (configuracaoWhatsApp.getTipoIntegracao().equals((Object)TipoIntegracaoWhatsAppEnum.PADRAO)) {
            ArrayList arquivos = new ArrayList();
            for (Notificacao notificacao : notificacoes) {
                if (notificacao.getMalote() == null || ListMapUtil.mapNullOrEmpty((Map)notificacao.getMalote().getMapArquivos())) continue;
                arquivos.addAll(this.storageService.share(notificacao.getMalote()));
            }
            return notificacoes.get(0).getMsg().concat(Util.newLine() + Util.newLine()).concat(String.join((CharSequence)(Util.newLine() + Util.newLine()), arquivos));
        }
        if (configuracaoWhatsApp.getTipoIntegracao().equals((Object)TipoIntegracaoWhatsAppEnum.WHATS_GW)) {
            WhatsApp whatsApp = this.getIntegracaoWhatsApp(configuracaoWhatsApp);
            for (Notificacao notificacao : notificacoes) {
                whatsApp.enviarMensagem(Util.limpaMascara((String)notificacao.getFone(), (String)TipoMascara.TELEFONE_9_DIGITOS.getId()), notificacao.getMsg(), notificacao.getMalote());
            }
        }
        return null;
    }

    private WhatsApp getIntegracaoWhatsApp(ConfiguracaoWhatsApp configuracaoWhatsApp) {
        String telefone;
        return new WhatsGW(telefone.substring((telefone = Util.apenasNumeros((String)configuracaoWhatsApp.getTelefone())).startsWith("0") ? 1 : 0), configuracaoWhatsApp);
    }
}

