/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.dashboard.base;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.dashboard.ConfiguracaoDashBoard;
import br.intelidata.commons.domain.pojo.dashboard.PermissaoDashBoard;
import br.intelidata.commons.domain.pojo.enuns.TipoPermissao;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoDashBoardCommonRN;
import br.intelidata.commons.domain.regranegocio.PermissaoDashBoardCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.core.dashboard.base.interfaces.Widget;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.dashboard.base.wrapper.ConfiguracaoDashboardWrapper;
import br.intelidata.uniplusweb.web.dashboard.base.wrapper.WidgetWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="dashboard_manager")
@RequestMapping(value={"/api/dashboard_manager"})
public class DashBoardManagerController {
    private final Map<String, Widget> widgets;
    private final CacheService cacheService;

    @Autowired
    public DashBoardManagerController(Map<String, Widget> widgets, CacheService cacheService) {
        this.widgets = widgets;
        this.cacheService = cacheService;
    }

    @RequestMapping(value={"/widgets"})
    @DBAutoCommit
    public WidgetWrapper getWidgetsDisponiveis() {
        HashMap widgetsDisponiveis = new HashMap();
        Usuario usuario = SessaoUtil.getSessao().getUsuario();
        Long idPerfil = usuario.getIdPerfil();
        boolean usuarioAdm = usuario.isAdministrador();
        Map permissoes = PermissaoDashBoardCommonRN.getInstance().buscarPorPerfilWeb(idPerfil).stream().filter(permissaoDashBoard -> !StringUtil.stringNullOrEmpty((String)permissaoDashBoard.getCodigoDashBoard())).collect(Collectors.toMap(PermissaoDashBoard::getCodigoDashBoard, Function.identity()));
        this.widgets.entrySet().stream().filter(entry -> {
            PermissaoDashBoard permissao = (PermissaoDashBoard)permissoes.get(entry.getKey());
            boolean perfilLiberado = usuarioAdm || permissao != null && permissao.getPermissao().equals((Object)TipoPermissao.ACESSO_LIBERADO);
            return perfilLiberado && ((Widget)entry.getValue()).isLicenciado();
        }).forEach(entry -> {
            List widgets = widgetsDisponiveis.getOrDefault(((Widget)entry.getValue()).getCategoria(), new ArrayList());
            widgets.add(entry.getKey());
            widgetsDisponiveis.putIfAbsent(((Widget)entry.getValue()).getCategoria(), widgets);
        });
        return new WidgetWrapper(widgetsDisponiveis, ConfiguracaoDashBoardCommonRN.getInstance().buscarConfiguracoesPorUsuario(usuario.getId()));
    }

    @RequestMapping(value={"/incluir-widget/{codigo}/posicao/{posicao}"}, method={RequestMethod.POST})
    @DBTransaction
    public Long incluirWidget(@PathVariable String codigo, @PathVariable int posicao) throws UnicoMensagemUsuarioException {
        Widget widget = (Widget)this.widgets.get(codigo);
        if (widget == null) {
            throw new UnicoMensagemUsuarioException("WWW460", "Dashboard " + codigo + " n\u00e3o encontrado.");
        }
        Usuario usuario = SessaoUtil.getSessao().getUsuario();
        ConfiguracaoDashBoard configuracao = new ConfiguracaoDashBoard();
        configuracao.setIdUsuario(usuario.getId());
        configuracao.setCodigoGrafico(codigo);
        configuracao.setPosicao(posicao);
        Long idWidget = this.gravarConfiguracaoGrafico(configuracao);
        if (!usuario.isConfigurouDashboard()) {
            usuario.setConfigurouDashboard(true);
            UsuarioRN.getInstance().alterar(usuario, SessaoUtil.getSessao());
        }
        return idWidget;
    }

    @RequestMapping(value={"/salvar-configuracao-grafico"}, method={RequestMethod.POST})
    @DBTransaction
    public Long gravarConfiguracaoGrafico(@RequestBody ConfiguracaoDashBoard configuracao) throws UnicoMensagemUsuarioException {
        Long id;
        Sessao sessao = SessaoUtil.getSessao();
        Usuario usuario = sessao.getUsuario();
        if (NumberUtil.longNullOuZero((Long)configuracao.getIdUsuario())) {
            configuracao.setIdUsuario(usuario.getId());
        }
        if (!NumberUtil.longNullOuZero((Long)configuracao.getId())) {
            id = configuracao.getId();
            ConfiguracaoDashBoardCommonRN.getInstance().gravar(1, (AbstractPojo)configuracao, sessao);
        } else {
            configuracao.setIdUsuario(usuario.getId());
            id = ConfiguracaoDashBoardCommonRN.getInstance().gravar(0, (AbstractPojo)configuracao, sessao);
        }
        if (!usuario.isConfigurouDashboard()) {
            usuario.setConfigurouDashboard(true);
            UsuarioRN.getInstance().alterar(usuario, sessao);
        }
        return id;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void excluirGrafico(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        ConfiguracaoDashBoard config = (ConfiguracaoDashBoard)ConfiguracaoDashBoardCommonRN.getInstance().buscarPorId(id);
        Sessao sessao = SessaoUtil.getSessao();
        Usuario usuario = sessao.getUsuario();
        ConfiguracaoDashBoardCommonRN.getInstance().excluir((AbstractPojo)config, sessao);
        if (!usuario.isConfigurouDashboard()) {
            usuario.setConfigurouDashboard(true);
            UsuarioRN.getInstance().alterar(usuario, sessao);
        }
    }

    @RequestMapping(value={"/buscar-config"})
    @DBAutoCommit
    public ConfiguracaoDashboardWrapper buscarConfiguracao() {
        ConfiguracaoDashboardWrapper config = new ConfiguracaoDashboardWrapper();
        Sessao sessao = SessaoUtil.getSessao();
        config.setExibirAoIniciar(!sessao.getUsuario().isDesativarDashboardLogin());
        config.setFiltrarFilialInativa(PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getIdFilial(), 2000000));
        return config;
    }

    @PostMapping(value={"/gravar-config"})
    @DBTransaction
    public void gravarConfiguracao(@RequestBody ConfiguracaoDashboardWrapper config) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(sessao.getUsuario().getId());
        usuario.setDesativarDashboardLogin(!config.isExibirAoIniciar());
        UsuarioRN.getInstance().alterar(usuario, sessao);
        PropriedadeRN.getInstance().setPropriedade(sessao, 2000000, Boolean.valueOf(config.isFiltrarFilialInativa()));
        this.cacheService.clear();
    }
}

