/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.calculoimposto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.ParametrosNotaFiscalInterface;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoItem;
import br.intelidata.commons.domain.pojo.enuns.FinalidadeEmissaoNfeCFOP;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.notafiscal.TipoCalculoImposto;
import br.intelidata.commons.domain.pojo.notafiscal.ItemTributavelInterface;
import br.intelidata.commons.domain.regranegocio.notafiscal.CalculoImposto;
import br.intelidata.commons.domain.regranegocio.notafiscal.ControleAcaoComponenteItemTributavel;
import br.intelidata.commons.domain.wrapper.ImpostoWrapper;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NaturezaOperacaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.OperacaoFiscalRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ImpostoCalculadoWrapper;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CalculoImpostoService<ITEM extends ProdutoItem> {
    public ImpostoCalculadoWrapper<ITEM> atualizarComponentes(ImpostoWrapper<ITEM> impostoWrapper) {
        ProdutoItem item = impostoWrapper.getItem();
        String situacaoTributariaIcmsNormal = item.getSituacaotributaria();
        String situacaoTributariaIcmsSN = item.getSituacaotributariaSN();
        String situacaoTributariaIcms = !StringUtil.stringNullOrEmpty((String)situacaoTributariaIcmsNormal) ? situacaoTributariaIcmsNormal : situacaoTributariaIcmsSN;
        Sessao sessao = SessaoUtil.getSessao();
        Produto produto = CacheSistema.getInstance().getProduto(item.getIdProduto());
        if (!NumberUtil.longNullOuZero((Long)item.getIdCfop())) {
            String codigoCfop = "";
            NaturezaOperacao cfop = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
            if (cfop != null) {
                codigoCfop = cfop.getCodigo();
            }
            item.setCfop(codigoCfop);
        }
        boolean utilizaOperacaoFiscal = this.utilizaOperacaoFiscal(impostoWrapper.getTipoEmissao(), sessao.getIdFilial());
        List acoes = produto.getTipo().equals((Object)TipoRegistroProduto.PRODUTO) ? ControleAcaoComponenteItemTributavel.getInstance().atualizarListaAcaoComponentesProduto(this.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), utilizaOperacaoFiscal), item.getIdProduto(), item.getIdCfop(), utilizaOperacaoFiscal, item.getIdUnidadeMedida(), impostoWrapper.getTransacao(), impostoWrapper.getOrigemDocumentoImportado(), impostoWrapper.getTipoNotaFiscal(), situacaoTributariaIcms, impostoWrapper.getEntidade(), impostoWrapper.isPossuiItens(), item.getSaldoFiscalBaixa(), item.getTipoKit(), impostoWrapper.getTipoEmissao(), impostoWrapper.isTransferencia(), item.getIdPromocao(), item.getIdEntidadeDesconto(), item.getCstPis(), item.getSituacaoTributariaIPI() != null ? item.getSituacaoTributariaIPI().getId() : null, sessao.getFilial(), sessao.getUsuario(), (ItemTributavelInterface)item) : ControleAcaoComponenteItemTributavel.getInstance().atualizarListaAcaoComponentesServico(impostoWrapper.isTransferencia(), item.getIdProduto(), item.getIdPromocao(), item.getIdEntidadeDesconto(), utilizaOperacaoFiscal, impostoWrapper.getTipoNotaFiscal(), item.getCstPis(), item.getCstPis(), sessao.getFilial(), sessao.getUsuario(), (ItemTributavelInterface)item, item.getIdUnidadeMedida(), impostoWrapper.getTransacao());
        return new ImpostoCalculadoWrapper(acoes, item);
    }

    public ImpostoCalculadoWrapper<ITEM> calcularImpostos(ImpostoWrapper<ITEM> impostoWrapper, boolean mapearAcoes) throws UnicoMensagemUsuarioException {
        String cstIPI;
        Sessao sessao = SessaoUtil.getSessao();
        boolean utilizaOperacaoFiscal = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 372);
        ProdutoItem item = impostoWrapper.getItem();
        List acoes = null;
        Produto produto = CacheSistema.getInstance().getProduto(item.getIdProduto());
        String codigoEstado = this.getCodigoEstado(impostoWrapper);
        if (NumberUtil.longNullOuZero((Long)item.getIdCfop())) {
            throw new UnicoMensagemUsuarioException("WWW189", "Natureza de opera\u00e7\u00e3o n\u00e3o encontrada");
        }
        NaturezaOperacao cfop = NaturezaOperacaoRN.getInstance().buscarPorId(item.getIdCfop());
        item.setCfop(cfop.getCodigo());
        ParametrosNotaFiscalInterface parametrosNotaFiscal = this.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), this.utilizaOperacaoFiscal(impostoWrapper.getTipoEmissao(), sessao.getIdFilial()));
        Entidade entidade = impostoWrapper.getEntidade();
        if (impostoWrapper.isCalcularImposto() && !this.isNotaCreditoOuTransferenciaCreditoIcms(parametrosNotaFiscal)) {
            new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, impostoWrapper.getTipoCalculoImposto(), impostoWrapper.getTipoNotaFiscal(), impostoWrapper.getDataEmissao(), codigoEstado, impostoWrapper.getTipoEmissao(), parametrosNotaFiscal, sessao.getFilial(), impostoWrapper.isApenasRecalcularBaseEValor(), impostoWrapper.getOrigem());
        }
        String situacaoTributariaIcmsNormal = item.getSituacaotributaria();
        String situacaoTributariaIcmsSN = item.getSituacaotributariaSN();
        String situacaoTributariaIcms = !StringUtil.stringNullOrEmpty((String)situacaoTributariaIcmsNormal) ? situacaoTributariaIcmsNormal : situacaoTributariaIcmsSN;
        String cstPisCofins = item.getCstPis();
        String string = cstIPI = item.getSituacaoTributariaIPI() != null ? item.getSituacaoTributariaIPI().getId() : null;
        if (mapearAcoes) {
            acoes = produto.getTipo().equals((Object)TipoRegistroProduto.PRODUTO) ? ControleAcaoComponenteItemTributavel.getInstance().atualizarListaAcaoComponentesProduto(parametrosNotaFiscal, item.getIdProduto(), item.getIdCfop(), utilizaOperacaoFiscal, item.getIdUnidadeMedida(), impostoWrapper.getTransacao(), impostoWrapper.getOrigemDocumentoImportado(), impostoWrapper.getTipoNotaFiscal(), situacaoTributariaIcms, entidade, impostoWrapper.isPossuiItens(), item.getSaldoFiscalBaixa(), item.getTipoKit(), impostoWrapper.getTipoEmissao(), impostoWrapper.isTransferencia(), item.getIdPromocao(), item.getIdEntidadeDesconto(), cstPisCofins, cstIPI, sessao.getFilial(), sessao.getUsuario(), (ItemTributavelInterface)item) : ControleAcaoComponenteItemTributavel.getInstance().atualizarListaAcaoComponentesServico(impostoWrapper.isTransferencia(), item.getIdProduto(), item.getIdPromocao(), item.getIdEntidadeDesconto(), utilizaOperacaoFiscal, impostoWrapper.getTipoNotaFiscal(), cstPisCofins, cstPisCofins, sessao.getFilial(), sessao.getUsuario(), (ItemTributavelInterface)item, item.getIdUnidadeMedida(), impostoWrapper.getTransacao());
        }
        return new ImpostoCalculadoWrapper(acoes, item);
    }

    public List<ITEM> recalcularImpostosItens(ImpostoWrapper<ITEM> impostoWrapper) throws UnicoMensagemUsuarioException {
        ParametrosNotaFiscalInterface parametrosNotaFiscal = this.getParametrosNotaFiscalInterface(impostoWrapper.getIdParametrosNF(), this.utilizaOperacaoFiscal(impostoWrapper.getTipoEmissao(), SessaoUtil.getSessao().getIdFilial()));
        Entidade entidade = impostoWrapper.getEntidade();
        String codigoEstado = this.getCodigoEstado(impostoWrapper);
        for (ProdutoItem item : impostoWrapper.getItens()) {
            if (item.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) continue;
            TipoCalculoImposto tipoCalculoImposto = item.getTipo().equalsIgnoreCase("S") ? TipoCalculoImposto.CST_PIS : TipoCalculoImposto.CST_IPI;
            new CalculoImposto().calcularImpostos((ItemTributavelInterface)item, entidade, tipoCalculoImposto, impostoWrapper.getTipoNotaFiscal(), impostoWrapper.getDataEmissao(), codigoEstado, impostoWrapper.getTipoEmissao(), parametrosNotaFiscal, SessaoUtil.getSessao().getFilial(), impostoWrapper.isApenasRecalcularBaseEValor(), impostoWrapper.getOrigem());
        }
        return impostoWrapper.getItens();
    }

    public ParametrosNotaFiscalInterface getParametrosNotaFiscalInterface(Long idParametroNF, boolean utilizaOperacaoFiscal) {
        NaturezaOperacao parametrosNotaFiscal = null;
        if (utilizaOperacaoFiscal && !NumberUtil.longNullOuZero((Long)idParametroNF)) {
            parametrosNotaFiscal = (ParametrosNotaFiscalInterface)OperacaoFiscalRN.getInstance().buscarPorId(idParametroNF);
        } else if (!NumberUtil.longNullOuZero((Long)idParametroNF)) {
            parametrosNotaFiscal = NaturezaOperacaoRN.getInstance().buscarPorId(idParametroNF);
        }
        return parametrosNotaFiscal;
    }

    public TipoIntegracaoFinanceiro getIntegracaoCFOP(Long idParametroNF, boolean utilizaOperacaoFiscal) {
        return this.getIntegracaoCFOP(this.getParametrosNotaFiscalInterface(idParametroNF, utilizaOperacaoFiscal));
    }

    public TipoIntegracaoFinanceiro getIntegracaoCFOP(ParametrosNotaFiscalInterface parametros) {
        return parametros != null && parametros.getIntegracao() != null ? parametros.getIntegracao() : TipoIntegracaoFinanceiro.NENHUM;
    }

    public boolean possuiIntegracaoComFinanceiro(ParametrosNotaFiscalInterface parametrosNotaFiscalInterface) {
        return !this.getIntegracaoCFOP(parametrosNotaFiscalInterface).equals((Object)TipoIntegracaoFinanceiro.NENHUM);
    }

    public TipoValorPreco getTipoValorPreco(Long idParametroFiscal, boolean utilizaOperacaoFiscal) {
        TipoValorPreco tipoPreco = TipoValorPreco.PRECO;
        ParametrosNotaFiscalInterface parametrosCfop = this.getParametrosNotaFiscalInterface(idParametroFiscal, utilizaOperacaoFiscal);
        if (parametrosCfop != null && parametrosCfop.getTipoValorPreco() != null) {
            tipoPreco = parametrosCfop.getTipoValorPreco();
        }
        return tipoPreco;
    }

    public String getCodigoEstado(ImpostoWrapper<ITEM> impostoWrapper) {
        Estado estado;
        String codigoEstado = null;
        if (!StringUtil.stringNullOrEmpty((String)impostoWrapper.getEstado())) {
            codigoEstado = impostoWrapper.getEstado();
        } else if (impostoWrapper.getEntidade() != null && (estado = (Estado)EstadoRN.getInstance().buscarPorId(impostoWrapper.getEntidade().getEndereco().getIdEstado())) != null) {
            codigoEstado = estado.getCodigo();
        }
        return codigoEstado;
    }

    public boolean isNotaCreditoOuTransferenciaCreditoIcms(ParametrosNotaFiscalInterface parametros) {
        return parametros != null && (FinalidadeEmissaoNfeCFOP.TRANSFERENCIA_CREDITO_ICMS.equals((Object)parametros.getFinalidadeEmissaoNfe()) || FinalidadeEmissaoNfeCFOP.CREDITO_ICMS.equals((Object)parametros.getFinalidadeEmissaoNfe()));
    }

    public boolean utilizaOperacaoFiscal(TipoEmissaoNotaFiscal tipoEmissao, Long idFilial) {
        return this.utilizaOperacaoFiscal(TipoEmissaoNotaFiscal.PROPRIA.equals((Object)tipoEmissao), idFilial);
    }

    public boolean utilizaOperacaoFiscal(boolean isEmissaoPropria, Long idFilial) {
        return NotaFiscalRN.getInstance().utilizaOperacaoFiscal(isEmissaoPropria, idFilial);
    }
}

