/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.WhatsAppService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.awt.Image;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class CompartilhamentoController<E extends NotificacaoCompartilhamento>
implements TrataImagemWeb {
    protected final TaskManager taskManager;
    @Autowired
    protected WhatsAppService whatsAppService;
    @Autowired
    protected StorageService storageService;

    public CompartilhamentoController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @PostMapping(value={"/compartilhar"})
    @DBAutoCommit
    public String compartilhar(@RequestBody E compartilhamento) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        this.validarCompartilhamento(compartilhamento);
        if (compartilhamento.getTipoNotificacao().equals((Object)TipoNotificacao.WHATSAPP)) {
            return this.enviarWhatsApp(sessao, compartilhamento);
        }
        this.agendarEnvioEmail(sessao, compartilhamento);
        return null;
    }

    private String enviarWhatsApp(Sessao sessao, E compartilhamento) throws UnicoMensagemUsuarioException {
        List notificacoes = this.getNotificacoes(sessao, compartilhamento);
        return this.whatsAppService.enviarWhatsApp(notificacoes, sessao);
    }

    private void agendarEnvioEmail(Sessao sessao, E compartilhamento) throws UnicoMensagemUsuarioException {
        List notificacoes = this.getNotificacoes(sessao, compartilhamento);
        if (notificacoes.size() > 1) {
            for (Notificacao notificacao : notificacoes) {
                ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)sessao, (String)notificacao.getEmail(), (String)notificacao.getEmailCopia(), (String)notificacao.getAssunto(), (String)notificacao.getMsg());
                parametrosEmail.setAnexos(notificacao.getDataSources());
                compartilhamento.setDadosNF(notificacao.getDadosNF());
                this.createJobEmail(sessao, parametrosEmail, compartilhamento);
            }
        } else {
            Notificacao notificacao = (Notificacao)notificacoes.get(0);
            ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)sessao, (String)notificacao.getEmail(), (String)notificacao.getEmailCopia(), (String)notificacao.getAssunto(), (String)notificacao.getMsg());
            parametrosEmail.setAnexos(notificacao.getDataSources());
            compartilhamento.setDadosNF(notificacao.getDadosNF());
            this.createJobEmail(sessao, parametrosEmail, compartilhamento);
        }
    }

    protected abstract List<Notificacao> getNotificacoes(Sessao var1, E var2) throws UnicoMensagemUsuarioException;

    protected abstract void createJobEmail(Sessao var1, ParametrosEmailWeb var2, E var3) throws UnicoMensagemUsuarioException;

    protected void validarCompartilhamento(E compartilhamento) throws UnicoMensagemUsuarioException {
    }

    public byte[] downloadImagem(String url) throws UnicoMensagemUsuarioException {
        File file = this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, url, false, true);
        return FileUtil.file2ByteArray((File)file, (boolean)false);
    }

    public Image downloadLogo(String url) throws UnicoMensagemUsuarioException {
        File file = this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Imagens_Preferencias, url, false, true);
        return Util.getImageFromFile((File)file);
    }
}

