/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.DicionarioDados;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.sql.SqlNativo;
import br.intelidata.commons.core.sql.model.AtributosCHVE;
import br.intelidata.commons.core.sql.model.ChaveEstrangeira;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.Tabela;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.GravarAuditoriaUsuario;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.AuditoriaCampo;
import br.intelidata.commons.domain.pojo.AuditoriaRegistro;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampoExtra;
import br.intelidata.commons.domain.pojo.CrudConfigurado;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.GridConfigurada;
import br.intelidata.commons.domain.pojo.Hierarquia;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.domain.pojo.ValorCampoExtra;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoCampoExtra;
import br.intelidata.commons.domain.pojo.integracao.ControllerBIInterface;
import br.intelidata.commons.domain.pojo.relatorioconfigurado.RelatorioConfiguradoColunaWeb;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AuditoriaCampoCommonRN;
import br.intelidata.commons.domain.regranegocio.AuditoriaRegistroCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCampoExtraCommonRN;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.domain.regranegocio.SemaforoCommonRN;
import br.intelidata.commons.domain.regranegocio.ValorCampoExtraCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.CrudConfiguradoRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.GridConfiguradaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.commons.modulo.contabilidade.regranegocio.ContaContabilRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.BuscarListaIDInterface;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FieldDefinition;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.grid.GridContaContabil;
import br.intelidata.uniplusweb.core.grid.GridHierarquia;
import br.intelidata.uniplusweb.core.grid.Operator;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.DateUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.dashboard.base.service.DashBoardRabbitService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CampoCrud;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ColunasCustomizaveis;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ConfiguracaoCrud;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudFile;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CustomizacaoExtraRelatorioConfigurado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.GridConfiguradaWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImpressaoCrudWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ObjetoAuxiliar;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaRelatorioConfigurado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TipoCampoCrud;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.gson.Gson;
import com.lowagie.text.Font;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public abstract class CrudController<Entity extends AbstractPojo, RN extends AbstractRegraNegocio>
implements CrudFile<Entity>,
CustomizacaoExtraRelatorioConfigurado,
ColunasCustomizaveis,
BuscarListaIDInterface {
    private static final int QUERY_LIMIT_WITHOUT_PAGING = 100000;
    private static final String NOME_DEFAULT = "Default";
    private ParentController parentController;
    private int queryLimit = 25;
    private boolean isHiearchy = false;
    private boolean validarCurrentTimeMillis = true;
    private final boolean paginado;
    private final br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra configuracaoCampoExtra;
    private Supplier<Entity> entitySupplier;
    protected Supplier<?> itemSupplier;
    protected Grid<?> grid;
    protected RN rn;
    @Autowired
    protected CacheService cacheService;
    @Autowired
    protected StorageService saveFile;
    @Autowired
    protected ResponseEntityService responseEntityService;
    @Autowired
    protected NotificationService notificationService;
    @Autowired
    protected DashBoardRabbitService dashBoardRabbitService;
    @Autowired
    protected HttpServletRequest httpServletRequest;
    private TipoArquivoArmazenado tipoArmazenamento;
    private boolean permiteConfigurarGrid;
    private String colunaTotalizador = "id";
    private final List<CustomFilterGrid> listaCustomFilterGrid;

    public CrudController(RN rn, Supplier<Entity> entitySupplier) {
        this(rn, entitySupplier, false, true);
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, TipoArquivoArmazenado tipoArmazenamento) {
        this(rn, entitySupplier, false, true);
        this.tipoArmazenamento = tipoArmazenamento;
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, boolean permiteConfigurarGrid) {
        this(rn, entitySupplier, false, true);
        this.permiteConfigurarGrid = permiteConfigurarGrid;
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, boolean lazyLoad, boolean paginado) {
        this(rn, entitySupplier, lazyLoad, paginado, true);
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, boolean lazyLoad, boolean paginado, boolean permiteConfigurarGrid) {
        this(rn, entitySupplier, lazyLoad, paginado, null, permiteConfigurarGrid);
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, boolean lazyLoad, boolean paginado, TipoArquivoArmazenado tipoArmazenamento) {
        this(rn, entitySupplier, lazyLoad, paginado, tipoArmazenamento, true);
    }

    public CrudController(RN rn, Supplier<Entity> entitySupplier, boolean lazyLoad, boolean paginado, TipoArquivoArmazenado tipoArmazenamento, boolean permiteConfigurarGrid) {
        this.rn = rn;
        this.entitySupplier = entitySupplier;
        this.paginado = paginado;
        this.tipoArmazenamento = tipoArmazenamento;
        if (rn instanceof HierarquiaRN) {
            this.isHiearchy = true;
            this.parentController = new ParentController(this);
        }
        if (!lazyLoad) {
            this.grid = rn instanceof HierarquiaRN ? new GridHierarquia(this.getGridBuilder()) : new Grid(this.getGridBuilder());
        }
        this.configuracaoCampoExtra = this.getClass().getAnnotation(br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra.class);
        this.permiteConfigurarGrid = permiteConfigurarGrid;
        this.listaCustomFilterGrid = new ArrayList();
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    public void dependsOn(String foreignKey) {
        this.parentController = new ParentController(this);
        this.parentController.parentField.setField(foreignKey);
    }

    @RequestMapping(value={"/get-objeto-original"})
    public Entity getObjeto(@RequestParam(required=false) Map<String, String> queryMap) {
        return (Entity)(this.entitySupplier != null ? (AbstractPojo)this.entitySupplier.get() : null);
    }

    @RequestMapping(value={"/get-objeto-item-original"})
    public <E extends AbstractPojo> E getObjetoItem() {
        return (E)(this.itemSupplier != null ? (AbstractPojo)this.itemSupplier.get() : null);
    }

    @RequestMapping
    @DBAutoCommit
    public synchronized ResponseEntity<String> query(@RequestParam(value="page", required=false, defaultValue="1") int page, @RequestParam(value="limit", required=false, defaultValue="0") int limit, @RequestParam(value="query", required=false) String query, @RequestParam(value="filter", required=false) String filter, @RequestParam(value="format", required=false) String format, @RequestParam(value="hierarchy", required=false) String hierarchy, @PathVariable Optional<Long> parentId, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        String data;
        this.prepareGrid();
        String parent = null;
        if (parentId.isPresent() && this.parentController != null) {
            this.parentController.parentField.setValue(parentId.get().toString());
            parent = new Gson().toJson((Object)this.parentController.parentField);
        } else if (hierarchy != null && !"".equals(hierarchy)) {
            parent = hierarchy;
        }
        List filters = this.getFilter(filter, parameters);
        int qLimit = !this.paginado ? 100000 : (limit > 0 ? limit : this.queryLimit);
        List lista = this.grid.getDadosWeb(page, qLimit, query, parent, filters, this.listaCustomFilterGrid);
        List colunasSQL = this.grid.getColunasSql();
        Extras extras = null;
        if (this.getTabelaCampoExtra() != null) {
            extras = ExtrasRN.getInstance().buscarPorNomeTabela(this.getTabelaCampoExtra());
            this.converterCamposExtras(colunasSQL, lista, extras);
        }
        this.afterLoadGrid(colunasSQL, lista, filters, parameters);
        if (format != null && format.equals("jsonh")) {
            Map valoresTotalizados = this.getMapValoresTotalizados(colunasSQL, lista, filters, parameters);
            int numeroTotalRegistros = this.grid.getTotalRegistros(this.colunaTotalizador);
            List gridsConfiguradas = GridConfiguradaRN.getInstance().getListaComboGridConfigurada(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela(), this.grid.getGridBuilder().getAliasTabela());
            data = JsonUtil.getJsonh((List)lista, (List)colunasSQL, (int)numeroTotalRegistros, (int)qLimit, (Map)valoresTotalizados, (Extras)extras, (List)this.getTabelasConfiguracaoRelatorio(), (List)gridsConfiguradas, (ObjetoAuxiliar)this.getObjetoAuxiliar());
        } else {
            data = JsonUtil.toJson((List)lista, (List)colunasSQL);
        }
        return this.responseEntityService.createJSONResponse(data);
    }

    protected Map<String, BigDecimal> getMapValoresTotalizados(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        return this.grid.getMapValoresTotalizados();
    }

    @RequestMapping(value={"/extras"})
    @DBAutoCommit
    public Extras getConfiguracaoExtras() {
        Extras extras = null;
        if (this.configuracaoCampoExtra != null) {
            extras = ExtrasRN.getInstance().buscarPorNomeTabela(this.configuracaoCampoExtra.TABELA());
        }
        return extras;
    }

    @RequestMapping(value={"fields-definition"})
    @DBAutoCommit
    public List<FieldDefinition> getFields() throws UnicoMensagemUsuarioException {
        SimpleValueWrapper wrapper;
        List fields = null;
        if (this.cacheService.get((Object)this.getCacheIdPerfil()) != null && (wrapper = (SimpleValueWrapper)this.cacheService.get((Object)this.getCacheIdPerfil().concat("_fields"))) != null) {
            fields = (List)wrapper.get();
        }
        if (fields == null) {
            this.prepareGrid();
            fields = this.grid.getFieldsDefinition();
            this.cacheService.put((Object)this.getCacheIdPerfil().concat("_fields"), (Object)fields);
        }
        return fields;
    }

    @RequestMapping(value={"/configuracao-atual"})
    @DBAutoCommit
    public GridConfiguradaWrapper buscarGridConfigurada() throws UnicoMensagemUsuarioException {
        this.prepareGrid();
        return new GridConfiguradaWrapper(this.getGridConfigurada(this.grid.getGridBuilder().getAliasTabela()), GridConfiguradaRN.getInstance().getQuantidadeGridPorPerfilTabelaOuAlias(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela(), this.grid.getGridBuilder().getAliasTabela()));
    }

    @RequestMapping(value={"/gravar-colunas-configuradas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void gravarConfiguracaoGrid(@RequestBody GridConfigurada gridConfigurada) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)gridConfigurada.getColunas())) {
            throw new UnicoMensagemUsuarioException("COM236551", "Selecione pelo menos uma coluna");
        }
        int transacao = 1;
        if (NumberUtil.longNullOuZero((Long)gridConfigurada.getId())) {
            transacao = 0;
            gridConfigurada.setAtual(false);
            gridConfigurada.setIdPerfil(SessaoUtil.getSessao().getUsuario().getIdPerfil());
        }
        GridConfiguradaRN.getInstance().gravar(transacao, gridConfigurada, SessaoUtil.getSessao());
        this.limparCache();
    }

    @RequestMapping(value={"/excluir-colunas-configuradas/{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void excluirConfiguracaoGrid(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        GridConfigurada gridConfigurada = (GridConfigurada)GridConfiguradaRN.getInstance().buscarPorId(id);
        if (gridConfigurada != null) {
            GridConfiguradaRN.getInstance().excluir((AbstractPojo)gridConfigurada, SessaoUtil.getSessao());
            GridConfigurada gridDefault = GridConfiguradaRN.getInstance().buscarVisaoDefault(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela(), this.grid.getGridBuilder().getAliasTabela());
            if (gridDefault != null) {
                gridDefault.setAtual(true);
                GridConfiguradaRN.getInstance().alterar((AbstractPojo)gridDefault, SessaoUtil.getSessao());
            }
            this.limparCache();
        }
    }

    @RequestMapping(value={"/resetar-visao-default"}, method={RequestMethod.POST})
    @DBTransaction
    public void resetarConfiguracaoGridDefault() throws UnicoMensagemUsuarioException {
        int transacao;
        GridBuilder gridBuilder = this.getGridBuilder();
        List colunas = this.getColunasOriginais(gridBuilder);
        GridConfigurada gridDefault = GridConfiguradaRN.getInstance().buscarVisaoDefault(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela(), this.grid.getGridBuilder().getAliasTabela());
        if (gridDefault == null) {
            transacao = 0;
            gridDefault = new GridConfigurada(SessaoUtil.getSessao().getUsuario().getIdPerfil(), NOME_DEFAULT, this.rn.getTabela(), gridBuilder.getAliasTabela(), JsonUtil.toJson((Object)colunas));
        } else {
            transacao = 1;
            gridDefault.setColunas(JsonUtil.toJson((Object)colunas));
        }
        gridDefault.setAtual(true);
        GridConfiguradaRN.getInstance().gravar(transacao, gridDefault, SessaoUtil.getSessao());
        this.limparCache();
    }

    protected List<RelatorioConfiguradoColunaWeb> getColunasOriginais(GridBuilder<?> gridBuilder) {
        return gridBuilder.getColunasSql().stream().filter(ColunaSQL::isVisivel).map(colunaSQL -> {
            Coluna coluna = gridBuilder.getDefinicaoColuna(this.rn.getTabela(), colunaSQL);
            if (colunaSQL.getTipoDadoBase() == null) {
                colunaSQL.setTipoDadoBase(coluna.getTipoDado());
            }
            return new RelatorioConfiguradoColunaWeb(colunaSQL, coluna.getTipoDado());
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/alterar-visao"}, method={RequestMethod.POST})
    @DBTransaction
    public void alterarGridAtual(@RequestBody Long idGrid) throws UnicoMensagemUsuarioException {
        GridConfigurada gridConfigurada = (GridConfigurada)GridConfiguradaRN.getInstance().buscarPorId(idGrid);
        if (gridConfigurada != null) {
            GridConfiguradaRN.getInstance().gravar(1, gridConfigurada, SessaoUtil.getSessao());
            this.limparCache();
        }
    }

    @RequestMapping(value={"last-valid-code"})
    @DBAutoCommit
    public String lastValidCode() {
        return this.rn.getCodigoUnico(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"valid-code"})
    @DBAutoCommit
    public boolean validCode(@RequestParam String value) throws UnicoMensagemUsuarioException {
        return !this.rn.existeCodigoUnico(SessaoUtil.getSessao(), (Object)value);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.GET})
    @DBAutoCommit
    public Entity read(@PathVariable Long id, @PathVariable Optional<Long> parentId, @RequestParam(required=false, defaultValue="0") int modo, @RequestParam(required=false) MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        AbstractPojo entity = this.rn.buscarPorId(id);
        if (entity == null) {
            throw new UnicoException("WWW21", "id " + id + " da tabela " + this.rn.getTabela() + " n\u00e3o encontrado(a)");
        }
        this.read(entity, modo, parentId);
        return (Entity)entity;
    }

    @RequestMapping(value={"/code/{codigo}"})
    @DBAutoCommit
    public Entity readByCode(@PathVariable String codigo, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        AbstractPojo entity = this.rn.buscarPorCodigo(codigo);
        if (entity == null) {
            throw new UnicoException("WWW22", "c\u00f3digo " + codigo + " da tabela " + this.rn.getTabela() + " n\u00e3o encontrado(a)");
        }
        this.read(entity, 0, parentId);
        return (Entity)entity;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Entity entity, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.isHiearchy) {
            this.setHiearchy(entity);
        }
        this.beforeCreate(entity, parentId);
        this.beforeSave(entity, parentId);
        Long id = this.rn.gravar(0, entity, SessaoUtil.getSessao());
        entity.setId(id);
        this.gravarAuditoriaRegistro(null, entity, 0);
        this.afterCreate(entity, parentId);
        this.afterSave(entity, parentId);
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
        if (entity instanceof ControllerBIInterface) {
            this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        }
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart MultipartFile[] files, @RequestPart(value="entity") Entity entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.create(entity, Optional.empty());
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Entity entity, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis(entity);
        this.beforeUpdate(entity, parentId);
        this.beforeSave(entity, parentId);
        Long id = entity.getId();
        this.gravarAuditoriaRegistro(id, entity, 1);
        this.rn.gravar(1, entity, SessaoUtil.getSessao());
        this.afterUpdate(entity, parentId);
        this.afterSave(entity, parentId);
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
        if (entity instanceof ControllerBIInterface) {
            this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        }
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") Entity entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.update(entity, Optional.empty());
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        AbstractPojo entity = this.rn.buscarPorId(id);
        if (entity == null) {
            throw new UnicoException("WWW23", "id " + id + " da tabela " + this.rn.getTabela() + " n\u00e3o encontrado(a)");
        }
        this.beforeDelete(entity);
        this.gravarAuditoriaRegistro(id, null, 2);
        this.afterDelete(entity);
        this.rn.gravar(2, entity, SessaoUtil.getSessao());
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
        if (entity instanceof ControllerBIInterface) {
            this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        }
    }

    @RequestMapping(value={"/exportar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> exportarGrid(@RequestBody SaidaImpressaoWrapper saidaImpressaoWrapper, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        this.prepareGrid();
        String query = null;
        if (parameters.containsKey((Object)"query")) {
            query = (String)((List)parameters.get((Object)"query")).get(0);
        }
        String filter = null;
        if (parameters.containsKey((Object)"filter")) {
            filter = (String)((List)parameters.get((Object)"filter")).get(0);
        }
        List filters = this.getFilter(filter, parameters);
        List dados = this.grid.getDadosWeb(0, 0, query, null, filters, this.listaCustomFilterGrid);
        this.tratarParametros(parameters);
        this.afterLoadGrid(this.grid.getColunasSql(), dados, filters, parameters);
        byte[] remessa = this.grid.exportar(saidaImpressaoWrapper, dados);
        PreferenciaUsuario preferenciaUsuario = SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario();
        preferenciaUsuario.setTipoSaidaRelatorio(saidaImpressaoWrapper.getSaidaRelatorio().getDescricao());
        preferenciaUsuario.setDelimitadorRelatorio(saidaImpressaoWrapper.getDelimitador());
        PreferenciaUsuarioRN.getInstance().salvaPreferenciasUsuario(SessaoUtil.getSessao(), preferenciaUsuario);
        switch (2.$SwitchMap$br$intelidata$uniplusweb$web$rest$app$client$report$SaidaRelatorio[saidaImpressaoWrapper.getSaidaRelatorio().ordinal()]) {
            case 1: {
                return this.responseEntityService.createHtmlResponse(remessa, "documento");
            }
            case 2: {
                return this.responseEntityService.createXLSResponse(remessa, saidaImpressaoWrapper.getExtensao());
            }
            case 3: 
            case 4: {
                return this.responseEntityService.createTXTResponse(remessa);
            }
        }
        return this.responseEntityService.createPDFResponse(remessa);
    }

    public List<Long> getListaIDs(String query, String filter) throws UnicoMensagemUsuarioException {
        this.prepareGrid();
        List filters = this.getFilter(filter, (MultiValueMap)new LinkedMultiValueMap());
        List dados = this.grid.getDadosWeb(0, 0, query, null, filters, this.listaCustomFilterGrid);
        int idxColunaID = this.getIndexColuna("id", this.grid.getColunasSql());
        return dados.stream().map(obj -> (Long)obj[idxColunaID]).collect(Collectors.toList());
    }

    protected void tratarParametros(MultiValueMap<String, String> parameters) {
    }

    @RequestMapping(value={"/parametros-relatorio"})
    @DBAutoCommit
    public TabelaRelatorioConfigurado getParametrosRelatorio(@RequestParam String tabelaBase, @RequestParam(required=false, defaultValue="true") boolean carregarId, @RequestParam(required=false, defaultValue="0") int nivel) {
        TabelaRelatorioConfigurado configuracaoRelatorio = null;
        String idCache = tabelaBase + (this.configuracaoCampoExtra != null ? "_" + this.configuracaoCampoExtra.TABELA() : "") + this.getSufixoParametrosRelatorio() + (carregarId ? "_id" : "");
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheService.get((Object)idCache);
        if (wrapper != null) {
            configuracaoRelatorio = (TabelaRelatorioConfigurado)wrapper.get();
        }
        if (configuracaoRelatorio == null) {
            HashMap mapExtras = new HashMap();
            configuracaoRelatorio = this.carregarColunas(tabelaBase, carregarId, nivel, mapExtras, null, this.getGridBuilder().isUsaVisao());
            this.cacheService.put((Object)idCache, (Object)configuracaoRelatorio);
        }
        return configuracaoRelatorio;
    }

    protected String getSufixoParametrosRelatorio() {
        return "";
    }

    public TipoArquivoArmazenado getTipoArmazenamento() {
        return this.tipoArmazenamento;
    }

    public StorageService getStorageService() {
        return this.saveFile;
    }

    public boolean isGravarArquivoTabela() {
        return this.getStorageService().isTabela();
    }

    @RequestMapping(value={"/buscar-auditoria-registro"})
    @DBAutoCommit
    public List<AuditoriaRegistro> buscarListAuditoriaRegistro(@RequestParam Long idRegistro) {
        return AuditoriaRegistroCommonRN.getInstance().buscarListaPorTabelaIdRegistro(this.rn.getTabela(), idRegistro);
    }

    @RequestMapping(value={"/buscar-auditoria-campo"})
    @DBAutoCommit
    public List<AuditoriaCampo> buscarListAuditoriaCampo(@RequestParam Long idRegistro) {
        return AuditoriaCampoCommonRN.getInstance().buscarListaPorIdAuditoriaRegistro(idRegistro);
    }

    @RequestMapping(value={"/buscar-rastreabilidade"})
    @DBAutoCommit
    public List buscarRastreabilidade(@RequestParam Long idOrigem) {
        return this.rn.buscarListaRastreabilidade(idOrigem);
    }

    @RequestMapping(value={"/atualizar-currentTimeMillis"})
    @DBAutoCommit
    public Long atualizarCurrentTimeMillis(@RequestParam Long id) {
        return SGBDManager.getInstance().buscarDataHoraObjeto(this.rn.getTabela(), id);
    }

    @RequestMapping(value={"/visualizar-itens"})
    public List<? extends AbstractPojo> getItens(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW636", "Op\u00e7\u00e3o n\u00e3o implementada para este crud");
    }

    @RequestMapping(value={"/importar-edi"}, method={RequestMethod.POST})
    public EDIProcessado importarArquivoEdi(@RequestPart(value="file") MultipartFile file, @RequestParam Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW638", "Importa\u00e7\u00e3o n\u00e3o implementada");
    }

    @RequestMapping(value={"/valor-campos-extras/{id}"})
    @DBAutoCommit
    public List<ValorCampoExtra> buscarListaValorCampoExtra(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        return ValorCampoExtraCommonRN.getInstance().buscarPorProgramaIdRegistro(this.getIdPrograma(), id);
    }

    @RequestMapping(value={"/campos-adicionais-configurado"})
    @DBAutoCommit
    public List<ConfiguracaoCampoExtra> buscarConfiguracaoCamposAdicionais() throws UnicoMensagemUsuarioException {
        return ConfiguracaoCampoExtraCommonRN.getInstance().buscarPorPrograma(this.getIdPrograma());
    }

    @RequestMapping(value={"/gravar-campos-adicionais"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarCamposAdicionais(@RequestBody List<ConfiguracaoCampoExtra> extras) throws UnicoMensagemUsuarioException {
        ConfiguracaoCampoExtraCommonRN.getInstance().gravarLista(SessaoUtil.getSessao(), this.getIdPrograma(), extras);
    }

    @RequestMapping(value={"/configuracao-crud"})
    @DBAutoCommit
    public List<CampoCrud> buscarConfiguracaoCrud() throws UnicoMensagemUsuarioException {
        ConfiguracaoCrud confCrud;
        CrudConfigurado crudConfigurado = CrudConfiguradoRN.getInstance().buscarCrudPorPerfilTabelaAlias(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela(), this.getGridBuilder().getAliasTabela());
        if (crudConfigurado != null && (confCrud = (ConfiguracaoCrud)JsonUtil.fromJson((String)crudConfigurado.getConfiguracao(), ConfiguracaoCrud.class)) != null) {
            return confCrud.getItens();
        }
        return null;
    }

    @PostMapping(value={"/gravar-configuracao-crud"})
    @DBTransaction
    public void gravarConfiguracaoCrud(@RequestBody ConfiguracaoCrud configuracao) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CrudConfigurado crudConfigurado = CrudConfiguradoRN.getInstance().buscarCrudPorPerfilTabelaAlias(sessao.getUsuario().getIdPerfil(), this.rn.getTabela(), this.getGridBuilder().getAliasTabela());
        if (crudConfigurado != null) {
            crudConfigurado.setConfiguracao(JsonUtil.toJson((Object)configuracao));
            CrudConfiguradoRN.getInstance().gravar(1, (AbstractPojo)crudConfigurado, sessao);
        } else {
            crudConfigurado = new CrudConfigurado();
            crudConfigurado.setIdPerfil(sessao.getUsuario().getIdPerfil());
            crudConfigurado.setTabela(this.rn.getTabela());
            crudConfigurado.setAliasTabela(this.getGridBuilder().getAliasTabela());
            crudConfigurado.setConfiguracao(JsonUtil.toJson((Object)configuracao));
            CrudConfiguradoRN.getInstance().gravar(0, (AbstractPojo)crudConfigurado, sessao);
        }
        String idConfCrud = !StringUtil.stringNullOrEmpty((String)this.getGridBuilder().getAliasTabela()) ? this.getGridBuilder().getAliasTabela() : this.rn.getTabela();
        idConfCrud = idConfCrud + "_" + sessao.getUsuario().getIdPerfil();
        this.notificationService.notifyTenantNow(NotificationType.UPDATE_CONFIG_CRUD, idConfCrud);
    }

    @PostMapping(value={"/imprimir-crud"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirCrud(@RequestBody ImpressaoCrudWrapper impressaoCrudWrapper) throws UnicoMensagemUsuarioException {
        UViewer uViewer = new UViewer(true, impressaoCrudWrapper.getSaida().getTitulo(), impressaoCrudWrapper.getSaida().getSaidaRelatorio().getSaida(), impressaoCrudWrapper.getSaida().getDelimitador(), impressaoCrudWrapper.getSaida().isPaisagem(), impressaoCrudWrapper.getSaida().getExtensao(), new int[]{50, 50});
        this.beforeImprimirCrud(uViewer, impressaoCrudWrapper);
        uViewer.setFonte(new Font(1, 6.0f, 0));
        uViewer.inicioRelatorio();
        uViewer.setZebrado(true);
        uViewer.inicioTitulo();
        uViewer.escreveTitulo("Campo", false);
        uViewer.escreveTitulo("Valor", false);
        uViewer.fimTitulo();
        this.imprimeLinhaCrud(uViewer, impressaoCrudWrapper.getConf().getItens(), impressaoCrudWrapper.getDados(), 0);
        this.afterImprimirCrud(uViewer, impressaoCrudWrapper);
        uViewer.fimRelatorio();
        return RelatorioUtil.visualizar((Remessa)uViewer.getRemessa(), (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)impressaoCrudWrapper.getSaida().getSaidaRelatorio(), (String)"documento");
    }

    private void imprimeLinhaCrud(UViewer uViewer, List<CampoCrud> campos, Map<String, Object> dados, int nivel) {
        if (!ListMapUtil.listNullOrEmpty(campos)) {
            for (CampoCrud campo : campos) {
                String descricao = StringUtil.replicate((String)" ", (int)(nivel * 4)) + campo.getDescricao();
                if (!ListMapUtil.listNullOrEmpty((List)campo.getItens())) {
                    uViewer.inicioLinha();
                    uViewer.escreveColunaComFundo(descricao);
                    uViewer.escreveColunaComFundo("");
                    uViewer.fimLinha();
                    this.imprimeLinhaCrud(uViewer, campo.getItens(), dados, nivel + 1);
                    continue;
                }
                uViewer.inicioLinha();
                uViewer.escreveColuna(descricao);
                Object valorObj = dados.get(campo.getNome());
                if (valorObj != null && !StringUtil.stringNullOrEmpty((String)valorObj.toString())) {
                    if (TipoCampoCrud.FK.equals((Object)campo.getTipo())) {
                        boolean achou = false;
                        Tabela tabela = DicionarioDados.getInstance().getTabela(this.rn.getTabela());
                        if (tabela != null) {
                            for (Map.Entry entry : tabela.getChavesEstrangeira().entrySet()) {
                                Tabela tabelaReferencia;
                                if (!((ChaveEstrangeira)entry.getValue()).getColunas()[0].equalsIgnoreCase(campo.getNome()) || (tabelaReferencia = DicionarioDados.getInstance().getTabela(((ChaveEstrangeira)entry.getValue()).getTabelaReferencia())) == null) continue;
                                String campoDesc = null;
                                if (tabelaReferencia.getColuna("nome") != null) {
                                    campoDesc = "nome";
                                } else if (tabelaReferencia.getColuna("descricao") != null) {
                                    campoDesc = "descricao";
                                }
                                if (campoDesc == null) continue;
                                String strSql = "select " + campoDesc + " from " + ((ChaveEstrangeira)entry.getValue()).getTabelaReferencia() + " where " + ((ChaveEstrangeira)entry.getValue()).getColunasReferencia()[0] + " = " + valorObj;
                                Object valorChave = SqlNativo.executaQueryValor((String)strSql);
                                uViewer.escreveColuna(StringUtil.all2Atring((Object)valorChave));
                                achou = true;
                                break;
                            }
                        }
                        if (!achou) {
                            uViewer.escreveColuna("");
                        }
                    } else if (TipoCampoCrud.DATE.equals((Object)campo.getTipo())) {
                        if (valorObj.toString().length() >= 10) {
                            uViewer.escreveColuna(DataHoraFactory.string2LocalDate((String)valorObj.toString().substring(0, 10), (String)"yyyy-MM-dd"));
                        } else {
                            uViewer.escreveColuna("");
                        }
                    } else if (TipoCampoCrud.DATETIME.equals((Object)campo.getTipo())) {
                        if (valorObj.toString().length() >= 16) {
                            uViewer.escreveColuna(DataHoraFactory.string2LocalDate((String)valorObj.toString().substring(0, 16), (String)"yyyy-MM-dd HH-mm"));
                        } else {
                            uViewer.escreveColuna("");
                        }
                    } else if (TipoCampoCrud.BOOLEAN.equals((Object)campo.getTipo())) {
                        if (Boolean.parseBoolean(StringUtil.all2Atring((Object)valorObj))) {
                            uViewer.escreveColuna("Sim");
                        } else {
                            uViewer.escreveColuna("N\u00e3o");
                        }
                    } else if (TipoCampoCrud.ENUM.equals((Object)campo.getTipo())) {
                        Coluna coluna = DicionarioDados.getInstance().getColuna(this.rn.getTabela(), campo.getNome().toLowerCase());
                        if (coluna != null && coluna.getClasseEnum() != null) {
                            boolean achou = false;
                            for (Object enumConstant : coluna.getClasseEnum().getEnumConstants()) {
                                if (!((Enum)enumConstant).name().equals(valorObj.toString())) continue;
                                uViewer.escreveColuna(((AbstractEnum)enumConstant).getDescricao());
                                achou = true;
                                break;
                            }
                            if (!achou) {
                                uViewer.escreveColuna("");
                            }
                        }
                    } else {
                        uViewer.escreveColuna(StringUtil.all2Atring((Object)valorObj));
                    }
                } else {
                    uViewer.escreveColuna("");
                }
                uViewer.fimLinha();
            }
        }
    }

    protected void beforeImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
    }

    protected void afterImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
    }

    protected BigDecimal tratarNumeroImpressaoCrud(Object valor, int decimais) {
        if (valor != null) {
            if (valor instanceof Integer) {
                return BigDecimal.valueOf(((Integer)valor).intValue()).setScale(decimais, RoundingMode.HALF_UP);
            }
            if (valor instanceof Double) {
                return BigDecimal.valueOf((Double)valor).setScale(decimais, RoundingMode.HALF_UP);
            }
            return Util.string2BigDecimal((String)valor.toString(), (int)decimais);
        }
        return BigDecimal.ZERO.setScale(decimais, RoundingMode.HALF_UP);
    }

    private int getIdPrograma() throws UnicoMensagemUsuarioException {
        if (this.configuracaoCampoExtra == null || this.configuracaoCampoExtra.PROGRAMA() == 0) {
            throw new UnicoMensagemUsuarioException("WWW659", "Programa n\u00e3o configurado para carregar campos extras");
        }
        return this.configuracaoCampoExtra.PROGRAMA();
    }

    public void setValidarCurrentTimeMillis(boolean validarCurrentTimeMillis) {
        this.validarCurrentTimeMillis = validarCurrentTimeMillis;
    }

    protected void gravarAuditoriaRegistro(Long id, Entity pojoNovo, int transacao) throws UnicoMensagemUsuarioException {
        if (this.rn != null && AuditoriaRegistroCommonRN.getInstance().isHabilitarAuditoriaRegistro()) {
            SemaforoCommonRN.getInstance().travarTabela(SessaoUtil.getSessao(), this.rn.getTabela());
            AbstractPojo pojoOriginal = CacheSistema.getInstance().getPojo(this.rn, id);
            GravarAuditoriaUsuario.getInstance().gravar(SessaoUtil.getSessao(), this.rn.getTabela(), transacao, pojoOriginal, pojoNovo);
        }
    }

    protected void gravarAuditoriaRegistro(Long id, Entity pojoOriginal, Entity pojoNovo, int transacao) throws UnicoMensagemUsuarioException {
        if (this.rn != null && AuditoriaRegistroCommonRN.getInstance().isHabilitarAuditoriaRegistro()) {
            SemaforoCommonRN.getInstance().travarTabela(SessaoUtil.getSessao(), this.rn.getTabela());
            GravarAuditoriaUsuario.getInstance().gravar(SessaoUtil.getSessao(), this.rn.getTabela(), transacao, pojoOriginal, pojoNovo);
        }
    }

    protected abstract String getCacheId();

    protected abstract GridBuilder<?> getGridBuilder();

    protected List<TabelaConfigurada> getTabelasConfiguracaoRelatorio() {
        return Collections.singletonList(new TabelaConfigurada(this.rn.getTabela(), DicionarioDados.getInstance().getTabela(this.rn.getTabela()).getComentario()));
    }

    protected void beforeCreate(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void afterCreate(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void beforeRead(Entity entity, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void beforeUpdate(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void beforeDelete(Entity entity) throws UnicoMensagemUsuarioException {
    }

    protected void afterDelete(Entity entity) throws UnicoMensagemUsuarioException {
    }

    protected void afterUpdate(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void beforeSave(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void afterSave(Entity entity, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
    }

    protected void afterLoadColunaSQL(List<ColunaSQL> colunas) throws UnicoMensagemUsuarioException {
    }

    protected CrudController<Entity, ?> setQueryLimit(int limit) {
        this.queryLimit = limit;
        return this;
    }

    protected int getIndexColuna(String coluna, List<ColunaSQL> colunas) {
        return this.grid.getIndexColuna(coluna, colunas);
    }

    protected void validarCurrentTimeMillis(Entity entity) throws UnicoMensagemUsuarioException {
        if (!this.validarCurrentTimeMillis) {
            return;
        }
        if (entity != null && entity.getCurrentTimeMillis() != null && entity.getCurrentTimeMillis().compareTo(SGBDManager.getInstance().buscarDataHoraObjeto(this.rn.getTabela(), entity.getId())) != 0) {
            throw new UnicoMensagemUsuarioException("COM236552", "Este registro j\u00e1 sofreu altera\u00e7\u00f5es depois que foi carregado para altera\u00e7\u00e3o! Ser\u00e1 imposs\u00edvel continuar.");
        }
    }

    protected ObjetoAuxiliar getObjetoAuxiliar() throws UnicoMensagemUsuarioException {
        return null;
    }

    protected void setColunaTotalizador(String colunaTotalizador) {
        this.colunaTotalizador = colunaTotalizador;
    }

    protected void limparCache() {
        this.cacheService.removerCache(this.getCacheIdPerfil());
    }

    protected <E extends AbstractPojo> void setItemSupplier(Supplier<E> itemSupplier) {
        this.itemSupplier = itemSupplier;
    }

    protected String getAliasTabelaCampoExtra() {
        return null;
    }

    protected Grid getGrid(GridBuilder gridBuilder) {
        if (this.rn instanceof HierarquiaRN) {
            return new GridHierarquia(gridBuilder);
        }
        if (this.rn instanceof ContaContabilRN) {
            return new GridContaContabil(gridBuilder);
        }
        return new Grid(gridBuilder);
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        this.listaCustomFilterGrid.clear();
        SimpleValueWrapper wrapper = (SimpleValueWrapper)this.cacheService.get((Object)this.getCacheIdPerfil());
        if (wrapper != null) {
            this.grid = (Grid)wrapper.get();
            return;
        }
        GridBuilder gridBuilder = this.getGridBuilder();
        if (this.permiteConfigurarGrid) {
            GridConfigurada configuracaoGrid = this.getGridConfigurada(gridBuilder.getAliasTabela());
            if (configuracaoGrid != null) {
                List colunas = JsonUtil.fromJsonList((String)configuracaoGrid.getColunas(), RelatorioConfiguradoColunaWeb.class);
                if (!ListMapUtil.listNullOrEmpty((List)colunas)) {
                    colunas.sort(Comparator.comparingInt(RelatorioConfiguradoColunaWeb::getPosicao));
                    List colunasInvisiveis = gridBuilder.getColunasSql().stream().filter(colunaSQL -> !colunaSQL.isVisivel()).collect(Collectors.toList());
                    List colunasConfiguradas = colunas.stream().map(colunaConfigurada -> this.colunaTabela2ColunaSQL(gridBuilder, colunaConfigurada, gridBuilder.getColunasSql())).collect(Collectors.toList());
                    this.afterLoadColunaSQL(colunasConfiguradas);
                    colunasConfiguradas.addAll(colunasInvisiveis);
                    gridBuilder.setColunasSql(colunasConfiguradas);
                    gridBuilder.carregarEnuns();
                }
            } else {
                List colunas = this.getColunasOriginais(gridBuilder);
                GridConfigurada gridConfigurada = new GridConfigurada(SessaoUtil.getSessao().getUsuario().getIdPerfil(), NOME_DEFAULT, this.rn.getTabela(), gridBuilder.getAliasTabela(), JsonUtil.toJson((Object)colunas));
                gridConfigurada.setAtual(true);
                GridConfiguradaRN.getInstance().gravar(0, gridConfigurada, SessaoUtil.getSessao());
            }
        }
        this.grid = this.getGrid(gridBuilder);
        if (this.rn instanceof HierarquiaRN) {
            this.parentController = new ParentController(this);
            this.isHiearchy = true;
        }
        this.cacheService.put((Object)this.getCacheIdPerfil(), (Object)this.grid);
    }

    private GridConfigurada getGridConfigurada(String aliasTabela) {
        GridConfigurada configuracaoGrid = !StringUtil.stringNullOrEmpty((String)aliasTabela) ? GridConfiguradaRN.getInstance().buscarGridAtualPorPerfilAliasTabela(SessaoUtil.getSessao().getUsuario().getIdPerfil(), aliasTabela) : GridConfiguradaRN.getInstance().buscarGridAtualPorPerfilTabela(SessaoUtil.getSessao().getUsuario().getIdPerfil(), this.rn.getTabela());
        return configuracaoGrid;
    }

    protected void read(Entity entity, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.getTabelaCampoExtra() != null) {
            this.converterCamposExtras(entity, ExtrasRN.getInstance().buscarPorNomeTabela(this.getTabelaCampoExtra()));
        }
        this.beforeRead(entity, modo, parentId);
    }

    private void converterCamposExtras(List<ColunaSQL> colunas, List<Object[]> dados, Extras extras) {
        if (extras != null) {
            for (int i = 1; i <= this.configuracaoCampoExtra.QUANTIDADE().getQuantidade(); ++i) {
                int idxExtra;
                String campoExtra = "extra" + i;
                TipoCampoExtra tipo = (TipoCampoExtra)BeanUtil.get((Object)extras, (String)("tipoExtra" + i), (Object[])new Object[0]);
                if (StringUtil.stringNullOrEmpty((String)((String)BeanUtil.get((Object)extras, (String)campoExtra, (Object[])new Object[0]))) || !TipoCampoExtra.DATA.equals((Object)tipo) && !TipoCampoExtra.DATA_HORA.equals((Object)tipo) || (idxExtra = this.getIndexColuna(campoExtra, colunas)) <= -1) continue;
                dados.forEach(dado -> {
                    String valor = StringUtil.all2Atring((Object)dado[idxExtra]);
                    if (!StringUtil.stringNullOrEmpty((String)valor)) {
                        Comparable<ChronoLocalDate> temporal;
                        Comparable<ChronoLocalDate> comparable = temporal = TipoCampoExtra.DATA.equals((Object)tipo) ? DateUtil.string2LocalDate((String)valor) : DateUtil.string2LocalDateTime((String)valor);
                        if (temporal != null) {
                            dado[idxExtra] = TipoCampoExtra.DATA.equals((Object)tipo) ? DateUtil.JSR310DateSerializer((TemporalAccessor)((Object)temporal)) : DateUtil.JSR310DateTimeSerializer((TemporalAccessor)((Object)temporal));
                        }
                    }
                });
            }
        }
    }

    private void converterCamposExtras(Entity entity, Extras extras) {
        if (extras != null) {
            for (int i = 1; i <= this.configuracaoCampoExtra.QUANTIDADE().getQuantidade(); ++i) {
                Comparable<ChronoLocalDate> temporal;
                String valor;
                String campoExtra = "extra" + i;
                TipoCampoExtra tipo = (TipoCampoExtra)BeanUtil.get((Object)extras, (String)("tipoExtra" + i), (Object[])new Object[0]);
                if (StringUtil.stringNullOrEmpty((String)((String)BeanUtil.get((Object)extras, (String)campoExtra, (Object[])new Object[0]))) || !TipoCampoExtra.DATA.equals((Object)tipo) && !TipoCampoExtra.DATA_HORA.equals((Object)tipo) || StringUtil.stringNullOrEmpty((String)(valor = (String)BeanUtil.get(entity, (String)campoExtra, (Object[])new Object[0])))) continue;
                Comparable<ChronoLocalDate> comparable = temporal = TipoCampoExtra.DATA.equals((Object)tipo) ? DateUtil.string2LocalDate((String)valor) : DateUtil.string2LocalDateTime((String)valor);
                if (temporal == null) continue;
                BeanUtil.set(entity, (String)campoExtra, (Object)(TipoCampoExtra.DATA.equals((Object)tipo) ? DateUtil.JSR310DateSerializer((TemporalAccessor)((Object)temporal)) : DateUtil.JSR310DateTimeSerializer((TemporalAccessor)((Object)temporal))));
            }
        }
    }

    private void setHiearchy(Entity e) {
        String code;
        if (NumberUtil.longNullOuZero((Long)((Hierarquia)e).getIdNovoGrupo())) {
            code = ((HierarquiaRN)this.rn).incrementaCodigo();
        } else {
            Hierarquia hierarquia = (Hierarquia)this.rn.buscarPorId(((Hierarquia)e).getIdNovoGrupo());
            code = ((HierarquiaRN)this.rn).incrementaCodigo(hierarquia.getCodigo());
        }
        ((Hierarquia)e).setCodigo(code);
        ((Hierarquia)e).setIdNovoGrupo(null);
    }

    private List<FilterField> prepareParametersJson(MultiValueMap<String, String> params) {
        return params.entrySet().stream().filter(entry -> this.isValidFilter((String)entry.getKey())).map(entry -> {
            FilterField filterField = new FilterField();
            filterField.setValue1((String)((List)entry.getValue()).get(0));
            filterField.setField((String)entry.getKey());
            filterField.setFilter(Operator.OPERADOR_IGUAL.getId());
            filterField.setType("String");
            return filterField;
        }).collect(Collectors.toList());
    }

    protected List<FilterField> getFilter(String filter, MultiValueMap<String, String> parameters) {
        List listaParametros;
        List filtros;
        ArrayList<FilterField> filters = new ArrayList<FilterField>();
        if (!StringUtil.stringNullOrEmpty((String)filter) && !ListMapUtil.listNullOrEmpty((List)(filtros = (List)JsonUtil.fromJson((String)filter, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)))) {
            filters.addAll(filtros);
        }
        if (parameters != null && !ListMapUtil.listNullOrEmpty((List)(listaParametros = this.prepareParametersJson(parameters)))) {
            filters.addAll(listaParametros);
        }
        return filters;
    }

    private boolean isValidFilter(String key) {
        boolean existeColuna = this.grid.getColunasSql().stream().anyMatch(filtro -> filtro.getAlias().equalsIgnoreCase(key));
        return existeColuna && !"filter".equals(key) && !"format".equals(key) && !"query".equals(key) && !"page".equals(key) && !"hierarchy".equals(key) && !"limit".equals(key);
    }

    private TabelaRelatorioConfigurado carregarColunas(String tabelaBase, boolean carregarId, int nivel, Map<String, Extras> mapExtras, TabelaRelatorioConfigurado paiTabelaBase, boolean usaVisao) {
        String descricaoPrincipal;
        Tabela tabela = DicionarioDados.getInstance().getTabela(tabelaBase);
        boolean nivelPrincipal = tabela.getNome().equalsIgnoreCase(tabelaBase);
        String descricaoTabela = null;
        if (nivelPrincipal && !StringUtil.stringNullOrEmpty((String)(descricaoPrincipal = this.getDescricaoTabela()))) {
            descricaoTabela = descricaoPrincipal;
        }
        TabelaRelatorioConfigurado pai = new TabelaRelatorioConfigurado(tabela.getNome(), descricaoTabela == null ? tabela.getComentario() : descricaoTabela, tabelaBase);
        TabelaRelatorioConfigurado clonePai = new TabelaRelatorioConfigurado(pai.getCodigo(), pai.getDescricao(), pai.getTabelaOriginal());
        clonePai.setPai(paiTabelaBase);
        if (!carregarId && (this.rn.getTabela().equalsIgnoreCase(tabelaBase) || usaVisao)) {
            List colunasCustomizadas = this.getColunasCustomizaveis();
            if (nivelPrincipal && !ListMapUtil.listNullOrEmpty((List)colunasCustomizadas)) {
                colunasCustomizadas.forEach(coluna -> {
                    TabelaRelatorioConfigurado campo = new TabelaRelatorioConfigurado(coluna, coluna.getComentario());
                    campo.setPai(clonePai);
                    pai.addRelacionamento(campo);
                });
            }
        }
        for (Map.Entry linha : tabela.getColunas().entrySet()) {
            String nomeColuna = (String)linha.getKey();
            Coluna coluna2 = (Coluna)linha.getValue();
            if (!coluna2.isMostrarGrid() && (!coluna2.getNome().equals("id") || !carregarId)) continue;
            ChaveEstrangeira chave = tabela.getChaveEstrangeiraPorCampoTabela(nomeColuna);
            if (chave != null && chave.isExpandirNoConfigurador() && !AtributosCHVE.isNaoCriar((ChaveEstrangeira)chave)) {
                if (nivel >= 3) continue;
                String descricao = chave.getDescricao();
                if (StringUtil.stringNullOrEmpty((String)descricao)) {
                    descricao = DicionarioDados.getInstance().getTabela(chave.getTabelaReferencia()).getComentario();
                }
                TabelaRelatorioConfigurado relacionamento = this.carregarColunas(chave.getTabelaReferencia(), carregarId, ++nivel, mapExtras, clonePai, usaVisao);
                relacionamento.setCodigo(chave.getNome());
                if (relacionamento.getRelacionamentos() != null) {
                    for (TabelaRelatorioConfigurado relacionamentoRelacionamento : relacionamento.getRelacionamentos()) {
                        if (relacionamentoRelacionamento.getPai() == null) continue;
                        relacionamentoRelacionamento.getPai().setCodigo(chave.getNome());
                    }
                }
                relacionamento.setDescricao(descricao);
                relacionamento.setPai(clonePai);
                pai.addRelacionamento(relacionamento);
                --nivel;
                continue;
            }
            String descricaoExtra = null;
            String campo = coluna2.getNome();
            if (campo.matches("extra\\d{1,2}")) {
                Extras extras = mapExtras.get(tabela.getNome());
                if (extras == null) {
                    extras = this.getCampoExtra(campo, tabela.getNome());
                    mapExtras.put(tabela.getNome(), extras);
                }
                if (extras != null) {
                    descricaoExtra = (String)BeanUtil.get((Object)extras, (String)campo, (Object[])new Object[0]);
                    if (descricaoExtra != null) {
                        descricaoExtra = descricaoExtra.replace(":", "");
                    }
                    TipoCampoExtra tipoCampoExtra = (TipoCampoExtra)BeanUtil.get((Object)extras, (String)"tipo".concat(Util.capitalizarString((String)campo)), (Object[])new Object[0]);
                    coluna2.setTipoDado(this.getTipoDadoBaseExtra(tipoCampoExtra));
                }
            }
            TabelaRelatorioConfigurado tabelaRelatorioConfigurado = new TabelaRelatorioConfigurado(coluna2, descricaoExtra);
            tabelaRelatorioConfigurado.setPai(clonePai);
            pai.addRelacionamento(tabelaRelatorioConfigurado);
        }
        pai.sort();
        return pai;
    }

    private TipoDadoBase getTipoDadoBaseExtra(TipoCampoExtra tipoExtra) {
        if (tipoExtra == null) {
            tipoExtra = TipoCampoExtra.TEXTO;
        }
        switch (2.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$TipoCampoExtra[tipoExtra.ordinal()]) {
            case 1: {
                return TipoDadoBase.CHARACTER_VARYING;
            }
            case 2: {
                return TipoDadoBase.DATE;
            }
            case 3: {
                return TipoDadoBase.DATETIME;
            }
            case 4: {
                return TipoDadoBase.NUMERIC;
            }
            case 5: {
                return TipoDadoBase.INT;
            }
            case 6: {
                return TipoDadoBase.SMALLINT;
            }
            case 7: {
                return TipoDadoBase.CHARACTER_VARYING;
            }
            case 8: {
                return TipoDadoBase.TEXT;
            }
        }
        return TipoDadoBase.ARRAY_VALUES;
    }

    private ColunaSQL colunaTabela2ColunaSQL(GridBuilder grid, RelatorioConfiguradoColunaWeb colunaGrid, List<ColunaSQL> colunasSqlOriginais) {
        ColunaSQL colunaSQL = new ColunaSQL(colunaGrid.getCodigo(), !Util.stringNullOrEmpty((String)colunaGrid.getAlias()) ? colunaGrid.getAlias() : colunaGrid.getCodigo());
        colunaSQL.setTamanho(colunaGrid.getTamanho());
        colunaSQL.setDescricao(colunaGrid.getDescricao());
        colunaSQL.setChavesEstrangeiras(colunaGrid.getChavesEstrangeiras());
        colunaSQL.setOrdem(colunaGrid.getPosicao());
        colunaSQL.setTotalizar(colunaGrid.isTotalizar());
        colunaSQL.setTipoDadoBase(colunaGrid.getTipoDado());
        colunaSQL.setVisivel(true);
        colunaSQL.setVirtual(colunaGrid.isVirtual());
        colunaSQL.setNaoUtilizarPesquisaRapida(colunaGrid.isNaoUtilizarPesquisaRapida());
        colunaSQL.setNomeCabecalho(colunaGrid.getNomeCabecalho());
        ColunaSQL colunaSQLOriginal = colunasSqlOriginais.stream().filter(c -> c.getAlias().equals(colunaSQL.getAlias())).findFirst().orElse(null);
        if (colunaSQLOriginal != null) {
            colunaSQL.setFormula(colunaSQLOriginal.getFormula());
            colunaSQL.setCoalesce(colunaSQLOriginal.getCoalesce());
            colunaSQL.setEscolha(colunaSQLOriginal.getEscolha());
            colunaSQL.setFuncao(colunaSQLOriginal.getFuncao());
            colunaSQL.setParametrosFuncao(colunaSQLOriginal.getParametrosFuncao());
            colunaSQL.setReferencia(colunaSQLOriginal.isReferencia());
            colunaSQL.setSelecao(colunaSQLOriginal.isSelecao());
            colunaSQL.setSubquery(colunaSQLOriginal.getSubquery());
            colunaSQL.setTotalizar(colunaSQLOriginal.isTotalizar());
            colunaSQL.setNaoAlterarValorEnum(colunaSQLOriginal.isNaoAlterarValorEnum());
            colunaSQL.setChavesEstrangeiras(colunaSQLOriginal.getChavesEstrangeiras());
            colunaSQL.setClasseValor(colunaSQLOriginal.getClasseValor());
            colunaSQL.setClasseEnum(colunaSQLOriginal.getClasseEnum());
            colunaSQL.setVirtual(colunaSQLOriginal.isVirtual());
            colunaSQL.setColunaSQLBuscarValorListener(colunaSQLOriginal.getColunaSQLBuscarValorListener());
            colunaSQL.setTipoJoin(colunaSQLOriginal.getTipoJoin());
        }
        if (colunaSQL.getClasseEnum() == null) {
            List fks = Util.array2List((Object[])colunaSQL.getChavesEstrangeiras());
            colunaSQL.setClasseEnum(grid.buscarClassEnum(this.rn.getTabela(), colunaSQL.getNome(), fks));
        }
        ColunaSQL colunaConfigurada = null;
        ColunaCustomizavelGrid colunaCustomizavel = grid.getColunaCustomizavel(colunaSQL);
        colunaConfigurada = colunaCustomizavel != null ? colunaCustomizavel.getColunaCustomizavel(colunaSQL) : this.rn.atualizaColunaSQLGrid(SessaoUtil.getSessao(), colunaSQL);
        if (colunaConfigurada.getTipoDadoBase() == null) {
            colunaConfigurada.setTipoDadoBase(colunaGrid.getTipoDado());
        }
        return colunaConfigurada;
    }

    private String getCacheIdPerfil() {
        return this.getCacheId().concat("_PERFIL_").concat(SessaoUtil.getSessao().getUsuario().getIdPerfil().toString());
    }

    private String getTabelaCampoExtra() {
        return !StringUtil.stringNullOrEmpty((String)this.getAliasTabelaCampoExtra()) ? this.getAliasTabelaCampoExtra() : (this.configuracaoCampoExtra != null ? this.configuracaoCampoExtra.TABELA() : null);
    }

    protected void addCustomFilterGrid(CustomFilterGrid customFilterGrid) {
        this.listaCustomFilterGrid.add(customFilterGrid);
    }
}

