/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.OrcamentoFaturamentoItem;
import br.intelidata.commons.domain.pojo.PedidoItem;
import br.intelidata.commons.domain.pojo.VendaNfceItem;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.pojo.compras.ProdutoCotacao;
import br.intelidata.commons.domain.pojo.edi.EDI;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.MovimentacaoMotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.pvdav.DavItem;
import br.intelidata.commons.domain.pojo.transferencia.RequisicaoTransferenciaItem;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoItem;
import br.intelidata.commons.modulo.edi.regranegocio.EDIRN;
import br.intelidata.commons.modulo.etiqueta.EtiquetaProduto;
import java.io.IOException;
import org.springframework.web.multipart.MultipartFile;

public class ImportacaoDadosColetor {
    private final Class classeOrigem;
    private final Long idCondicaoPagamento;
    private final Long precoPauta;
    private final TipoValorPreco tipoValorPreco;
    private final Long idEdi;
    private final MultipartFile file;
    private MovimentacaoMotivoAjusteEstoque movimentacaoMotivo;
    private boolean importarProdutosLoteSerie;
    private boolean isLevantamentoEstoque;
    private EDIProcessado EDIProcessado;

    public ImportacaoDadosColetor(Class classeOrigem, Long idEdi, MultipartFile file) {
        this(classeOrigem, idEdi, file, null, null, TipoValorPreco.PRECO);
    }

    public ImportacaoDadosColetor(Class classeOrigem, Long idEdi, MultipartFile file, MovimentacaoMotivoAjusteEstoque movimentacaoMotivoAjusteEstoque, boolean isLevantamentoEstoque) {
        this(classeOrigem, idEdi, file, null, null, TipoValorPreco.PRECO);
        this.movimentacaoMotivo = movimentacaoMotivoAjusteEstoque;
        this.isLevantamentoEstoque = isLevantamentoEstoque;
    }

    public ImportacaoDadosColetor(Class classeOrigem, Long idEdi, MultipartFile file, Long idCondicaoPagamento, Long precoPauta, TipoValorPreco tipoValorPreco) {
        this.classeOrigem = classeOrigem;
        this.idCondicaoPagamento = idCondicaoPagamento;
        this.precoPauta = precoPauta;
        this.idEdi = idEdi;
        this.file = file;
        this.tipoValorPreco = tipoValorPreco;
    }

    public void importar() throws UnicoMensagemUsuarioException {
        this.EDIProcessado = null;
        EDI edi = (EDI)EDIRN.getInstance().buscarPorId(this.idEdi);
        Remessa remessa = this.getRemessa();
        Sessao sessao = SessaoUtil.getSessao();
        if (this.classeOrigem.equals(AjusteEstoqueItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensAjusteEstoque(sessao, remessa, edi, this.movimentacaoMotivo, this.isLevantamentoEstoque);
        } else if (this.classeOrigem.equals(PedidoItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensFaturamento(PedidoItem::new, sessao, remessa, edi, this.precoPauta, this.idCondicaoPagamento, this.tipoValorPreco);
        } else if (this.classeOrigem.equals(OrcamentoFaturamentoItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensFaturamento(OrcamentoFaturamentoItem::new, sessao, remessa, edi, this.precoPauta, this.idCondicaoPagamento, this.tipoValorPreco);
        } else if (this.classeOrigem.equals(DavItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensDav(sessao, remessa, edi, this.precoPauta, this.idCondicaoPagamento);
        } else if (this.classeOrigem.equals(RequisicaoTransferenciaItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensRequisicaoTransferencia(sessao, remessa, edi, this.importarProdutosLoteSerie);
        } else if (this.classeOrigem.equals(EtiquetaProduto.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensEtiquetaProduto(sessao, remessa, edi, this.importarProdutosLoteSerie, this.isImportaApenasQtdUm());
        } else if (this.classeOrigem.equals(VendaNfceItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensFaturamento(VendaNfceItem::new, sessao, remessa, edi, this.precoPauta, this.idCondicaoPagamento, this.tipoValorPreco);
        } else if (this.classeOrigem.equals(PedidoCompra.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensPedidoCompra(sessao, remessa, edi);
        } else if (this.classeOrigem.equals(ConferenciaDocumentoItem.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaItensConferenciaDocumento(sessao, remessa, edi);
        } else if (this.classeOrigem.equals(ProdutoCotacao.class)) {
            this.EDIProcessado = EDIRN.getInstance().buscaProdutoCotacaoCompra(sessao, remessa, edi);
        }
    }

    private Remessa getRemessa() throws UnicoMensagemUsuarioException {
        Malote malote = new Malote();
        if (!this.file.isEmpty()) {
            try {
                malote.inclui("edi", this.file.getBytes());
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW639", "Arquivo n\u00e3o informado!", (Throwable)e);
            }
        } else {
            throw new UnicoMensagemUsuarioException("WEDI11", "Arquivo n\u00e3o informado!");
        }
        return new Remessa(malote);
    }

    public EDIProcessado<?> getEDIProcessado() {
        return this.EDIProcessado;
    }

    protected boolean isImportaApenasQtdUm() {
        return false;
    }
}

