/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.crud;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

public abstract class SimpleCrudController<Entity extends AbstractPojo, RN extends AbstractRegraNegocio>
implements CrudFile<Entity> {
    @Autowired
    protected StorageService saveFile;
    private TipoArquivoArmazenado tipoArquivoArmazenado;
    private RN rn;

    public SimpleCrudController() {
    }

    public SimpleCrudController(RN rn) {
        this.rn = rn;
    }

    public SimpleCrudController(RN rn, TipoArquivoArmazenado tipoArquivoArmazenado) {
        this.rn = rn;
        this.tipoArquivoArmazenado = tipoArquivoArmazenado;
    }

    @RequestMapping(method={RequestMethod.GET})
    @DBAutoCommit
    public Entity get(@RequestParam(required=false) Long parentId) throws UnicoMensagemUsuarioException {
        throw new RuntimeException("You must overwrite this method");
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Entity entity) throws UnicoMensagemUsuarioException {
        this.beforeCreate(entity);
        this.beforeSave(entity);
        Long id = this.rn.gravar(0, entity, SessaoUtil.getSessao());
        entity.setId(id);
        this.afterCreate(entity);
        this.afterSave(entity);
        return id;
    }

    @ResponseBody
    @RequestMapping(value={"/create-files"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long createWithFile(@RequestPart MultipartFile[] files, @RequestPart(value="entity") Entity entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.create(entity);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Entity entity) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis(entity);
        this.beforeUpdate(entity);
        this.beforeSave(entity);
        this.rn.gravar(1, entity, SessaoUtil.getSessao());
        this.afterUpdate(entity);
        this.afterSave(entity);
        return entity.getId();
    }

    @ResponseBody
    @RequestMapping(value={"/update-files"}, method={RequestMethod.PUT}, consumes={"multipart/form-data"})
    @DBTransaction
    public Long updateWithFiles(@RequestPart(value="files") MultipartFile[] files, @RequestPart(value="entity") Entity entity) throws UnicoMensagemUsuarioException {
        this.loadFile(files, entity);
        return this.update(entity);
    }

    public void beforeCreate(Entity entity) {
    }

    public void beforeUpdate(Entity entity) throws UnicoMensagemUsuarioException {
    }

    public void beforeSave(Entity entity) throws UnicoMensagemUsuarioException {
    }

    public void afterCreate(Entity entity) {
    }

    public void afterUpdate(Entity entity) {
    }

    public void afterSave(Entity entity) throws UnicoMensagemUsuarioException {
    }

    protected RN getRegraNegocio() {
        return (RN)this.rn;
    }

    public TipoArquivoArmazenado getTipoArmazenamento() {
        return this.tipoArquivoArmazenado;
    }

    public StorageService getStorageService() {
        return this.saveFile;
    }

    public boolean isGravarArquivoTabela() {
        return this.getStorageService().isTabela();
    }

    protected void validarCurrentTimeMillis(Entity entity) throws UnicoMensagemUsuarioException {
        if (entity != null && entity.getCurrentTimeMillis() != null && entity.getCurrentTimeMillis().compareTo(SGBDManager.getInstance().buscarDataHoraObjeto(this.rn.getTabela(), entity.getId())) != 0) {
            throw new UnicoMensagemUsuarioException("WWW309", "Este registro j\u00e1 sofreu altera\u00e7\u00f5es depois que foi carregado para altera\u00e7\u00e3o! Ser\u00e1 imposs\u00edvel continuar.");
        }
    }
}

