/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.prompt.produto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.prompt.FiltroListener;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoProduto;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.uniplusweb.core.grid.Grid;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.PromptGridService;
import br.intelidata.uniplusweb.web.rest.app.client.prompt.PromptController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="produtos-prompt")
public class ProdutoPromptController
extends PromptController<ProdutoDTOWeb, ProdutoRN> {
    @Autowired
    private Grid<?> grid;
    @Autowired
    private PromptGridService promptGrid;
    private boolean mostrarApenasProdutoVendaveis;
    private boolean isNotaEntrada = false;
    private Long idFornecedor;
    private BigDecimal peso = BigDecimal.ZERO;
    private BigDecimal precoUnitario = BigDecimal.ZERO;
    private Embalagem embalagem;
    private List<TipoEmbalagem> tiposEmbalagem;
    private TipoRegistroProduto tipo;
    private final Map<Integer, Integer> variacoes = new HashMap();
    private boolean adicionaFiltroCodigo = false;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public ProdutoPromptController(FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), new ColunaSQL("codigo"), new ColunaSQL[]{new ColunaSQL("ean"), new ColunaSQL("referencia"), new ColunaSQL("tipo")});
        this.funcionalidadeService = funcionalidadeService;
        this.tipo = TipoRegistroProduto.PRODUTO;
    }

    public ProdutoPromptController(FuncionalidadeService funcionalidadeService, TipoRegistroProduto tipo, boolean mostrarApenasProdutoVendaveis) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), new ColunaSQL("codigo"), new ColunaSQL[]{new ColunaSQL("ean"), new ColunaSQL("referencia"), new ColunaSQL("tipo")});
        this.funcionalidadeService = funcionalidadeService;
        this.tipo = tipo;
        this.mostrarApenasProdutoVendaveis = mostrarApenasProdutoVendaveis;
    }

    public ProdutoPromptController(FuncionalidadeService funcionalidadeService, TipoRegistroProduto tipo, boolean mostrarApenasProdutoVendaveis, boolean isNotaEntrada) {
        super((AbstractRegraNegocio)ProdutoRN.getInstance(), new ColunaSQL("referencia"), new ColunaSQL[]{new ColunaSQL("ean")});
        this.funcionalidadeService = funcionalidadeService;
        this.tipo = tipo;
        this.mostrarApenasProdutoVendaveis = mostrarApenasProdutoVendaveis;
        this.isNotaEntrada = isNotaEntrada;
        this.adicionaFiltroCodigo = true;
        this.addReferencia(new Referencia("codigo", "codigo"));
    }

    private void adicionarFiltrosProduto() {
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected ProdutoDTOWeb buscarObjeto(Long id) {
        return ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), id);
    }

    public ProdutoDTOWeb getObjeto() {
        ProdutoDTOWeb produto = (ProdutoDTOWeb)super.getObjeto();
        if (produto != null) {
            Unidademedida unidadeMedida;
            produto.setPrecoUnitario(this.getPrecoUnitario(produto.getCasasDecimais()));
            produto.setVariacoes(new HashMap(this.variacoes));
            produto.setVariacoesString(this.variacoes.entrySet().stream().map(entry -> new StringBuilder(String.valueOf(entry.getKey())).append("=").append(entry.getValue())).collect(Collectors.joining(";")));
            produto.setEmbalagem(this.embalagem);
            produto.setPossuiVariacao(VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(produto.getId()));
            if (!NumberUtil.longNullOuZero((Long)produto.getIdUnidadeMedida()) && (unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida())) != null) {
                produto.setPesoProduto(this.getPeso(produto.getIdUnidadeMedida()));
                produto.setObjUnidadeMedida(unidadeMedida);
                produto.setUnidademedida(unidadeMedida.getCodigo());
            }
        }
        return produto;
    }

    public void executaFiltros(String valorPesquisado) {
        this.precoUnitario = BigDecimal.ZERO;
        this.peso = BigDecimal.ZERO;
        this.embalagem = null;
        super.executaFiltros(valorPesquisado);
    }

    public String getValorColunaPrincipal(ProdutoDTOWeb objeto) {
        if (this.isNotaEntrada) {
            return Util.all2Atring((Object)BeanUtil.get((Object)objeto, (String)"codigo", (Object[])new Object[0]));
        }
        return super.getValorColunaPrincipal((Object)objeto);
    }

    public void aplicarCondicoes(Long idGrupo, Long idFornecedor, Long idFamilia, boolean filtrarInativo, List<TipoEmbalagem> tiposEmbalagem) throws UnicoMensagemUsuarioException {
        this.idFornecedor = idFornecedor;
        this.tiposEmbalagem = tiposEmbalagem;
        this.clearFiltros();
        this.limparReferencias();
        this.limparCondicoes();
        this.limpaReferenciaDefault();
        this.limparCondicoesDefault();
        this.adicionarFiltrosProduto();
        this.limpaVariacoes();
        this.promptGrid.setRn((AbstractRegraNegocio)ProdutoRN.getInstance());
        String cache = TipoRegistroProduto.SERVICO.equals((Object)this.tipo) ? "configuracao-prompt-servico" : "configuracao-prompt-produto";
        this.grid = this.promptGrid.getGrid(cache, this.tipo);
        this.setGridBuilder(this.grid.getGridBuilder());
        this.getGridBuilder().setLimparCondicoes(true);
        this.adicionarRegras();
        this.addFiltroReferenciaFornecedor();
        this.adicionarFiltros();
        if (this.adicionaFiltroCodigo) {
            this.addReferencia(new Referencia("codigo", "codigo"));
            this.addFiltroCodigo();
        }
        this.getGridBuilder().setLimparCondicoes(false);
        this.getGridBuilder().limparReferencias();
        this.getGridBuilder().limparCondicoes();
        this.getGridBuilder().limparCondicoesDefault();
        this.getGridBuilder().limparOrdenacoes();
        this.setFiltroPorIdHierarquia(idGrupo);
        this.aplicaFiltroFamilia(idFamilia);
        this.adicionaFiltroInativo(filtrarInativo);
        this.adicionaFiltroTipoProduto();
        this.adicionarCondicaoDefaultGridBuilder();
    }

    private void adicionarCondicaoDefaultGridBuilder() {
        this.promptGrid.getCondicoesDefault(this.tipo).forEach(condicao -> this.getGridBuilder().addCodicaoDefault(condicao));
    }

    private void adicionaFiltroTipoProduto() {
        if (this.mostrarApenasProdutoVendaveis) {
            Condicao condApenasVendaveis;
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 157)) {
                condApenasVendaveis = new Condicao("tipoproduto", Operador.CONTIDO_EM, TipoProduto.valuesIDS());
            } else {
                ArrayList<String> tipos = new ArrayList<String>();
                tipos.add(TipoProduto.PRODUTO_ACABADO.getId());
                tipos.add(TipoProduto.MERCADORIA_PARA_REVENDA.getId());
                if (this.tipo == null) {
                    tipos.add(TipoProduto.SERVICOS.getId());
                }
                condApenasVendaveis = new Condicao("tipoproduto", Operador.CONTIDO_EM, tipos.toArray(new String[0]));
            }
            this.getGridBuilder().addReferenciaDefault(new Referencia("tipoproduto", "tipoproduto"));
            this.getGridBuilder().addCodicaoDefault(condApenasVendaveis);
        }
    }

    private void adicionaFiltroInativo(boolean filtrarInativo) {
        Condicao condicaoInativo;
        Referencia refInativo;
        if (!filtrarInativo) {
            refInativo = new Referencia("inativo", "inativo");
            condicaoInativo = new Condicao("inativo", Operador.IGUAL, 0);
        } else {
            refInativo = new Referencia("inativo", "inativo");
            condicaoInativo = new Condicao("inativo", Operador.CONTIDO_EM, new Integer[]{0, 1});
        }
        this.addReferenciaDefault(refInativo);
        this.addCondicaoDefault(condicaoInativo);
        this.getGridBuilder().addReferenciaDefault(refInativo);
        this.getGridBuilder().addCodicaoDefault(condicaoInativo);
    }

    private void adicionarRegras() {
        boolean jaTeveCondicaoDefault = false;
        Referencia referenciaTipo = new Referencia("tipo", "tipo");
        this.getGridBuilder().addOrdemDefault(new Ordem("nome"));
        if (this.tipo != null) {
            this.addReferenciaDefault(referenciaTipo);
            this.addCondicao(new Condicao("tipo", Operador.IGUAL, this.tipo.getId()));
            jaTeveCondicaoDefault = true;
        }
        if (this.mostrarApenasProdutoVendaveis) {
            Condicao condApenasVendaveis = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 157) ? new Condicao("tipoproduto", Operador.CONTIDO_EM, TipoProduto.valuesIDS()) : new Condicao("tipoproduto", Operador.CONTIDO_EM, new String[]{TipoProduto.PRODUTO_ACABADO.getId(), TipoProduto.MERCADORIA_PARA_REVENDA.getId()});
            Referencia refApenasVendaveis = new Referencia("tipoproduto", "tipoproduto");
            this.addReferenciaDefault(refApenasVendaveis);
            this.addReferenciaDefault(referenciaTipo);
            if (this.tipo == null) {
                if (this.getCondicoesDefault().size() > 0) {
                    this.addCondicaoDefault(new Condicao(OperadorLogico.E));
                }
                this.addCondicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                this.addCondicaoDefault(condApenasVendaveis);
                this.addCondicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                jaTeveCondicaoDefault = true;
            } else if (this.tipo.equals((Object)TipoRegistroProduto.PRODUTO)) {
                this.addReferenciaDefault(refApenasVendaveis);
                this.addCondicaoDefault(condApenasVendaveis);
                jaTeveCondicaoDefault = true;
            }
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRODUTO_EMPRESA)) {
            Long idEmpresa = SessaoUtil.getSessao().getFilial().getIdEmpresa();
            USelect subSelect = new USelect("produtoempresa");
            subSelect.add(new ColunaSQL("idproduto"));
            subSelect.add((ColunaSQL)new Referencia("idempresa", "idempresa"));
            subSelect.add(new Condicao("idempresa", Operador.IGUAL, idEmpresa));
            if (this.tipo == null) {
                if (jaTeveCondicaoDefault) {
                    this.addCondicaoDefault(new Condicao(OperadorLogico.E));
                }
                this.addCondicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                subSelect.add(new Condicao("idempresa", Operador.IGUAL, idEmpresa));
                this.addCondicaoDefault(new Condicao("id", Operador.CONTIDO_EM, subSelect));
                this.addCondicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoRegistroProduto.PRODUTO.getId()));
                this.addCondicaoDefault(new Condicao(OperadorLogico.OU));
                this.addCondicaoDefault(new Condicao("tipo", Operador.IGUAL, TipoRegistroProduto.SERVICO.getId()));
                this.addCondicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
            } else if (this.tipo == TipoRegistroProduto.PRODUTO) {
                this.addCondicaoDefault(new Condicao("id", Operador.CONTIDO_EM, subSelect));
            }
        }
    }

    private void adicionarFiltros() {
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addFiltroCodigo() {
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addFiltroReferenciaFornecedor() {
        this.addFiltro((FiltroListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private BigDecimal getPrecoUnitario(int casasDecimais) {
        if (this.precoUnitario == null || this.precoUnitario.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal dividendo = casasDecimais > 0 && this.embalagem == null ? new BigDecimal(10).pow(casasDecimais) : BigDecimal.ONE;
        return this.precoUnitario.divide(dividendo, casasDecimais, 3);
    }

    private BigDecimal getPeso(Long idUnidadeMedida) {
        if (this.peso == null || this.peso.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        int casasDecimais = UnidademedidaRN.getInstance().getCasasDecimais(idUnidadeMedida);
        BigDecimal dividendo = casasDecimais > 0 ? new BigDecimal(10).pow(casasDecimais) : BigDecimal.ONE;
        BigDecimal peso_ = this.peso.divide(dividendo, casasDecimais, 3);
        return peso_;
    }

    public Map<Integer, Integer> getVariacoes() {
        return new HashMap<Integer, Integer>(this.variacoes);
    }

    private void limpaVariacoes() {
        this.variacoes.clear();
    }

    private void setFiltroPorIdHierarquia(Long idHierarquia) {
        if (idHierarquia != null) {
            this.getGridBuilder().addReferencia(new Referencia("idhierarquia", "idhierarquia"));
            this.getGridBuilder().setCondicao(new Condicao("idhierarquia", Operador.IGUAL, idHierarquia));
        }
    }

    private void aplicaFiltroFamilia(Long idFamilia) {
        if (idFamilia != null) {
            this.getGridBuilder().addReferencia(new Referencia("idfamilia"));
            this.getGridBuilder().addCondicao(new Condicao("idfamilia", Operador.IGUAL, idFamilia));
        }
    }

    public Grid<?> getGrid() {
        this.grid.setGridBuilder(this.getGridBuilder());
        return this.grid;
    }

    static /* synthetic */ boolean access$000(ProdutoPromptController x0) {
        return x0.isNotaEntrada;
    }

    static /* synthetic */ void access$100(ProdutoPromptController x0) {
        x0.limpaVariacoes();
    }

    static /* synthetic */ Map access$200(ProdutoPromptController x0) {
        return x0.variacoes;
    }

    static /* synthetic */ BigDecimal access$302(ProdutoPromptController x0, BigDecimal x1) {
        x0.peso = x1;
        return x0.peso;
    }

    static /* synthetic */ BigDecimal access$402(ProdutoPromptController x0, BigDecimal x1) {
        x0.precoUnitario = x1;
        return x0.precoUnitario;
    }

    static /* synthetic */ List access$500(ProdutoPromptController x0) {
        return x0.tiposEmbalagem;
    }

    static /* synthetic */ Embalagem access$602(ProdutoPromptController x0, Embalagem x1) {
        x0.embalagem = x1;
        return x0.embalagem;
    }

    static /* synthetic */ Long access$700(ProdutoPromptController x0) {
        return x0.idFornecedor;
    }
}

