/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.report;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoExtensaoPlanilha;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public abstract class AbstractReport
implements Serializable {
    public static final long serialVersionUID = 1L;
    private Long idEmpresa;
    protected List<Long> idsFiliais;
    private SaidaRelatorio saidaRelatorio;
    private boolean paisagem;
    private String delimitador;
    private String opcaoSaidaRelatorio;
    private TipoExtensaoPlanilha extensao;

    public void setSaidaRelatorio(SaidaRelatorio saidaRelatorio) {
        this.saidaRelatorio = saidaRelatorio;
    }

    public SaidaRelatorio getSaidaRelatorio() {
        if (this.saidaRelatorio == null) {
            this.saidaRelatorio = SaidaRelatorio.PDF;
        }
        return this.saidaRelatorio;
    }

    public void setIdsFiliais(List<Long> idsFiliais) {
        this.idsFiliais = idsFiliais;
    }

    public List<Long> getIdsFiliais() {
        if (ListMapUtil.listNullOrEmpty((List)this.idsFiliais)) {
            this.idsFiliais = Collections.singletonList(SessaoUtil.getSessao().getIdFilial());
        }
        return this.idsFiliais;
    }

    public br.intelidata.commons.core.uviewer.SaidaRelatorio getSaida() {
        return new br.intelidata.commons.core.uviewer.SaidaRelatorio(this.getSaidaRelatorio().getSaida(), this.getDelimitador(), this.isPaisagem(), this.getExtensao());
    }

    @JsonIgnore
    public List<Filial> getFiliais() {
        return FilialRN.getInstance().getFiliais(this.idsFiliais);
    }

    public boolean isPaisagem() {
        return this.paisagem;
    }

    public void setPaisagem(boolean paisagem) {
        this.paisagem = paisagem;
    }

    public String getDelimitador() {
        return this.delimitador;
    }

    public void setDelimitador(String delimitador) {
        this.delimitador = delimitador;
    }

    public Long getIdEmpresa() {
        return this.idEmpresa;
    }

    public void setIdEmpresa(Long idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public String getOpcaoSaidaRelatorio() {
        return this.opcaoSaidaRelatorio;
    }

    public void setOpcaoSaidaRelatorio(String opcaoSaidaRelatorio) {
        this.opcaoSaidaRelatorio = opcaoSaidaRelatorio;
    }

    public TipoExtensaoPlanilha getExtensao() {
        if (this.extensao == null) {
            this.extensao = TipoExtensaoPlanilha.XLS;
        }
        return this.extensao;
    }

    public void setExtensao(TipoExtensaoPlanilha extensao) {
        this.extensao = extensao;
    }
}

