/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.report;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.PreferenciaUsuario;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReport;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public abstract class Report<WrapperReport extends AbstractReport>
implements ICreateTask {
    public String getDescricao() {
        return this.getClass().getAnnotation(SubMenuMapping.class).NOME();
    }

    public TipoJob getTipoJob() {
        return TipoJob.REPORT;
    }

    public TypeQueue getQueue() {
        return TypeQueue.REPORT_QUEUE;
    }

    public TaskManager taskManager() {
        return (TaskManager)BeanUtil.getBean((String)"taskManager");
    }

    public JobMetadata setMetaData(Object wrapper) {
        JobMetadata metadata = new JobMetadata();
        if (this.getClass().getAnnotation(SubMenuMapping.class) != null) {
            metadata.set("report", this.getClass().getAnnotation(SubMenuMapping.class).ROTA());
        }
        return metadata;
    }

    @RequestMapping(value={"/agendar-relatorio"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarRelatorio(@RequestBody WrapperReport wrapperReport) throws UnicoMensagemUsuarioException {
        this.gravarPreferencias(wrapperReport);
        this.createTask(wrapperReport, null, "", true);
        if (this.isPersistir()) {
            ConfiguracaoCamposRN.getInstance().gravarConfiguracaoPorFilial(SessaoUtil.getSessao(), wrapperReport, this.nomeTabelaRelatorio());
        }
    }

    protected void gravarPreferencias(WrapperReport wrapper) throws UnicoMensagemUsuarioException {
        String saida = wrapper.getSaidaRelatorio().getDescricao();
        if (wrapper.getSaidaRelatorio() == SaidaRelatorio.ARQUIVO_TEXTO_DELIMITADO || wrapper.getSaidaRelatorio() == SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO) {
            saida = "ARQUIVO_TEXTO";
        }
        Sessao sessao = SessaoUtil.getSessao();
        PreferenciaUsuario preferenciaUsuario = sessao.getUsuario().getPreferenciaUsuario();
        preferenciaUsuario.setTipoSaidaRelatorio(saida);
        preferenciaUsuario.setDelimitadorRelatorio(wrapper.getDelimitador());
        preferenciaUsuario.setOpcaoSaidaRelatorio(wrapper.getOpcaoSaidaRelatorio());
        preferenciaUsuario.setOrientacaoSaidaRelatorio(wrapper.isPaisagem() ? 1 : 0);
        PreferenciaUsuarioRN.getInstance().salvaPreferenciasUsuario(sessao, preferenciaUsuario);
    }

    protected String nomeTabelaRelatorio() throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW684", "Implementar m\u00e9todo para dar nome a tabela do relat\u00f3rio");
    }

    @RequestMapping(method={RequestMethod.GET})
    @DBAutoCommit
    public WrapperReport get() throws UnicoMensagemUsuarioException {
        throw new RuntimeException("You must overwrite this method");
    }

    public boolean isPersistir() {
        return false;
    }
}

