/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.api.batch.RecurringJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;

public abstract class AbstractPrepareScheduler
extends RecurringJob {
    public AbstractPrepareScheduler(String name, String cronExpression, TipoJob tipoJob) {
        super(name, cronExpression, TypeQueue.RECURRING_QUEUE.getId(), tipoJob);
    }

    public AbstractPrepareScheduler(String name, String cronExpression, Long queue, TipoJob tipoJob) {
        super(name, cronExpression, queue, tipoJob);
    }

    public void prepareTenant() {
        TenantService tenantService = (TenantService)BeanUtil.getBean((String)"tenantService");
        ContextoHolder.setTenant((String)this.getTask().getTenant(), (String)tenantService.getDatabase(this.getTask().getTenant()));
        MDCConfigService mdcConfigService = (MDCConfigService)BeanUtil.getBean((String)"MDCConfigService");
        mdcConfigService.confiMDC(this.getTask().getTenant());
        this.connectionHandler = (IConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
    }

    public void prepareSession() {
        ContextoHolder.setsessaoScheduler((Sessao)SessaoUtil.getSessaoSistema());
    }

    protected void addMensagemRetorno(String mensagem) {
        this.addMensagemRetorno(null, mensagem);
    }

    protected void addMensagemRetorno(String codigo, String mensagem) {
        String mensagemRetorno = this.getTask().getRetorno();
        if (mensagemRetorno.length() > 0) {
            mensagemRetorno = mensagemRetorno + "\n";
        }
        mensagemRetorno = mensagemRetorno + mensagem;
        if (!StringUtil.stringNullOrEmpty((String)codigo)) {
            mensagemRetorno = mensagemRetorno + " (" + codigo + ")";
        }
        this.getTask().setRetorno(mensagemRetorno);
    }
}

