/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ResumoVendaDiariaGestaoRN;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumoVendaDiariaGestaoScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ResumoVendaDiariaGestaoScheduler() {
        super("Resumo de vendas di\u00e1ria do gest\u00e3o de compras", Cron.daily((int)2), TipoJob.RESUMO_VENDAS_DIARIA_GESTAO_WEB);
    }

    public void execute() throws Exception {
        this.log.info("Iniciando o processo para realizar o resumode vendas do cest\u00e3o de compras para o tenant: " + this.getTask().getTenant());
        ResumoVendaDiariaGestaoRN.getInstance().gerarResumoVendas(SessaoUtil.getSessaoJob(), this.log);
        this.log.info("Finalizando o processo para realizar o resumode vendas do cest\u00e3o de compras para o tenant: " + this.getTask().getTenant());
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return LicencaManager.getInstance().isGestaoCompras() && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO);
    }
}

