/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.scanntechcanaisvenda.SincronizadorScanntechCanaisVenda;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.scanntechcanaisvenda.ConfiguracaoScanntechCanaisVenda;
import br.intelidata.commons.domain.regranegocio.scanntech.ConfiguracaoScanntechCanaisVendaRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanntechCanaisVendaWebScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FuncionalidadeService funcionalidadeService = (FuncionalidadeService)BeanUtil.getBean((String)"funcionalidadeService");

    public ScanntechCanaisVendaWebScheduler() {
        super("Scanntech (Canais de venda)", Cron.dailyHour((int)1), TipoJob.SCANNTECH_ENVIO_OPERACOES_WEB);
    }

    public void execute() throws Exception {
        ConfiguracaoScanntechCanaisVenda configuracao = ConfiguracaoScanntechCanaisVendaRN.getInstance().buscar();
        if (configuracao != null) {
            this.log.info("Sincroniza\u00e7\u00e3o Scanntech (Canais de venda) do tenant: " + this.getTask().getTenant());
            new SincronizadorScanntechCanaisVenda(configuracao).sincronizar(SessaoUtil.getSessaoSistema());
            this.log.info("Sincroniza\u00e7\u00e3o Scanntech (Canais de venda) completada para o tenant: " + this.getTask().getTenant());
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return this.funcionalidadeService.isAtiva(Funcionalidade.SCANNTECH);
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

