/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.uniplusweb.web.rest.app.client.schedulers.map.ExecucaoScheduler;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.map.ExecucaoSchedulerInfoAdicional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SchedulersMap {
    private static final Map<String, List<ExecucaoScheduler>> schedulerMap = new TreeMap();

    public static void setExecucaoTenant(String scheduler, String tenant, Long millisInicio, boolean sucesso, String mensagem, String erro, String licenca, List<ExecucaoSchedulerInfoAdicional> infoAdicional) {
        ExecucaoScheduler execucaoScheduler = new ExecucaoScheduler();
        execucaoScheduler.setDescricao(scheduler);
        execucaoScheduler.setDuracao(Long.valueOf(System.currentTimeMillis() - millisInicio));
        execucaoScheduler.setDataHora(LocalDateTime.now());
        execucaoScheduler.setSucesso(sucesso);
        execucaoScheduler.setMensagem(mensagem);
        execucaoScheduler.setErro(erro);
        execucaoScheduler.setInfoAdicional(infoAdicional);
        execucaoScheduler.setLicenca(licenca);
        schedulerMap.compute(tenant, (s, lista) -> {
            if (lista == null) {
                lista = new ArrayList<ExecucaoScheduler>();
            }
            lista.removeIf(execSch -> execSch.getDescricao().equalsIgnoreCase(scheduler));
            lista.add(execucaoScheduler);
            return lista;
        });
    }

    public static Map<String, List<ExecucaoScheduler>> getExecucoes() {
        return schedulerMap;
    }
}

