/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers.backup;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.BackupService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BackupScheduler
extends AbstractPrepareScheduler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected UnipluswebProperties uwp;
    protected BackupService backupService;

    public BackupScheduler(String name, String cronExpression) {
        super(name, cronExpression, TypeQueue.RECURRING_QUEUE.getId(), TipoJob.BACKUP);
    }

    protected void executar() throws UnicoMensagemUsuarioException {
        boolean isAmazon = !this.getUwp().getAmbiente().isLocal();
        String url = this.getUwp().getDatasource().getRawUrl();
        String username = this.getUwp().getDatasource().getUsername();
        String password = this.getUwp().getDatasource().getPassword();
        if (isAmazon) {
            this.log.info("Iniciando backup para conta Amazon.");
            this.getBackupService().backupAmazon(this.getTask().getTenant(), ContextoHolder.getDatabase(), this.getUwp().getAmbiente().getNome(), url, username, password);
        } else {
            this.log.info("Iniciando backup local.");
            this.getBackupService().backupLocal(ContextoHolder.getDatabase(), url);
        }
    }

    public abstract UnipluswebProperties getUwp();

    public abstract BackupService getBackupService();
}

