/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.File;
import java.util.List;

public abstract class AbstractPrepareJob
extends AbstractJob {
    public AbstractPrepareJob(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void prepareTenant() {
        TenantService tenantService = (TenantService)BeanUtil.getBean((String)"tenantService");
        ContextoHolder.setTenant((String)this.getTask().getTenant(), (String)tenantService.getDatabase(this.getTask().getTenant()));
        MDCConfigService mdcConfigService = (MDCConfigService)BeanUtil.getBean((String)"MDCConfigService");
        mdcConfigService.confiMDC(this.getTask().getTenant());
        this.connectionHandler = (IConnectionHandler)BeanUtil.getBean((String)"connectionHandler");
    }

    public void prepareSession() throws UnicoMensagemUsuarioException {
        Long idUsuario = this.getJobMetadata().getIdUsuario();
        if (NumberUtil.longNullOuZero((Long)idUsuario)) {
            throw new UnicoMensagemUsuarioException("BATCH6", "Usu\u00e1rio n\u00e3o definido para o job " + this.getTask().getName());
        }
        Usuario usuario = UsuarioRN.getInstance().buscarPorId(idUsuario);
        Long idFilial = this.getJobMetadata().getIdFilial();
        if (NumberUtil.longNullOuZero((Long)idFilial)) {
            idFilial = usuario.getIdFilialTrabalho();
        }
        SessaoUtil.setSessaoJob((Sessao)Sessao.createSessao((Long)idUsuario, (Long)idFilial));
    }

    protected <T> T getObjetoDeserializado(Class<T> clazz) throws UnicoMensagemUsuarioException {
        Object c = JsonUtil.fromJson((String)this.getParameters(), clazz);
        if (c == null) {
            throw new UnicoMensagemUsuarioException("BATCH7", "Erro ao deserializar parametros");
        }
        return (T)c;
    }

    protected <T> List<T> getListaSerializada(Class<T> clazz) throws UnicoMensagemUsuarioException {
        List c = JsonUtil.fromJsonList((String)this.getParameters(), clazz);
        if (c == null) {
            throw new UnicoMensagemUsuarioException("BATCH8", "Erro ao deserializar parametros");
        }
        return c;
    }

    public void saveFile(File file) {
        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
        String url = storageService.saveFile(this.getTask().getTenant(), TipoArquivoArmazenado.JobExecutor, file, this.isGzip(), null, true);
        this.getTask().setUrl(url);
    }

    public Sessao getSessao() {
        return SessaoUtil.getSessaoJob();
    }

    public void notificar(boolean sucesso) {
        Notificacao notificacao;
        NotificationService notificationService = (NotificationService)BeanUtil.getBean((String)"notificationService");
        TipoNotificacaoSimples tipoNotificacao = null;
        if (sucesso) {
            notificacao = this.getNotificacaoSucesso(this.getTask());
            if (notificacao != null) {
                tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.SUCCESS : notificacao.getTipoNotificacao();
            }
        } else {
            notificacao = this.getNotificacaoErro(this.getTask());
            if (notificacao != null) {
                TipoNotificacaoSimples tipoNotificacaoSimples = tipoNotificacao = notificacao.getTipoNotificacao() == null ? TipoNotificacaoSimples.ERROR : notificacao.getTipoNotificacao();
            }
        }
        if (notificacao != null) {
            if (this.getTask().getTipoJob().equals((Object)TipoJob.DOWNLOAD_VERSAO)) {
                notificationService.notifyUser(this.getSessao().getIdUsuario(), notificacao.getMsg(), tipoNotificacao, NotificationType.DOWNLOAD);
            } else {
                notificationService.notifyUser(this.getSessao().getIdUsuario(), notificacao.getMsg(), tipoNotificacao);
            }
        }
    }

    protected abstract Notificacao getNotificacaoSucesso(Task var1);

    protected abstract Notificacao getNotificacaoErro(Task var1);

    protected void addMensagemRetorno(String mensagem) {
        this.addMensagemRetorno(null, mensagem);
    }

    protected void addMensagemRetorno(String codigo, String mensagem) {
        String mensagemRetorno = this.getTask().getRetorno();
        if (mensagemRetorno.length() > 0) {
            mensagemRetorno = mensagemRetorno + "\n";
        }
        mensagemRetorno = mensagemRetorno + mensagem;
        if (!StringUtil.stringNullOrEmpty((String)codigo)) {
            mensagemRetorno = mensagemRetorno + " (" + codigo + ")";
        }
        this.getTask().setRetorno(mensagemRetorno);
    }

    public boolean isAtivo() {
        return true;
    }
}

