/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.ServerStartupMonitor;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.domain.pojo.JobExecutor;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.JobExecutorCommonRN;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.service.AtualizacaoBaseDadosService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.GravacaoArquivoBlocoXService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.GerenciadorLicencaManager;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Profile(value={"dev", "prod"})
@Component
public class JobStartUp
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    final UnipluswebProperties unipluswebProperties;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final MDCConfigService mdcConfigService;
    private final JobExecutorService jobExecutorService;
    private final TenantService tenantService;
    private final IConnectionHandler connectionHandler;
    private final AtualizacaoBaseDadosService atualizacaoBaseDadosService;
    private final GerenciadorLicencaManager gerenciadorLicencaManager;
    private final GravacaoArquivoBlocoXService gravacaoArquivoBlocoXService;

    public JobStartUp(TenantService tenantService, JobExecutorService jobExecutorService, IConnectionHandler connectionHandler, UnipluswebProperties unipluswebProperties, MDCConfigService mdcConfigService, AtualizacaoBaseDadosService atualizacaoBaseDadosService, GerenciadorLicencaManager gerenciadorLicencaManager, GravacaoArquivoBlocoXService gravacaoArquivoBlocoXService) {
        this.tenantService = tenantService;
        this.jobExecutorService = jobExecutorService;
        this.connectionHandler = connectionHandler;
        this.unipluswebProperties = unipluswebProperties;
        this.mdcConfigService = mdcConfigService;
        this.atualizacaoBaseDadosService = atualizacaoBaseDadosService;
        this.gerenciadorLicencaManager = gerenciadorLicencaManager;
        this.gravacaoArquivoBlocoXService = gravacaoArquivoBlocoXService;
    }

    public int getOrder() {
        return 2;
    }

    public void onApplicationEvent(@NotNull ContextRefreshedEvent contextRefreshedEvent) {
        this.executarOperacoes();
    }

    void executarOperacoes() {
        this.marcarTenantsAtualiandoBaseDados();
        this.verificarTenants();
        ServerStartupMonitor.setIniciado((boolean)true);
        this.gerenciadorLicencaManager.recarregarLicencas();
        this.gravacaoArquivoBlocoXService.inicializarDiretorios();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verificarTenants() {
        this.log.info("Verificando atualiza\u00e7\u00f5es na base de dados e jobs pendentes...");
        for (Tenant tenant : this.tenantService.getTenants(true)) {
            this.mdcConfigService.confiMDC(tenant.getCodigo());
            this.log.info("Verificando tenant " + tenant.getCodigo());
            ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant.getCodigo()));
            try {
                this.connectionHandler.createConnection(true);
                ContextoHolder.setSessao((Sessao)SessaoUtil.getSessaoSistema());
                this.log.info("Usu\u00e1rio default ok");
                this.atualizacaoBaseDadosService.atualizacaoBaseDados(tenant.getCodigo());
                this.log.info("Usu\u00e1rio atualiza\u00e7\u00e3o da base de dados ok");
                SessaoWebRN.getInstance().apagaSessoesWeb();
                this.log.info("Sess\u00f5es web ok");
                this.recreateJobs(tenant.getCodigo());
                this.log.info("Jobs ok");
                ServerStartupMonitor.addTenantIniciado((String)tenant.getCodigo());
            }
            catch (Exception ex) {
                this.log.error("Falhou ao verificar o tenant " + tenant.getCodigo() + ": " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (this.connectionHandler.isConnected()) {
                    this.log.info("Liberando tenant " + tenant.getCodigo());
                    ControleRN.getInstance().setAtualizandoBaseDados(false);
                    this.connectionHandler.releaseConnection();
                }
            }
            this.log.info("Verifica\u00e7\u00e3o completa tenant " + tenant.getCodigo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarTenantsAtualiandoBaseDados() {
        this.log.info("Marcando tenants para atualizar base de dados");
        for (Tenant tenant : this.tenantService.getTenants(true)) {
            this.mdcConfigService.confiMDC(tenant.getCodigo());
            ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant.getCodigo()));
            try {
                this.connectionHandler.createConnection(true);
                ContextoHolder.setSessao((Sessao)SessaoUtil.getSessaoSistema());
                this.log.info("Marcar atualizar base de dados - Usu\u00e1rio default ok");
                ControleRN.getInstance().setAtualizandoBaseDados(true);
                this.log.info("Marcar atualizar base de dados - ok");
            }
            catch (Exception ex) {
                this.log.error("Falhou ao Marcar atualizar base de dados do tenant " + tenant.getCodigo() + ": " + ex.getMessage(), (Throwable)ex);
            }
            finally {
                if (this.connectionHandler.isConnected()) {
                    this.connectionHandler.releaseConnection();
                }
            }
            this.log.info("Marcar atualizar base de dados tenant " + tenant.getCodigo() + " OK ");
        }
    }

    private void recreateJobs(String tenant) {
        List list = JobExecutorCommonRN.getInstance().getJobExecutorPendentes();
        for (JobExecutor jobExecutor : list) {
            this.jobExecutorService.execute(jobExecutor, tenant);
        }
    }
}

