/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Job;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobCleanup;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JobsCleanup {
    private static final int DIAS = 7;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TenantService tenantService;
    private final JobExecutorService jobExecutorService;
    private final MDCConfigService mdcConfigService;
    private final IConnectionHandler connectionHandler;
    private final UnipluswebProperties unipluswebProperties;
    private final StorageService storageService;

    @Autowired
    public JobsCleanup(TenantService tenantService, JobExecutorService jobExecutorService, MDCConfigService mdcConfigService, IConnectionHandler connectionHandler, UnipluswebProperties unipluswebProperties, StorageService storageService) {
        this.tenantService = tenantService;
        this.jobExecutorService = jobExecutorService;
        this.mdcConfigService = mdcConfigService;
        this.connectionHandler = connectionHandler;
        this.unipluswebProperties = unipluswebProperties;
        this.storageService = storageService;
    }

    public void cleanup() {
        this.log.info("Removendo arquivos antigos");
        for (Tenant tenant : this.tenantService.getTenants(true)) {
            ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant));
            this.mdcConfigService.confiMDC(tenant.getCodigo());
            this.connectionHandler.createConnection(false);
            Usuario usuario = UsuarioRN.getInstance().getUsuarioDefault();
            if (tenant.getInativo() == 0) {
                this.jobExecutorService.executeSemJobPersistent((Job)new JobCleanup(this.storageService, this.unipluswebProperties, tenant.getCodigo(), usuario.getId(), usuario.getIdFilialTrabalho(), 7), TipoJob.JOB_CLEANUP);
            }
            this.connectionHandler.releaseConnection();
        }
        this.storageService.deleteShareFiles(7);
    }
}

