/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ajustedocumentofiscal;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AjusteDocumentoFiscal;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.InfluenciaRecolhimento;
import br.intelidata.commons.domain.pojo.enuns.OrigemTributacao;
import br.intelidata.commons.domain.pojo.enuns.ReflexoApuracaoICMS;
import br.intelidata.commons.domain.pojo.enuns.ResponsabilidadeEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoApuracao;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.AjusteDocumentoFiscalRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Arrays;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ajustes-documento-fiscal"})
@SubMenuMapping(MENU="SubMenuPainelContadorParametrosAuxiliarSpedFiscal", NOME="Ajuste de documento fiscal", ROTA="/speds/ajustes-documento-fiscal", PROGRAMA=1111)
public class AjusteDocumentoFiscalCrudController
extends CrudController<AjusteDocumentoFiscal, AjusteDocumentoFiscalRN> {
    public AjusteDocumentoFiscalCrudController() {
        super((AbstractRegraNegocio)AjusteDocumentoFiscalRN.getInstance(), AjusteDocumentoFiscal::new);
    }

    protected void beforeSave(AjusteDocumentoFiscal ajusteDocumentoFiscal, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String value = ajusteDocumentoFiscal.getCodigo();
        if (value.length() != 10) {
            throw new UnicoMensagemUsuarioException("WWW441", "O c\u00f3digo deve ter 10 caracteres!");
        }
        String strReflexoApuracao = value.substring(2, 3);
        ReflexoApuracaoICMS reflexoApuracao = (ReflexoApuracaoICMS)EnumUtils.getPorId(ReflexoApuracaoICMS.class, (Object)strReflexoApuracao);
        if (reflexoApuracao == null) {
            throw new UnicoMensagemUsuarioException("WWW2", "Terceira posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strReflexoApuracao + "]!");
        }
        String strTipoApuracao = value.substring(3, 4);
        TipoApuracao tipoApuracao = (TipoApuracao)EnumUtils.getPorId(TipoApuracao.class, (Object)strTipoApuracao);
        if (tipoApuracao == null) {
            throw new UnicoMensagemUsuarioException("WWW3", "Quarta posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strTipoApuracao + "]!");
        }
        String strResponsabilidade = value.substring(4, 5);
        ResponsabilidadeEnum responsabilidade = (ResponsabilidadeEnum)EnumUtils.getPorId(ResponsabilidadeEnum.class, (Object)strResponsabilidade);
        if (responsabilidade == null) {
            throw new UnicoMensagemUsuarioException("WWW4", "Quinta posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strResponsabilidade + "]!");
        }
        String strRecolhimento = value.substring(5, 6);
        InfluenciaRecolhimento recolhimento = (InfluenciaRecolhimento)EnumUtils.getPorId(InfluenciaRecolhimento.class, (Object)strRecolhimento);
        if (recolhimento == null) {
            throw new UnicoMensagemUsuarioException("WWW5", "Sexta posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strRecolhimento + "]!");
        }
        String strTributacao = value.substring(6, 7);
        OrigemTributacao tributacao = (OrigemTributacao)EnumUtils.getPorId(OrigemTributacao.class, (Object)strTributacao);
        if (tributacao == null) {
            throw new UnicoMensagemUsuarioException("WWW6", "S\u00e9tima posi\u00e7\u00e3o n\u00e3o \u00e9 v\u00e1lida o valor [" + strTributacao + "]!");
        }
    }

    protected GridBuilder<AjusteDocumentoFiscalRN> getGridBuilder() {
        return new GridBuilder(AjusteDocumentoFiscalRN.getInstance().getTabela(), Arrays.asList(new ColunaSQL("id", "ID", 0, false), new ColunaSQL("codigo", "C\u00f3digo", 0, true), new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true)));
    }

    protected String getCacheId() {
        return "ajustes-documento-fiscal";
    }
}

