/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ajusteestoque.ajusteestoqueitem;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.AjusteEstoque;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.Kit;
import br.intelidata.commons.domain.pojo.MotivoAjusteEstoque;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.KitCommonRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueRN;
import br.intelidata.commons.modulo.estoque.regranegocio.MotivoAjusteEstoqueRN;
import br.intelidata.commons.modulo.produto.regranegocio.KitRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoNumeroSerieRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/itens-ajuste-estoque"})
public class AjusteEstoqueItemCrudController
extends CrudController<AjusteEstoqueItem, AjusteEstoqueItemRN> {
    public AjusteEstoqueItemCrudController() {
        super((AbstractRegraNegocio)AjusteEstoqueItemRN.getInstance(), AjusteEstoqueItem::new);
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody AjusteEstoqueItem ajusteEstoqueItem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)ajusteEstoqueItem.getIdInventarioEstoque())) {
            throw new UnicoMensagemUsuarioException("WWW116", "Ajuste de estoque n\u00e3o definido.");
        }
        AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoqueItem.getIdInventarioEstoque());
        Long id = AjusteEstoqueItemRN.getInstance().gravarItemWeb(SessaoUtil.getSessao(), ajusteEstoque, ajusteEstoqueItem, 0);
        this.gravarAuditoriaRegistro(null, (AbstractPojo)ajusteEstoqueItem, 0);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return id;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody AjusteEstoqueItem ajusteEstoqueItem, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)ajusteEstoqueItem.getIdInventarioEstoque())) {
            throw new UnicoMensagemUsuarioException("WWW117", "Ajuste de estoque n\u00e3o definido.");
        }
        AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoqueItem.getIdInventarioEstoque());
        Long id = AjusteEstoqueItemRN.getInstance().gravarItemWeb(SessaoUtil.getSessao(), ajusteEstoque, ajusteEstoqueItem, 1);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return id;
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        AjusteEstoqueItem item = (AjusteEstoqueItem)AjusteEstoqueItemRN.getInstance().buscarPorId(id);
        if (item == null) {
            throw new UnicoMensagemUsuarioException("WWW14", "N\u00e3o foi poss\u00edvel excluir o registro.");
        }
        AjusteEstoqueItemRN.getInstance().excluirItem(SessaoUtil.getSessao(), item);
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<AjusteEstoqueItem> buscarItensAjuste(@RequestParam Long idAjuste) {
        AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(idAjuste);
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(idAjuste);
        if (ListMapUtil.listNullOrEmpty((List)itens)) {
            return itens;
        }
        MotivoAjusteEstoque motivoAjusteEstoque = (MotivoAjusteEstoque)MotivoAjusteEstoqueRN.getInstance().buscarPorId(ajusteEstoque.getIdMotivo());
        if (motivoAjusteEstoque != null) {
            AjusteEstoqueItemRN.getInstance().carregaListaNumeroSerie(itens, motivoAjusteEstoque.getCodigo().intValue());
        } else {
            itens.stream().filter(item -> !StringUtil.stringNullOrEmpty((String)item.getNumerosSerie())).forEach(item -> item.setListaNumeroSeries(ProdutoNumeroSerieRN.getInstance().getListaNumeroSerie(item.getNumerosSerie())));
        }
        HashMap produtos = ProdutoRN.getInstance().getProdutosAjusteEstoque(itens.stream().map(AjusteEstoqueItem::getIdProduto).collect(Collectors.toList()));
        itens.forEach(item -> {
            Produto produto = (Produto)produtos.get(item.getIdProduto());
            if (produto != null) {
                item.setCodigoProduto(produto.getCodigo());
                item.setDescricaoProduto(produto.getNome());
                item.setUnidadeMedida(produto.getUnidadeMedida());
                Unidademedida unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produto.getIdUnidadeMedida());
                item.setCasasDecimaisUN(Integer.valueOf(unidadeMedida != null ? unidadeMedida.getCasasdecimais() : 0));
                item.setQuantidade(item.getQuantidade().setScale((int)item.getCasasDecimaisUN(), RoundingMode.HALF_EVEN));
                item.setTotal(item.getTotal().setScale(2, RoundingMode.HALF_EVEN));
            }
        });
        List retorno = KitCommonRN.getInstance().agruparItensKit(itens);
        retorno.sort(Comparator.comparing(AjusteEstoqueItem::getId));
        return retorno;
    }

    @RequestMapping(value={"/agrupar"}, method={RequestMethod.POST})
    @DBTransaction
    public List<AjusteEstoqueItem> agruparItens(@RequestBody List<AjusteEstoqueItem> itens) {
        List<Object> itensAgrupados;
        Map<String, List<AjusteEstoqueItem>> mapItens = itens.stream().collect(Collectors.groupingBy(item -> item.getIdProduto().toString()));
        Optional<Map.Entry> filtro = mapItens.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).findFirst();
        if (filtro.isPresent()) {
            itensAgrupados = mapItens.values().stream().map(ajusteEstoqueItems -> {
                AjusteEstoqueItem itemBase = (AjusteEstoqueItem)ajusteEstoqueItems.get(0);
                String variacao = "";
                BigDecimal total = BigDecimal.ZERO;
                BigDecimal quantidade = BigDecimal.ZERO;
                ArrayList numerosSerie = new ArrayList();
                for (AjusteEstoqueItem item : ajusteEstoqueItems) {
                    quantidade = quantidade.add(item.getQuantidade());
                    if (!Util.listNullOrEmpty((List)item.getListaNumeroSeries())) {
                        numerosSerie.addAll(item.getListaNumeroSeries());
                    }
                    if (!StringUtil.stringNullOrEmpty((String)itemBase.getVariacoes())) {
                        variacao = VariacaoRN.getInstance().agruparVariacoes(variacao, item.getVariacoes());
                    }
                    total = total.add(item.getTotal());
                }
                itemBase.setVariacoes(variacao);
                itemBase.setListaVariacoes(VariacaoRN.getInstance().stringToMap(variacao));
                itemBase.setQuantidade(quantidade);
                itemBase.setListaNumeroSeries(numerosSerie);
                itemBase.setTotal(total.setScale(2, RoundingMode.HALF_EVEN));
                itemBase.setPreco(itemBase.getTotal().divide(itemBase.getQuantidade(), 6, RoundingMode.HALF_EVEN).setScale(6, RoundingMode.HALF_EVEN));
                return itemBase;
            }).collect(Collectors.toList());
            for (AjusteEstoqueItem ajusteEstoqueItem : itensAgrupados) {
                if (ajusteEstoqueItem.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
                List itensKit = KitRN.getInstance().buscarListaPorIdProdutoKit(SessaoUtil.getSessao(), ajusteEstoqueItem.getIdProduto());
                for (AjusteEstoqueItem itemKit : ajusteEstoqueItem.getFilhosKit()) {
                    BigDecimal qtdOriginal = itensKit.stream().filter(itK -> itK.getIdproduto().equals(itemKit.getIdProduto())).findFirst().orElseGet(Kit::new).getQuantidade();
                    itemKit.setQuantidade(qtdOriginal.multiply(ajusteEstoqueItem.getQuantidade()).setScale((int)ajusteEstoqueItem.getCasasDecimaisCusto(), RoundingMode.HALF_EVEN));
                }
            }
        } else {
            itensAgrupados = itens;
        }
        itensAgrupados.sort(Comparator.comparing(AjusteEstoqueItem::getId));
        return itensAgrupados;
    }

    protected GridBuilder<AjusteEstoqueItemRN> getGridBuilder() {
        return new GridBuilder(AjusteEstoqueItemRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected String getCacheId() {
        return "itens-ajuste-estoque";
    }
}

