/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.apuracaoimposto.apuracaoimpostoitem;

import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.fiscal.AjusteApuracaoImposto;
import br.intelidata.commons.domain.pojo.fiscal.ApuracaoImpostoItem;
import br.intelidata.commons.domain.pojo.sped.TipoCredito;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.sped.regranegocio.AjusteApuracaoImpostoRN;
import br.intelidata.commons.sped.regranegocio.ApuracaoImpostoItemAdicionalRN;
import br.intelidata.commons.sped.regranegocio.ApuracaoImpostoItemRN;
import br.intelidata.commons.sped.regranegocio.TipoCreditoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/apuracoes-impostos-itens"})
public class ApuracaoImpostoItemCrudController
extends CrudController<ApuracaoImpostoItem, ApuracaoImpostoItemRN> {
    public ApuracaoImpostoItemCrudController() {
        super((AbstractRegraNegocio)ApuracaoImpostoItemRN.getInstance(), ApuracaoImpostoItem::new);
    }

    @RequestMapping(value={"/buscar-apuracao-itens"})
    @DBAutoCommit
    public List<ApuracaoImpostoItem> buscarLista(@RequestParam Long idApuracao) {
        List listApuracao = ApuracaoImpostoItemRN.getInstance().buscaLista(idApuracao);
        for (ApuracaoImpostoItem aii : listApuracao) {
            if (!Util.longNullOuZero((Long)aii.getIdTipoCredito())) {
                TipoCredito tipoCredito = (TipoCredito)TipoCreditoRN.getInstance().buscarPorId(aii.getIdTipoCredito());
                aii.setDescricaoTipoCredito(tipoCredito.getDescricao());
            }
            if (!Util.longNullOuZero((Long)aii.getIdAjusteApuracaoImposto())) {
                AjusteApuracaoImposto ajuste = (AjusteApuracaoImposto)AjusteApuracaoImpostoRN.getInstance().buscarPorId(aii.getIdAjusteApuracaoImposto());
                aii.setDescricaoAjuste(ajuste.getDescricao());
            }
            aii.setInformacoesAdicionais(ApuracaoImpostoItemAdicionalRN.getInstance().buscaPorApuracaoImpostoItem(aii.getId()));
        }
        return listApuracao;
    }

    protected String getCacheId() {
        return "apuracoes-impostos-itens";
    }

    protected GridBuilder<ApuracaoImpostoItemRN> getGridBuilder() {
        return new GridBuilder(ApuracaoImpostoItemRN.getInstance().getTabela(), Collections.emptyList());
    }
}

