/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.backup;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.wrapper.ArquivoInfoWrapper;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerenciador-backups"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Gerenciador de c\u00f3pia de seguran\u00e7a", ROTA="/ferramentas/gerenciador-backups", PROGRAMA=1503, ICONE="icon-host")
public class GerenciadorBackupSimpleController {
    private final ResponseEntityService responseEntityService;

    public GerenciadorBackupSimpleController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/arquivos"})
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<ArquivoInfoWrapper> getArquivos() throws UnicoMensagemUsuarioException {
        try {
            ArrayList<ArquivoInfoWrapper> arquivos = new ArrayList<ArquivoInfoWrapper>();
            List paths = FileUtil.buscarListaBackup((String)FileUtil.DIRETORIO_BACKUP, (String)ContextoHolder.getTenant());
            for (Path path : paths) {
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                String nome = "";
                if (path.getFileName() != null) {
                    nome = path.getFileName().toString();
                }
                arquivos.add(new ArquivoInfoWrapper(path.toString(), nome, dataCriacaoArquivo, attr.size()));
            }
            return arquivos;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW716", "N\u00e3o foi poss\u00edvel recuperar os aquivos", (Throwable)e);
        }
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<Resource> download(@RequestBody ArquivoInfoWrapper backup) throws UnicoMensagemUsuarioException {
        try {
            Path path = Paths.get(backup.getPath(), new String[0]);
            UrlResource resource = new UrlResource(path.toUri());
            if (!resource.exists()) {
                throw new UnicoMensagemUsuarioException("WWW717", "Arquivo n\u00e3o encontrado.");
            }
            String nomeArquivo = "Backup_" + StringUtil.removerAcentosSubstituiCaracteresEspeciais((String)SessaoUtil.getSessao().getFilial().getRazaoSocialCompleta()).toUpperCase().replace(" ", "_").replace("'", "_").replace(",", "_").replace("\"", "_").concat(".backup");
            return this.responseEntityService.createSourceResponse((Resource)resource, nomeArquivo);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW718", "N\u00e3o foi poss\u00edvel realizar o download do arquivo.");
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public void delete(@RequestBody ArquivoInfoWrapper backup) throws UnicoMensagemUsuarioException {
        File file = new File(backup.getPath());
        if (!file.exists()) {
            throw new UnicoMensagemUsuarioException("WWW719", "Arquivo n\u00e3o encontrado.");
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW720", "N\u00e3o foi poss\u00edvel excluir o arquivo.");
        }
    }
}

