/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.pafecf.StatusEnvioBlocoX;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoArquivoBlocoX;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobWrapper;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BlocoXJobController
implements ICreateTask {
    protected final TaskManager taskManager;

    public BlocoXJobController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    public abstract void agendarTransmissao(@RequestBody BlocoXJobWrapper var1) throws UnicoMensagemUsuarioException;

    public abstract void consultarAguardando(@RequestBody BlocoXJobWrapper var1) throws UnicoMensagemUsuarioException;

    public abstract void agendarReprocessamento(@RequestBody BlocoXJobWrapper var1) throws UnicoMensagemUsuarioException;

    public abstract void agendarAtualizacaoStatus(@RequestBody BlocoXJobWrapper var1) throws UnicoMensagemUsuarioException;

    protected Predicate<EnvioBlocoX> getCondicaoTransmissao() {
        return this.getCondicaoDefault().and(envioBlocoX -> envioBlocoX.getStatus() == StatusEnvioBlocoX.ENVIAR || envioBlocoX.getStatus() == StatusEnvioBlocoX.ERRO);
    }

    protected Predicate<EnvioBlocoX> getCondicaoAguardando() {
        return this.getCondicaoDefault().and(envioBlocoX -> envioBlocoX.getStatus() == StatusEnvioBlocoX.AGUARDANDO);
    }

    protected Predicate<EnvioBlocoX> getCondicaoAtualizacaoStatus() {
        return this.getCondicaoDefault().and(envioBlocoX -> envioBlocoX.getStatus() == StatusEnvioBlocoX.SUCESSO || envioBlocoX.getStatus() == StatusEnvioBlocoX.ECF_INATIVA || envioBlocoX.getStatus() == StatusEnvioBlocoX.ERRO || envioBlocoX.getStatus() == StatusEnvioBlocoX.CANCELADO);
    }

    protected Predicate<EnvioBlocoX> getCondicaoReprocessamento() {
        return this.getCondicaoDefault().and(envioBlocoX -> envioBlocoX.getStatus() == StatusEnvioBlocoX.ERRO || envioBlocoX.getStatus() == StatusEnvioBlocoX.CANCELADO || envioBlocoX.getStatus() == StatusEnvioBlocoX.ECF_INATIVA);
    }

    private Predicate<EnvioBlocoX> getCondicaoDefault() {
        return envioBlocoX -> envioBlocoX.getTipoArquivo() != TipoArquivoBlocoX.ESTOQUE || !Util.stringNullOrEmpty((String)envioBlocoX.getArquivo());
    }

    protected void validarDocumentos(BlocoXJobWrapper blocoXJobWrapper, Predicate<EnvioBlocoX> condicao) throws UnicoMensagemUsuarioException {
        List documentos = blocoXJobWrapper.getDocumentos().stream().filter(condicao).collect(Collectors.toList());
        if (ListMapUtil.listNullOrEmpty(documentos)) {
            throw new UnicoMensagemUsuarioException("WWW550", "N\u00e3o existem documentos dispon\u00edveis para essa opera\u00e7\u00e3o.");
        }
        blocoXJobWrapper.setDocumentos(documentos);
    }
}

