/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.job;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.pafecf.TipoArquivoBlocoX;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.GravacaoArquivoBlocoXService;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXJobWrapper;
import java.io.File;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import unipaf.geracaoarquivo.blocox.AbstractGeraBlocoX;
import unipaf.geracaoarquivo.blocox.GravacaoArquivoBlocoX;
import unipaf.geracaoarquivo.blocox.transmissao.TransmissorBlocoX;

public abstract class AbstractBlocoXJob
extends AbstractPrepareJob {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String mensagemErro;
    protected File arquivoErros = null;
    protected BlocoXJobWrapper blocoXJobWrapper;
    protected final GravacaoArquivoBlocoXService gravacaoArquivoBlocoXService = (GravacaoArquivoBlocoXService)BeanUtil.getBean((String)"gravacaoArquivoBlocoXService");
    protected TransmissorBlocoX transmissorBlocoX;

    public AbstractBlocoXJob(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        this.transmissorBlocoX = new TransmissorBlocoX(this.getSessao(), (GravacaoArquivoBlocoX)this.gravacaoArquivoBlocoXService);
        this.blocoXJobWrapper = (BlocoXJobWrapper)this.getObjetoDeserializado(BlocoXJobWrapper.class);
    }

    protected EnvioBlocoX gerarArquivo(AbstractGeraBlocoX gerador) throws UnicoMensagemUsuarioException {
        EnvioBlocoX envioBlocoX = gerador.gerar();
        List advertencias = this.organizaAdvertencias(gerador, envioBlocoX);
        if (!Util.collectionNullOrEmpty((Collection)gerador.getAdvertencias())) {
            this.gerarArquivoAdvertencias(advertencias, envioBlocoX.getTipoArquivo());
            this.showMensagemUsuarioException("Corrigir as exce\u00e7\u00f5es antes de transmitir o Bloco x.");
        } else if (!Util.collectionNullOrEmpty((Collection)gerador.getMsgEstoquesNegativos())) {
            this.gerarArquivoAdvertencias(advertencias, envioBlocoX.getTipoArquivo());
            if (!this.blocoXJobWrapper.isIgnorarEstoqueNegativo()) {
                this.showMensagemUsuarioException("Existem produtos com estoque negativo no periodo " + Util.formataDataHora((Temporal)envioBlocoX.getDataReferencia(), (String)"dd/MM/yyyy") + ".Verifique na listagem os produtos negativos!");
            }
        }
        return envioBlocoX;
    }

    protected void showMensagemUsuarioException(String mensagemErro) throws UnicoMensagemUsuarioException {
        this.mensagemErro = mensagemErro;
        throw new UnicoMensagemUsuarioException("WWW549", this.mensagemErro);
    }

    private void gerarArquivoAdvertencias(List<String> advertencias, TipoArquivoBlocoX tipoArquivo) throws UnicoMensagemUsuarioException {
        UViewer rel = new UViewer(SaidaRelatorio.TEXTO_FORMATADO, "Relat\u00f3rio de Cr\u00edticas Bloco X - " + tipoArquivo.getDescricao(), new int[]{100});
        rel.inicioRelatorio();
        rel.escreveTexto("Advert\u00eancias");
        for (String linha : advertencias) {
            rel.inicioLinha();
            rel.escreveColuna(linha);
            rel.fimLinha();
        }
        rel.saltaLinha();
        rel.saltaLinha();
        rel.fimRelatorio();
        this.arquivoErros = (File)rel.getRemessa().getMalote().getMapArquivos().get("text");
        this.saveFile(this.arquivoErros);
    }

    private List<String> organizaAdvertencias(AbstractGeraBlocoX gerador, EnvioBlocoX envioBlocoX) {
        ArrayList<String> advertencias = new ArrayList<String>();
        if (!Util.collectionNullOrEmpty((Collection)gerador.getAdvertencias())) {
            List advertenciasGerador = gerador.getAdvertencias();
            advertenciasGerador.sort(String::compareTo);
            if (envioBlocoX.getTipoArquivo() == TipoArquivoBlocoX.ESTOQUE) {
                advertencias.add("\n------------ ARQUIVO BLOCO X ESTOQUE - REFER\u00caNCIA: " + Util.formataDataHora((Temporal)envioBlocoX.getDataReferencia(), (String)"MM/yyyy") + " ------------\n(O ARQUIVO N\u00c3O SER\u00c1 TRANSMITIDO AT\u00c9 QUE AS EXCE\u00c7\u00d5ES ABAIXO SEJAM CORRIGIDAS)\n");
            }
            advertencias.addAll(advertenciasGerador);
        }
        if (!Util.collectionNullOrEmpty((Collection)gerador.getMsgEstoquesNegativos())) {
            List msgEstoqueNegativo = gerador.getMsgEstoquesNegativos();
            msgEstoqueNegativo.sort(String::compareTo);
            advertencias.add("\n------------ ADVERT\u00caNCIA DE ESTOQUE NEGATIVO (O ARQUIVO PODE SER ENVIADO NORMALMENTE) REFER\u00caNCIA: " + Util.formataDataHora((Temporal)envioBlocoX.getDataReferencia(), (String)"MM/yyyy") + " ------------\n");
            advertencias.addAll(msgEstoqueNegativo);
        }
        return advertencias;
    }
}

