/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.job;

import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.job.AbstractBlocoXReducaoZJob;
import java.io.File;
import java.util.Map;
import unipaf.geracaoarquivo.blocox.GravacaoArquivoBlocoX;

public class BlocoXReducaoZExclusaoArquivoJob
extends AbstractBlocoXReducaoZJob {
    public BlocoXReducaoZExclusaoArquivoJob(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Bloco X - Exclus\u00e3o de arquivos anteriores da Redu\u00e7\u00e3o Z efetuada com sucesso.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao(TipoNotificacaoSimples.ERROR, "Bloco X - N\u00e3o foi poss\u00edvel excluir os arquivos anteriores da Redu\u00e7\u00e3o Z");
    }

    public void execute() throws Exception {
        Map exclusoes = EnvioBlocoXRN.getInstance().removerEnviosAntesInicioObrigacao(this.getSessao(), (GravacaoArquivoBlocoX)this.gravacaoArquivoBlocoXService);
        UViewer rel = new UViewer(SaidaRelatorio.TEXTO_FORMATADO, "Exclus\u00f5es", new int[]{100});
        rel.inicioRelatorio();
        rel.saltaLinha();
        for (Map.Entry linha : exclusoes.entrySet()) {
            rel.inicioLinha();
            rel.escreveColuna((String)linha.getKey() + " - " + ((Boolean)linha.getValue() != false ? "Sucesso." : "Falha"));
            rel.fimLinha();
        }
        rel.fimRelatorio();
        this.arquivoErros = (File)rel.getRemessa().getMalote().getMapArquivos().get("text");
        this.saveFile(this.arquivoErros);
    }
}

