/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.blocox.reducaoz;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.pafecf.EnvioBlocoX;
import br.intelidata.commons.modulo.pdv.regranegocio.EcfRN;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioBlocoXRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.BlocoXController;
import br.intelidata.uniplusweb.web.rest.app.crud.blocox.reducaoz.BlocoXReducaoZEcfWrapper;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/blocox-reducaoz"})
@SubMenuMapping(MENU="SubMenuPdvAuxiliar", NOME="Bloco X - Redu\u00e7\u00e3o Z", ROTA="/pdvs/blocox-reducaoz", PROGRAMA=1445)
public class BlocoXReducaoZController
extends BlocoXController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(value={"/envios"})
    @DBAutoCommit
    public List<EnvioBlocoX> buscarEnvios(@RequestParam(required=false) LocalDate dataInicial, @RequestParam(required=false) LocalDate dataFinal, @RequestParam(required=false) String ecf, @RequestParam(required=false, defaultValue="false") boolean apenasPendente) {
        Sessao sessao = SessaoUtil.getSessao();
        if (dataInicial == null) {
            dataInicial = DataHoraFactory.of((int)1, (int)1, (int)1);
        }
        if (dataFinal == null) {
            dataFinal = DataHoraFactory.of((int)9999, (int)12, (int)31);
        }
        try {
            this.limparEnvios(sessao);
        }
        catch (Throwable ex) {
            this.log.error("Erro ao limpar envios do Bloco X Reducao Z", ex);
        }
        return EnvioBlocoXRN.getInstance().consultarReducaoZ(sessao, dataInicial, dataFinal, ecf, apenasPendente);
    }

    @RequestMapping(value={"/ecfs"})
    @DBAutoCommit
    public List<BlocoXReducaoZEcfWrapper> buscarEcfs() {
        return EcfRN.getInstance().buscarListaEcfPorFilial(SessaoUtil.getSessao().getFilial().getCnpj()).stream().map(e -> new BlocoXReducaoZEcfWrapper(e.getNumeroSerie())).sorted(Comparator.comparing(BlocoXReducaoZEcfWrapper::getId)).collect(Collectors.toList());
    }
}

