/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.logtracker.cotacaoonline.CotacaoOnlineResponse;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.core.whatsapp.TipoIntegracaoWhatsAppEnum;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.ItemCriticaPedidoCompra;
import br.intelidata.commons.domain.pojo.compras.AprovacaoCotacaoResumoFornecedores;
import br.intelidata.commons.domain.pojo.compras.AprovacaoCotacaoResumoProdutos;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompra;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompraAprovacao;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompraEmail;
import br.intelidata.commons.domain.pojo.compras.ProdutoCotacao;
import br.intelidata.commons.domain.pojo.compras.TomadaPreco;
import br.intelidata.commons.domain.pojo.compras.TomadaPrecoItem;
import br.intelidata.commons.domain.pojo.crm.EntidadeContato;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.EnumTopN;
import br.intelidata.commons.domain.pojo.enuns.OrigemCotacao;
import br.intelidata.commons.domain.pojo.enuns.StatusCotacaoCompra;
import br.intelidata.commons.domain.pojo.enuns.StatusTomadaPreco;
import br.intelidata.commons.domain.pojo.enuns.TipoCotacaoCompra;
import br.intelidata.commons.domain.pojo.generico.LocalUsoTextoGenerico;
import br.intelidata.commons.domain.pojo.whatsapp.ConfiguracaoWhatsApp;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoWhatsAppRN;
import br.intelidata.commons.domain.regranegocio.cotacaoonline.CotacaoOnlineRNSimplificada;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.compras.regranegocio.CotacaoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.ProdutoCotacaoRN;
import br.intelidata.commons.modulo.compras.regranegocio.TomadaPrecoItemRN;
import br.intelidata.commons.modulo.compras.regranegocio.TomadaPrecoRN;
import br.intelidata.commons.modulo.compras.relatorio.CotacaoCompraRelatorioEmail;
import br.intelidata.commons.modulo.crm.regranegocio.EntidadeContatoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra.AprovacaoCotacaoComprasWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra.CotacaoCompraCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra.CotacaoComprasImpressaoReport;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra.CotacaoComprasWrapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/cotacao-compras"})
@SubMenuMapping(MENU="SubMenuComprasGeral", NOME="Cota\u00e7\u00e3o de compras", ROTA="/compras/cotacao-compras", ICONE="icon-exportar-doc", PROGRAMA=1314)
public class CotacaoCompraCrudController
extends CrudController<CotacaoCompra, CotacaoCompraRN> {
    public CotacaoCompraCrudController() {
        super((AbstractRegraNegocio)CotacaoCompraRN.getInstance(), CotacaoCompra::new, true, true);
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("status", "status_filtro", "Status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("dataemissao", "dataemissao_filtro", "Emiss\u00e3o", 0, false, new String[0]));
        colunas.add(new ColunaSQL("validade", "validade_filtro", "Validade", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idFilial", "Filial", 0, false));
        colunas.add(new ColunaSQL("codigo", "Cota\u00e7\u00e3o", 100, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("dataemissao", "Emiss\u00e3o", 120, true));
        colunas.add(new ColunaSQL("validade", "Validade", 120, true));
        colunas.add(new ColunaSQL("tomadaspreco", "tomadasprecostatus", "Tomadas status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("qtdfornecedores", "qtdfornecedoresstatus", "Fornecedores Status", 0, false, new String[0]));
        ColunaSQL tomadas = new ColunaSQL(Funcao.CONCATENAR_PARAMETROS, "qtdfornecedoresstatus", "tomadasprecofornecedores", new Object[]{new ColunaSQL("tomadasprecostatus", "tomadaspreco"), "/"});
        tomadas.setDescricao("Tomadas");
        tomadas.setTamanho(100);
        tomadas.setVisivel(true);
        tomadas.setVirtual(true);
        colunas.add(tomadas);
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        if (LicencaManager.getInstance().possuiLicencaCotacaoOnline(SessaoUtil.getSessao().getFilial().getCnpj())) {
            colunas.add(new ColunaSQL("publicado", "Publicado", 100, true));
            ColunaSQL colunaPublicado = new ColunaSQL("publicado", "publicadostatus", "Publicado Status", 0, false, new String[0]);
            colunas.add(colunaPublicado);
        }
        colunas.add(new ColunaSQL("compartilhado", "Enviado", 100, true));
        colunas.add(new ColunaSQL("pedidogerado", "Pedido gerado", 150, true));
        colunas.add(new ColunaSQL("compartilhado", "compartilhadostatus", "Compartilhado Status", 0, false, new String[0]));
        ColunaSQL colunaStatus = new ColunaSQL("status", "codigostatus", "Codigo Status", 0, false, new String[0]);
        colunas.add(colunaStatus);
        GridBuilder grid = new GridBuilder(((CotacaoCompraRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    @RequestMapping(value={"/publicar"})
    @DBTransaction
    public CotacaoOnlineResponse publicar(@RequestBody Long idCotacao) {
        return CotacaoOnlineRNSimplificada.getInstance().publicarCotacao(SessaoUtil.getSessao(), idCotacao);
    }

    protected void beforeRead(CotacaoCompra cotacaoCompra, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List listaProdutoCotacao = ProdutoCotacaoRN.getInstance().buscarListaTratadaPorIdCotacaoCompra(sessao, cotacaoCompra.getId(), modo == 7);
        List listaTomadaPreco = TomadaPrecoRN.getInstance().buscaPorIdCotacaoCompra(cotacaoCompra.getId(), modo == 7);
        if (modo == 7) {
            List idsProdutosNaoCotados = TomadaPrecoItemRN.getInstance().buscaListaIdsProdutosNaoCotados(cotacaoCompra.getId());
            cotacaoCompra.setIdsProdutosNaoCotados(idsProdutosNaoCotados);
            cotacaoCompra.setId(null);
            cotacaoCompra.setPublicado(false);
            cotacaoCompra.setDataAprovacaoCotacao(null);
            cotacaoCompra.setPedidoGerado(false);
            cotacaoCompra.setTipo(TipoCotacaoCompra.DIRETA);
            cotacaoCompra.setStatus(StatusCotacaoCompra.ABERTO);
            cotacaoCompra.setTomadasPreco(Integer.valueOf(0));
            cotacaoCompra.setUuid(UUID.randomUUID());
            CotacaoCompraRN.getInstance().gravar(0, cotacaoCompra, sessao);
            Long idCotacaoDuplicada = cotacaoCompra.getId();
            Long codigoCotacaoDuplicada = cotacaoCompra.getCodigo();
            cotacaoCompra.setId(idCotacaoDuplicada);
            cotacaoCompra.setCodigo(codigoCotacaoDuplicada);
            listaProdutoCotacao.forEach(p -> p.setIdCotacaoCompra(idCotacaoDuplicada));
            ProdutoCotacaoRN.getInstance().gravarProdutosCotacao(sessao, 0, listaProdutoCotacao, cotacaoCompra.getId(), TipoCotacaoCompra.DIRETA);
            listaTomadaPreco.forEach(tp -> {
                tp.setUuid(null);
                tp.setId(null);
                tp.setDataHoraPreenchimento(null);
                tp.setStatusTomadaPreco(StatusTomadaPreco.NAO_PREENCHIDO);
                tp.setIdCotacaoCompra(idCotacaoDuplicada);
            });
            TomadaPrecoRN.getInstance().criaTomadaPreco(sessao, listaTomadaPreco, 0, idCotacaoDuplicada, false);
        }
        cotacaoCompra.setProdutosCotacao(listaProdutoCotacao);
        cotacaoCompra.setTomadaPrecos(listaTomadaPreco);
        cotacaoCompra.setCotacaoCompraOriginal((CotacaoCompra)CotacaoCompraRN.getInstance().clonar((AbstractPojo)cotacaoCompra));
    }

    @RequestMapping(value={"/buscar-fornecedores-por-produto"})
    @DBAutoCommit
    public List<TomadaPreco> buscarPorProduto(@RequestParam Long idProduto) {
        Long idFornecedor = (Long)ProdutoRN.getInstance().buscarValorPorID(idProduto, "idFornecedor");
        return TomadaPrecoRN.getInstance().geraTomadasPrecoPorFornecedoDoProduto(SessaoUtil.getSessao(), idProduto, idFornecedor);
    }

    @RequestMapping(value={"/buscar-dados-compartilhamento"})
    @DBAutoCommit
    public List<CotacaoCompraEmail> buscarDadosEmail(@RequestParam Long[] idsCotacao) {
        Sessao sessao = SessaoUtil.getSessao();
        Long idTextoGenerico = TextoGenericoRN.getInstance().buscarTextoGenericoPorLocalUso(LocalUsoTextoGenerico.EMAIL_COTACAO_COMPRA);
        boolean preencherIcms = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 956);
        boolean preencherIcmsSt = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 957);
        boolean preencherIPI = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 958);
        ArrayList<CotacaoCompraEmail> fornecedorEmail = new ArrayList<CotacaoCompraEmail>();
        for (Long idCotacao : idsCotacao) {
            List listaTomadaPreco = TomadaPrecoRN.getInstance().buscaPorIdCotacaoCompra(idCotacao);
            String numeroCotacao = CotacaoCompraRN.getInstance().buscarValorPorID(idCotacao, "codigo").toString();
            for (TomadaPreco tomadaPreco : listaTomadaPreco) {
                CotacaoCompraEmail cotacaoCompraEmail = CotacaoCompraRN.getInstance().montaEmailEnvio(sessao, tomadaPreco, idTextoGenerico, sessao.getFilial(), preencherIcms, preencherIcmsSt, preencherIPI);
                cotacaoCompraEmail.setIdCotacao(idCotacao);
                cotacaoCompraEmail.setNumeroCotacao(numeroCotacao);
                fornecedorEmail.add(cotacaoCompraEmail);
            }
        }
        fornecedorEmail.sort(Comparator.comparing(CotacaoCompraEmail::isSelecionado).reversed().thenComparing(CotacaoCompraEmail::getCodigoFornecedor).thenComparing(CotacaoCompraEmail::getNumeroCotacao).thenComparing(CotacaoCompraEmail::getNomeVendedorDoFornecedor));
        return fornecedorEmail;
    }

    @PostMapping(value={"/pre-gravar"})
    @DBTransaction
    public Map<String, Object> preGravar(@RequestBody CotacaoCompra cotacaoCompra) throws UnicoMensagemUsuarioException {
        int transacao = Util.longNullOuZero((Long)cotacaoCompra.getId()) ? 0 : 1;
        cotacaoCompra.setOrigemCotacao(OrigemCotacao.MANUAL);
        cotacaoCompra.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        cotacaoCompra.setDataEmissao(DataHoraFactory.getData());
        cotacaoCompra.setTipo(TipoCotacaoCompra.DIRETA);
        cotacaoCompra.setStatus(StatusCotacaoCompra.ABERTO);
        if (transacao == 1) {
            List listaProdutoCotacao = ProdutoCotacaoRN.getInstance().buscarListaTratadaPorIdCotacaoCompra(SessaoUtil.getSessao(), cotacaoCompra.getId(), false);
            block0: for (ProdutoCotacao produtoCotacaoGravada : listaProdutoCotacao) {
                for (ProdutoCotacao p : cotacaoCompra.getProdutosCotacao()) {
                    if (!p.getIdProduto().equals(produtoCotacaoGravada.getIdProduto()) || !p.getIdFilial().equals(produtoCotacaoGravada.getIdFilial())) continue;
                    p.setId(produtoCotacaoGravada.getId());
                    continue block0;
                }
            }
        }
        CotacaoCompra cotacaoGravada = CotacaoCompraRN.getInstance().gravaCotacaoSimples(SessaoUtil.getSessao(), transacao, cotacaoCompra, cotacaoCompra.getProdutosCotacao(), cotacaoCompra.getTomadaPrecos());
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        retorno.put("id", cotacaoGravada.getId());
        retorno.put("codigo", cotacaoGravada.getCodigo());
        return retorno;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody CotacaoCompra cotacaoCompra, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return this.gravar(cotacaoCompra, 0);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody CotacaoCompra cotacaoCompra, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return this.gravar(cotacaoCompra, 1);
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        CotacaoCompra cotacaoCompra = (CotacaoCompra)this.read(id, Optional.empty(), 2, null);
        this.gravar(cotacaoCompra, 2);
    }

    private Long gravar(CotacaoCompra cotacaoCompra, int transacao) throws UnicoMensagemUsuarioException {
        if (transacao != 2) {
            cotacaoCompra.setIdFilial(SessaoUtil.getSessao().getIdFilial());
            if (cotacaoCompra.getOrigemCotacao() == null) {
                cotacaoCompra.setOrigemCotacao(OrigemCotacao.MANUAL);
            }
            if (cotacaoCompra.getDataEmissao() == null) {
                cotacaoCompra.setDataEmissao(DataHoraFactory.getData());
            }
            if (cotacaoCompra.getTipo() == null) {
                cotacaoCompra.setTipo(TipoCotacaoCompra.DIRETA);
            }
            if (cotacaoCompra.getStatus() == null) {
                cotacaoCompra.setStatus(StatusCotacaoCompra.ABERTO);
            }
            List listaProdutoCotacao = ProdutoCotacaoRN.getInstance().buscarListaTratadaPorIdCotacaoCompra(SessaoUtil.getSessao(), cotacaoCompra.getId(), false);
            block0: for (ProdutoCotacao produtoCotacaoGravada : listaProdutoCotacao) {
                for (ProdutoCotacao p2 : cotacaoCompra.getProdutosCotacao()) {
                    if (!p2.getIdProduto().equals(produtoCotacaoGravada.getIdProduto()) || !p2.getIdFilial().equals(produtoCotacaoGravada.getIdFilial())) continue;
                    p2.setId(produtoCotacaoGravada.getId());
                    continue block0;
                }
            }
            for (ProdutoCotacao p3 : cotacaoCompra.getProdutosCotacao()) {
                if (!Util.longNullOuZero((Long)p3.getIdCotacaoCompra())) continue;
                p3.setIdCotacaoCompra(cotacaoCompra.getId());
            }
            List listaTomadaPreco = TomadaPrecoRN.getInstance().buscaPorIdCotacaoCompra(cotacaoCompra.getId(), false);
            for (TomadaPreco tomadaPrecoGravada : listaTomadaPreco) {
                cotacaoCompra.getTomadaPrecos().stream().filter(t -> t.getIdFornecedor().equals(tomadaPrecoGravada.getIdFornecedor())).findFirst().ifPresent(p -> p.setId(tomadaPrecoGravada.getId()));
            }
            for (TomadaPreco tomadaPreco : cotacaoCompra.getTomadaPrecos()) {
                if (!Util.longNullOuZero((Long)tomadaPreco.getIdCotacaoCompra())) continue;
                tomadaPreco.setIdCotacaoCompra(cotacaoCompra.getId());
                tomadaPreco.setTomadaPrecoNova(true);
            }
        }
        return CotacaoCompraRN.getInstance().gravarCotacaoSemRequisicao(SessaoUtil.getSessao(), transacao, cotacaoCompra);
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(@RequestPart(value="file") MultipartFile file, @RequestParam Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ImportacaoDadosColetor importacaoDadosColetor = new ImportacaoDadosColetor(ProdutoCotacao.class, idEdi, file);
        importacaoDadosColetor.importar();
        EDIProcessado ediProcessado = new EDIProcessado();
        ediProcessado.getCriticas().addAll(importacaoDadosColetor.getEDIProcessado().getCriticas());
        for (ProdutoCotacao item : importacaoDadosColetor.getEDIProcessado().getProdutoCotacaos()) {
            String ean = (String)ProdutoRN.getInstance().buscarValorPorID(item.getIdProduto(), "ean");
            item.setEan(ean);
            item.setIdFilial(sessao.getFilial().getId());
            ediProcessado.addProdutoCotacao(item);
        }
        return ediProcessado;
    }

    @PostMapping(value={"/validar-produtos-edi"})
    @DBAutoCommit
    public CotacaoComprasWrapper validarProdutosEDI(@RequestBody CotacaoComprasWrapper wrapper) {
        List listaRetorno;
        if (!Util.listNullOrEmpty((List)wrapper.getProdutosCotacao())) {
            listaRetorno = wrapper.getProdutosCotacao();
            for (ProdutoCotacao produtoCotacao : wrapper.getProdutosEDI()) {
                ProdutoCotacao produtoAlterar = listaRetorno.stream().filter(p -> p.getIdProduto().equals(produtoCotacao.getIdProduto())).findFirst().orElse(null);
                if (produtoAlterar != null) {
                    produtoAlterar.setQuantidade(produtoAlterar.getQuantidade().add(produtoCotacao.getQuantidade()));
                    produtoAlterar.setVariacao(VariacaoRN.getInstance().agruparVariacoes(produtoAlterar.getVariacao(), produtoCotacao.getVariacao()));
                    continue;
                }
                listaRetorno.add(produtoCotacao);
            }
        } else {
            listaRetorno = wrapper.getProdutosEDI();
        }
        ArrayList<TomadaPreco> listaTomadaPreco = new ArrayList<TomadaPreco>();
        for (ProdutoCotacao produtoCotacao : listaRetorno) {
            Long idFornecedor = (Long)ProdutoRN.getInstance().buscarValorPorID(produtoCotacao.getIdProduto(), "idFornecedor");
            List tomadasPreco = TomadaPrecoRN.getInstance().geraTomadasPrecoPorFornecedoDoProduto(SessaoUtil.getSessao(), produtoCotacao.getIdProduto(), idFornecedor);
            for (TomadaPreco tomadaPreco : tomadasPreco) {
                if (!listaTomadaPreco.stream().noneMatch(t -> t.getIdFornecedor().equals(tomadaPreco.getIdFornecedor()))) continue;
                listaTomadaPreco.add(tomadaPreco);
            }
        }
        CotacaoComprasWrapper retorno = new CotacaoComprasWrapper();
        retorno.setProdutosCotacao(listaRetorno);
        retorno.setListaTomadaPreco(listaTomadaPreco);
        return retorno;
    }

    @PostMapping(value={"/cancelar"})
    @DBTransaction
    public Map<String, Object> cancelar(@RequestBody Long idCotacao) throws UnicoMensagemUsuarioException {
        String mensagemRetorno;
        Sessao sessao = SessaoUtil.getSessao();
        CotacaoCompra cotacao = (CotacaoCompra)CotacaoCompraRN.getInstance().buscarPorId(idCotacao);
        boolean cancelar = false;
        String textoCancelamento = null;
        if (LicencaManager.getInstance().possuiLicencaCotacaoOnline(sessao.getFilial().getCnpj()) && cotacao.isPublicado()) {
            CotacaoOnlineResponse response = CotacaoOnlineRNSimplificada.getInstance().cancelarCotacao(Collections.singletonList(cotacao.getUuid().toString()));
            if (response != null) {
                if (response.isSucesso()) {
                    cancelar = true;
                    textoCancelamento = response.getMensagemSucesso();
                } else {
                    textoCancelamento = response.getMensagemErro();
                }
            }
        } else {
            cancelar = true;
        }
        if (cancelar) {
            cotacao.setStatus(StatusCotacaoCompra.CANCELADO);
            cotacao.setPublicado(false);
            CotacaoCompraRN.getInstance().cancelar((AbstractPojo)cotacao, sessao);
            mensagemRetorno = !Util.stringNullOrEmpty((String)textoCancelamento) ? textoCancelamento : "Cota\u00e7\u00e3o cancelada com sucesso";
        } else {
            mensagemRetorno = !Util.stringNullOrEmpty(textoCancelamento) ? textoCancelamento : "Falhou no cancelamento da cota\u00e7\u00e3o";
        }
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        retorno.put("ok", cancelar);
        retorno.put("mensagem", mensagemRetorno);
        return retorno;
    }

    @PostMapping(value={"/cancelar-gravacao"})
    @DBTransaction
    public void cancelarGravacao(@RequestBody(required=false) CotacaoCompra cotacaoCompraAtual, @RequestParam Long idCotacaoAtual) throws UnicoMensagemUsuarioException {
        CotacaoCompra cotacaoCompraOriginal = cotacaoCompraAtual.getCotacaoCompraOriginal();
        if (cotacaoCompraOriginal != null) {
            this.compararListas(cotacaoCompraOriginal.getProdutosCotacao(), cotacaoCompraAtual.getProdutosCotacao(), (AbstractRegraNegocio)ProdutoCotacaoRN.getInstance(), (orig, atual) -> orig.getIdProduto().equals(atual.getIdProduto()) && orig.getIdFilial().equals(atual.getIdFilial()));
            this.compararListas(cotacaoCompraOriginal.getTomadaPrecos(), cotacaoCompraAtual.getTomadaPrecos(), (AbstractRegraNegocio)TomadaPrecoRN.getInstance(), (orig, atual) -> orig.getIdFornecedor().equals(atual.getIdFornecedor()));
        } else if (!Util.longNullOuZero((Long)idCotacaoAtual)) {
            this.delete(idCotacaoAtual);
        }
    }

    private <T> void compararListas(List<T> listaOriginal, List<T> listaAtual, AbstractRegraNegocio regraNegocio, CompararItemLista<T> comparador) throws UnicoMensagemUsuarioException {
        Object original;
        ArrayList<T> incluidos = new ArrayList<T>();
        ArrayList<Object> alterados = new ArrayList<Object>();
        ArrayList<T> excluidos = new ArrayList<T>();
        for (Object atual : listaAtual) {
            original = listaOriginal.stream().filter(t -> comparador.comparar(atual, t)).findFirst().orElse(null);
            if (original != null) {
                alterados.add(original);
                continue;
            }
            incluidos.add(atual);
        }
        for (Object atual : listaOriginal) {
            original = listaAtual.stream().filter(t -> comparador.comparar(atual, t)).findFirst().orElse(null);
            if (original != null) continue;
            excluidos.add(atual);
        }
        Sessao sessao = SessaoUtil.getSessao();
        if (!Util.listNullOrEmpty(incluidos)) {
            regraNegocio.excluirLista(sessao, incluidos);
        }
        if (!Util.listNullOrEmpty(excluidos)) {
            regraNegocio.gravarLista(0, excluidos, sessao);
        }
        if (!Util.listNullOrEmpty(alterados)) {
            regraNegocio.gravarLista(1, alterados, sessao);
        }
    }

    @RequestMapping(value={"/importar-online"})
    @DBAutoCommit
    public Map<String, Object> importarCotacoesOnline() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CotacaoOnlineResponse response = CotacaoOnlineRNSimplificada.getInstance().importarTomadaPrecoCotacaoOnline(sessao, sessao.getFilial().getId(), null, null);
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        if (response != null) {
            retorno.put("sucesso", response.isSucesso());
            retorno.put("mensagem", response.isSucesso() ? response.getMensagemSucesso() : response.getMensagemErro());
        } else {
            retorno.put("sucesso", false);
            retorno.put("mensagem", "N\u00e3o houve resposta do servidor");
        }
        return retorno;
    }

    @RequestMapping(value={"/permissoes"})
    @DBAutoCommit
    public Map<String, Boolean> buscarPermissoes(@RequestParam Long idCotacao) {
        ConfiguracaoWhatsApp configuracao;
        Sessao sessao = SessaoUtil.getSessao();
        HashMap<String, Boolean> retorno = new HashMap<String, Boolean>();
        CotacaoCompra cotacao = (CotacaoCompra)CotacaoCompraRN.getInstance().buscarPorId(idCotacao);
        if (cotacao != null && cotacao.getStatus() != null) {
            retorno.put("podeAlterar", StatusCotacaoCompra.ABERTO.equals((Object)cotacao.getStatus()));
            retorno.put("podeExcluir", cotacao.isPodeExcluir());
            retorno.put("enviaNotificacao", cotacao.isPodeCompartilhar());
            retorno.put("podeTomarPreco", cotacao.isPodeTomarPreco());
            retorno.put("podeAprovar", cotacao.isPodeAprovar());
            retorno.put("podeCancelar", cotacao.isPodeCancelar());
            retorno.put("podeCompartilhar", !LicencaManager.getInstance().possuiLicencaCotacaoOnline(sessao.getFilial().getCnpj()) || cotacao.isPublicado());
            retorno.put("podeImprimirAprovacao", cotacao.isPodeImprimirAprovacao());
            retorno.put("cotacaoOnlineAtiva", LicencaManager.getInstance().possuiLicencaCotacaoOnline(sessao.getFilial().getCnpj()));
        }
        retorno.put("whatsAppGWAtivo", (configuracao = ConfiguracaoWhatsAppRN.getInstance().buscaConfiguracaoUsuario(sessao)) != null && TipoIntegracaoWhatsAppEnum.WHATS_GW.equals((Object)configuracao.getTipoIntegracao()));
        return retorno;
    }

    @RequestMapping(value={"/buscar-dados-aprovacao"})
    @DBAutoCommit
    public Map<String, Object> buscarDadosAprovacao(@RequestParam Long idCotacaoCompra, @RequestParam boolean isCarregaNaoCotados, @RequestParam(required=false) EnumTopN topNFornecedores) {
        List lista = ProdutoCotacaoRN.getInstance().carregaCotacoesParaAprovacao(SessaoUtil.getSessao(), idCotacaoCompra, true, isCarregaNaoCotados, topNFornecedores);
        for (CotacaoCompraAprovacao aprovacao : lista) {
            Map dados = ProdutoRN.getInstance().buscarValoresPorID(aprovacao.getIdProduto(), new String[]{"idUnidadeMedida", "casasdecimais", "casasdecimaisprecocusto"});
            aprovacao.setDecimaisPreco(dados.getOrDefault("casasdecimais", 2).intValue());
            aprovacao.setDecimaisCusto(dados.getOrDefault("casasdecimaisprecocusto", 2).intValue());
            Long idUnidadeMedida = dados.getOrDefault("idUnidadeMedida", 0L);
            Map dadosUN = UnidademedidaRN.getInstance().buscarValoresPorID(idUnidadeMedida, new String[]{"casasdecimais"});
            aprovacao.setDecimaisQtd(dadosUN.getOrDefault("casasdecimais", 0).intValue());
        }
        Map retorno = CotacaoCompraRN.getInstance().buscarValoresPorID(idCotacaoCompra, new String[]{"codigo", "descricao", "origemCotacao"});
        retorno.put("dados", lista);
        return retorno;
    }

    @PostMapping(value={"/montar-resumo-aprovacao"})
    @DBAutoCommit
    public List<AprovacaoCotacaoResumoFornecedores> monstarResumo(@RequestBody CotacaoComprasWrapper wrapper) {
        ArrayList<AprovacaoCotacaoResumoFornecedores> listaResumo = new ArrayList<AprovacaoCotacaoResumoFornecedores>();
        for (CotacaoCompraAprovacao cotacao : wrapper.getCotacaoAprovacaoSelecionadas()) {
            if (listaResumo.stream().noneMatch(r -> r.getIdFornecedor().equals(cotacao.getIdFornecedor()))) {
                AprovacaoCotacaoResumoFornecedores resumo = new AprovacaoCotacaoResumoFornecedores();
                resumo.setIdFornecedor(cotacao.getIdFornecedor());
                resumo.setCodigoFornecedor(cotacao.getCodigoFornecedor());
                resumo.setNomeFornecedor(cotacao.getNomeFornecedor());
                resumo.setEstadoFornecedor(cotacao.getEstadoFornecedor());
                resumo.setQuantidadeFornecedor(cotacao.getQuantidadeFornecedor());
                resumo.setQuantidadeSolicitada(cotacao.getQuantidadeSolicitada());
                resumo.setValorTotal(cotacao.getValorTotal());
                resumo.setPedidoMinimo(cotacao.getPedidoMinimo());
                listaResumo.add(resumo);
                continue;
            }
            for (AprovacaoCotacaoResumoFornecedores resumo : listaResumo.stream().filter(r -> r.getIdFornecedor().equals(cotacao.getIdFornecedor())).collect(Collectors.toList())) {
                resumo.setQuantidadeFornecedor(resumo.getQuantidadeFornecedor().add(cotacao.getQuantidadeFornecedor()));
                resumo.setQuantidadeSolicitada(resumo.getQuantidadeSolicitada().add(cotacao.getQuantidadeSolicitada()));
                resumo.setValorTotal(resumo.getValorTotal().add(cotacao.getValorTotal()));
                resumo.setPedidoMinimo(cotacao.getPedidoMinimo());
            }
        }
        for (AprovacaoCotacaoResumoFornecedores aprovacao : listaResumo) {
            List cotacaoAprovacaoSelecionadas = wrapper.getCotacaoAprovacaoSelecionadas().stream().filter(c -> c.getIdFornecedor().equals(aprovacao.getIdFornecedor())).collect(Collectors.toList());
            ArrayList<AprovacaoCotacaoResumoProdutos> listaDetalhes = new ArrayList<AprovacaoCotacaoResumoProdutos>();
            for (CotacaoCompraAprovacao cotacao : cotacaoAprovacaoSelecionadas) {
                AprovacaoCotacaoResumoProdutos detalhe = new AprovacaoCotacaoResumoProdutos();
                detalhe.setCodigoProduto(cotacao.getCodigoProduto());
                detalhe.setNomeProduto(cotacao.getNomeProduto());
                detalhe.setCustoAquisicao(cotacao.getCustoAquisicao());
                detalhe.setPreco(cotacao.getPreco());
                detalhe.setIdProduto(cotacao.getIdProduto());
                detalhe.setPrecoVenda(cotacao.getPrecoVenda());
                detalhe.setPercentualICMS(cotacao.getPercentualICMS());
                detalhe.setPrecoLiquido(cotacao.getPrecoLiquido());
                detalhe.setPercentualIPI(cotacao.getPercentualIPI());
                detalhe.setUnidadeMedida(cotacao.getUnidadeMedida());
                detalhe.setValorICMSST(cotacao.getValorICMSST());
                detalhe.setQuantidadeFornecedor(cotacao.getQuantidadeFornecedor());
                detalhe.setQuantidadeSolicitada(cotacao.getQuantidadeSolicitada());
                detalhe.setValorTotal(cotacao.getValorTotal());
                listaDetalhes.add(detalhe);
            }
            aprovacao.setDetalhes(listaDetalhes);
        }
        return listaResumo;
    }

    @PostMapping(value={"/gravar-aprovacao"})
    @DBAutoCommit
    public Map<String, Object> gravarAprovacao(@RequestBody AprovacaoCotacaoComprasWrapper wrapper) throws UnicoMensagemUsuarioException {
        HashMap<String, Object> mapRetorno = new HashMap<String, Object>();
        Sessao sessao = SessaoUtil.getSessao();
        Map mapaTomadaPrecosAprovadas = TomadaPrecoRN.getInstance().buscaTomadasPrecoAprovadas(wrapper.getListaAprovacao());
        List criticas = TomadaPrecoRN.getInstance().verificaCriticasPedidoCompra(sessao, mapaTomadaPrecosAprovadas);
        if (!Util.listNullOrEmpty((List)criticas)) {
            if (Util.listNullOrEmpty((List)wrapper.getCriticas())) {
                mapRetorno.put("criticas", criticas);
                return mapRetorno;
            }
            for (ItemCriticaPedidoCompra critica : wrapper.getCriticas()) {
                for (ItemCriticaPedidoCompra itemCriticaPedidoCompra : criticas) {
                    if (!itemCriticaPedidoCompra.getChave().equals(critica.getChave())) continue;
                    ((TomadaPrecoItem)itemCriticaPedidoCompra.getObjetoOriginal()).setIdCfop(Long.valueOf(((Integer)((Map)critica.getObjetoOriginal()).get("idCfop")).longValue()));
                }
            }
        }
        CotacaoCompra cotacaoCompra = (CotacaoCompra)CotacaoCompraRN.getInstance().buscarPorId(wrapper.getIdCotacaoCompra());
        CotacaoCompraRN.getInstance().atualizaItensAprovados(sessao, cotacaoCompra, wrapper.getListaAprovacao());
        mapaTomadaPrecosAprovadas.values().forEach(tp -> tp.setIdCondicaoPagamento(cotacaoCompra.getIdCondicaoPagamento()));
        Map<Long, List<TomadaPreco>> mapaCotacoes = mapaTomadaPrecosAprovadas.values().stream().collect(Collectors.groupingBy(TomadaPreco::getIdCotacaoCompra));
        List idsPedidosCompra = PedidoCompraRN.getInstance().gerarPedidoCompraCotacoesAprovadas(sessao, mapaCotacoes, Collections.singletonList(cotacaoCompra.getId()), wrapper.getIdComprador(), wrapper.isPedidoConsolidadoFilialContexto(), wrapper.getIdFilialPedido(), wrapper.isGerarRequisicoesTransferencia());
        mapRetorno.put("idsPedidosCompra", idsPedidosCompra);
        return mapRetorno;
    }

    @RequestMapping(value={"/dados"})
    @DBAutoCommit
    public Map<String, Object> buscarDadosAprovacao(@RequestParam Long idCotacaoCompra) {
        return CotacaoCompraRN.getInstance().buscarValoresPorID(idCotacaoCompra, new String[]{"codigo", "descricao"});
    }

    @PostMapping(value={"/imprimirCotacao"})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody CotacaoComprasImpressaoReport report, @RequestParam Long idCotacaoCompra) throws UnicoMensagemUsuarioException {
        List listaTomadaPreco = TomadaPrecoRN.getInstance().buscaPorIdCotacaoCompra(idCotacaoCompra);
        if (!Util.listNullOrEmpty((List)listaTomadaPreco)) {
            ArrayList<byte[]> pdfs = new ArrayList<byte[]>();
            for (TomadaPreco tomadaPreco : listaTomadaPreco) {
                Entidade fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(tomadaPreco.getIdFornecedor());
                if (fornecedor == null) continue;
                EntidadeContato entidadeContato = null;
                if (!Util.longNullOuZero((Long)tomadaPreco.getIdEntidadeContato())) {
                    entidadeContato = (EntidadeContato)EntidadeContatoRN.getInstance().buscarPorId(tomadaPreco.getIdEntidadeContato());
                }
                UViewer cotacao = new CotacaoCompraRelatorioEmail().getRelatorio(SessaoUtil.getSessao(), idCotacaoCompra, fornecedor, entidadeContato, false, report.getColunaIdentificacao().equals("EAN"), report.getSaida().getSaida(), report.getSaida().isImprimirPaisagem());
                pdfs.add(cotacao.getRemessa().getMalote().extrai("pdf"));
            }
            ByteArrayOutputStream outputArquivoNovo = new ByteArrayOutputStream();
            Util.concatPDFs(pdfs, (OutputStream)outputArquivoNovo, (boolean)false);
            return this.responseEntityService.createPDFResponse(outputArquivoNovo.toByteArray());
        }
        return null;
    }

    protected String getCacheId() {
        return "cotacao-compras";
    }
}

