/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.TipoNotificacao;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompra;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompraEmail;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.compras.regranegocio.CotacaoCompraRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.cotacaocompra.CotacaoComprasCompartilhamentoWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/cotacao-compras"})
public class CotacaoCompraJobController
extends CompartilhamentoController<NotificacaoCompartilhamento> {
    public CotacaoCompraJobController(TaskManager taskManager) {
        super(taskManager);
    }

    @PostMapping(value={"/compartilhar-cotacoes"})
    @DBAutoCommit
    public void compartilharCotacoes(@RequestBody CotacaoComprasCompartilhamentoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Map<Long, List<CotacaoCompraEmail>> mapCotacoesEmail = wrapper.getCotacoesEmail().stream().collect(Collectors.groupingBy(CotacaoCompraEmail::getIdCotacao));
        for (Map.Entry<Long, List<CotacaoCompraEmail>> entry : mapCotacoesEmail.entrySet()) {
            Long idCotacao = entry.getKey();
            List<CotacaoCompraEmail> cotacaoCompraEmails = entry.getValue();
            CotacaoCompra cotacaoCompra = (CotacaoCompra)CotacaoCompraRN.getInstance().buscarPorId(idCotacao);
            List notificacoes = CotacaoCompraRN.getInstance().getListaNotificacao(sessao, cotacaoCompraEmails, wrapper.getTipoNotificacao(), cotacaoCompra);
            if (TipoNotificacao.EMAIL.equals((Object)wrapper.getTipoNotificacao())) {
                for (Notificacao notificacao : notificacoes) {
                    ParametrosEmailWeb parametrosEmail = EmailUtil.getParametros((Sessao)sessao, (String)notificacao.getEmail(), (String)notificacao.getEmailCopia(), (String)notificacao.getAssunto(), (String)notificacao.getMsg());
                    parametrosEmail.setAnexos(notificacao.getDataSources());
                    parametrosEmail.getParams().put("idCotacao", idCotacao);
                    this.createJobEmail(sessao, parametrosEmail, null);
                }
                continue;
            }
            if (!TipoNotificacao.WHATSAPP.equals((Object)wrapper.getTipoNotificacao())) continue;
            this.whatsAppService.enviarWhatsApp(notificacoes, sessao);
            cotacaoCompra.setCompartilhado(true);
            CotacaoCompraRN.getInstance().alterar((AbstractPojo)cotacaoCompra, sessao);
        }
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmail, "E-mail de cota\u00e7\u00e3o de compra");
        taskEmail.createTask((Object)parametrosEmail, "Envio de e-mail de cota\u00e7\u00e3o de compra");
    }

    @PostMapping(value={"/compartilhar"})
    @DBTransaction
    public String compartilhar(@RequestBody NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        return "";
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        return Collections.emptyList();
    }
}

