/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.gestaocompras;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.logtracker.cotacaoonline.CotacaoOnlineResponse;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.compras.AnaliseCompraFiltro;
import br.intelidata.commons.domain.pojo.compras.PedidoCompra;
import br.intelidata.commons.domain.pojo.compras.RascunhoCompraItem;
import br.intelidata.commons.domain.pojo.compras.RequisicaoCompraItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AnaliseCompraFiltroRN;
import br.intelidata.commons.domain.regranegocio.cotacaoonline.CotacaoOnlineRNSimplificada;
import br.intelidata.commons.modulo.compras.regranegocio.AnaliseComprasRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.RequisicaoCompraItemRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.vendas.relatorio.AnaliseVendasProduto;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.gestaocompras.GestaoComprasGerarCotacaoCompraWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.gestaocompras.GestaoComprasGerarPedidoCompraWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.gestaocompras.GestaoComprasWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gestao-compras"})
@SubMenuMapping(MENU="SubMenuComprasGeral", NOME="Gest\u00e3o de compras", ROTA="/compras/gestao-compras", ICONE="icon-duplicar", PROGRAMA=1479)
public class GestaoComprasCrudController
extends CrudController<PedidoCompra, PedidoCompraRN> {
    public GestaoComprasCrudController() {
        super((AbstractRegraNegocio)PedidoCompraRN.getInstance(), PedidoCompra::new, true, true, false);
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 150, true));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("razaosocial", "Raz\u00e3o social", 0, true));
        colunas.add(new ColunaSQL("telefone", "Telefone", 150, true));
        USelect uSelectDataUltimo = new USelect("pedidocompra", "dataultimopedido");
        uSelectDataUltimo.add(new ColunaSQL("dataemissao", "dataultimopedido"));
        uSelectDataUltimo.add((ColunaSQL)new Referencia("id", "idpedidocompra"));
        uSelectDataUltimo.add((ColunaSQL)new Referencia("idfornecedor"));
        uSelectDataUltimo.add(new Condicao("idfornecedor", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        uSelectDataUltimo.add(new Ordem("dataultimopedido", true));
        uSelectDataUltimo.add(new Ordem("idpedidocompra", true));
        uSelectDataUltimo.setLimit(1);
        USelect uSelectProximaVisita = new USelect("pedidocompra", "proximavisita");
        uSelectProximaVisita.add((ColunaSQL)new Referencia("ciclocompras", "ciclocomprasfornecedor", new String[]{"fk_pedidocompra_entidade"}));
        uSelectProximaVisita.add((ColunaSQL)new Referencia("dataemissao"));
        uSelectProximaVisita.add((ColunaSQL)new Referencia("id", "idpedidocompra"));
        uSelectProximaVisita.add((ColunaSQL)new Referencia("idfornecedor"));
        uSelectProximaVisita.add(new ColunaSQL(Funcao.DATE_ADD_DAY, "dataemissao", "proximavisita", new Object[]{"ciclocomprasfornecedor"}));
        uSelectProximaVisita.add(new Condicao("idfornecedor", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        uSelectProximaVisita.add(new Ordem("dataemissao", true));
        uSelectProximaVisita.add(new Ordem("idpedidocompra", true));
        uSelectProximaVisita.setLimit(1);
        ColunaSQL colunaUltimoPedido = new ColunaSQL(uSelectDataUltimo, "\u00daltimo pedido de compra", 200, true);
        colunaUltimoPedido.setTipoDadoBase(TipoDadoBase.DATE);
        colunas.add(colunaUltimoPedido);
        ColunaSQL colunaProximaVisita = new ColunaSQL(uSelectProximaVisita, "Pr\u00f3xima visita do fornecedor", 200, true);
        colunaProximaVisita.setTipoDadoBase(TipoDadoBase.DATE);
        colunas.add(colunaProximaVisita);
        GridBuilder grid = new GridBuilder(EntidadeRN.getInstance().getTabela(), colunas, "gestao_compras");
        grid.addReferenciaDefault(new Referencia("fornecedor"));
        grid.addReferenciaDefault(new Referencia("ciclocompras"));
        grid.addReferenciaDefault(new Referencia("inativo"));
        grid.addCodicaoDefault(new Condicao("fornecedor", Operador.IGUAL, 1));
        grid.addCodicaoDefault(new Condicao("inativo", Operador.IGUAL, 0));
        grid.addOrdemDefault(new Ordem("razaosocial"));
        return grid;
    }

    @RequestMapping(value={"/filtrar"})
    @DBAutoCommit
    public List<AnaliseVendasProduto> filtrar(@RequestBody AnaliseCompraFiltro filtro) throws UnicoMensagemUsuarioException {
        filtro.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        AnaliseComprasRN analiseComprasRN = new AnaliseComprasRN();
        analiseComprasRN.processaDados(SessaoUtil.getSessao(), filtro, null);
        return analiseComprasRN.getListaProdutos();
    }

    @RequestMapping(value={"/buscar-itens-requisicao-pendentes"})
    @DBAutoCommit
    public List<RequisicaoCompraItem> buscarItensRequisicaoPendentes(@RequestParam(required=false) List<Long> idsFiliais) {
        if (Util.listNullOrEmpty(idsFiliais)) {
            idsFiliais = Collections.singletonList(SessaoUtil.getSessao().getIdFilial());
        }
        return RequisicaoCompraItemRN.getInstance().buscarItensRequisicaoPendentes(idsFiliais, null, null);
    }

    @RequestMapping(value={"/filtro-por-idfornecedor"})
    @DBAutoCommit
    public AnaliseCompraFiltro getFiltroPorIdFornecedor(@RequestParam(required=false) Long idFornecedor) {
        AnaliseCompraFiltro filtro = AnaliseCompraFiltroRN.getInstance().buscaFiltroPorUsuario(SessaoUtil.getSessao().getIdUsuario(), idFornecedor);
        if (filtro == null) {
            filtro = new AnaliseCompraFiltro();
        }
        filtro.setDataInicial(null);
        filtro.setDataFinal(null);
        filtro.setDiasParaCompra(0);
        Map mapFornecedor = EntidadeRN.getInstance().buscarValoresPorID(idFornecedor, new String[]{"cicloCompras", "prazoEntrega"});
        if (!Util.mapNullOrEmpty((Map)mapFornecedor)) {
            Integer cicloCompras = mapFornecedor.getOrDefault("cicloCompras", 0);
            Integer prazoEntrega = mapFornecedor.getOrDefault("prazoEntrega", 0);
            int cicloCompleto = (cicloCompras != null ? cicloCompras : 0) + (prazoEntrega != null ? prazoEntrega : 0);
            filtro.setDataInicial(DataHoraFactory.getData().minusDays(cicloCompleto));
            filtro.setDataFinal(DataHoraFactory.getData());
            filtro.setDiasParaCompra(cicloCompleto);
        }
        return filtro;
    }

    @RequestMapping(value={"/analise-para-rascunho"})
    @DBAutoCommit
    public List<RascunhoCompraItem> transformaAnaliseEmRascunhoCompraItem(@RequestBody GestaoComprasWrapper wrapper) throws UnicoMensagemUsuarioException {
        AnaliseComprasRN analiseComprasRN = new AnaliseComprasRN();
        return analiseComprasRN.transformaEmRascunhoCompraItem(wrapper.getListaRascunhoCompraItem(), wrapper.getListaAnaliseVendasProduto());
    }

    @RequestMapping(value={"/analise-filial-para-rascunho"})
    @DBAutoCommit
    public List<RascunhoCompraItem> transformaAnaliseFilialEmRascunhoCompraItem(@RequestBody GestaoComprasWrapper wrapper) throws UnicoMensagemUsuarioException {
        AnaliseComprasRN analiseComprasRN = new AnaliseComprasRN();
        return analiseComprasRN.transformaEmRascunhoCompraItem(wrapper.getListaRascunhoCompraItem(), wrapper.getAnaliseProduto(), wrapper.getListaAnaliseVendasProdutoFilial());
    }

    @RequestMapping(value={"/gerar-pedido-compra"})
    @DBTransaction
    public void gerarPedidoCompra(@RequestBody GestaoComprasGerarPedidoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        wrapper.getFiltro().setIdUsuario(sessao.getUsuario().getId());
        AnaliseComprasRN.getInstance().gerarPedidoCompraAnalise(sessao, wrapper.getIdFilial(), wrapper.getIdFornecedor(), wrapper.getFiltro().getItensRascunho(), wrapper.getIdComprador(), wrapper.getIdCondicaoPgmto(), wrapper.getDataEntregaPrevista(), wrapper.isCompraCentralizada(), wrapper.isGerarRequisicoesTransferencia(), wrapper.getIdCfop(), wrapper.getFiltro());
    }

    @RequestMapping(value={"/gerar-cotacao-compra"})
    @DBTransaction
    public List<Long> gerarCotacaoCompra(@RequestBody GestaoComprasGerarCotacaoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        wrapper.getFiltro().setIdUsuario(sessao.getUsuario().getId());
        List idsCotacoes = AnaliseComprasRN.getInstance().gerarCotacaoAnaliseCompra(sessao, wrapper.getFiltro().getItensRascunho(), wrapper.getListaTomadaPrecos(), wrapper.isCompraCentralizada(), wrapper.isGerarRequisicoesTransferencia(), wrapper.getIdFilial(), wrapper.getDescricao(), wrapper.getObservacao(), wrapper.getFiltro());
        if (LicencaManager.getInstance().possuiLicencaCotacaoOnline(sessao.getFilial().getCnpj()) && PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 1050)) {
            for (Long idCotacao : idsCotacoes) {
                CotacaoOnlineResponse response = CotacaoOnlineRNSimplificada.getInstance().publicarCotacao(Contexto.getInstance().getSessao(), idCotacao);
                if (response.isSucesso()) continue;
                throw new UnicoMensagemUsuarioException("WCMP213", response.getMensagemErro());
            }
            return idsCotacoes;
        }
        return null;
    }

    @PostMapping(value={"/salvar-rascunho"})
    @DBTransaction
    public Long salvarRacunho(@RequestBody AnaliseCompraFiltro filtro) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        filtro.setIdUsuario(sessao.getUsuario().getId());
        AnaliseCompraFiltro filtroAtual = AnaliseCompraFiltroRN.getInstance().buscaFiltroPorUsuario(sessao.getUsuario().getId(), filtro.getIdFornecedor());
        if (filtroAtual != null) {
            filtro.setId(filtroAtual.getId());
        }
        return AnaliseCompraFiltroRN.getInstance().atualizaFiltroUsuario(sessao, filtro);
    }

    protected String getCacheId() {
        return "gestao-compras";
    }
}

