/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.requisicaocompra;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.uviewer.UViewer;
import br.intelidata.commons.domain.pojo.ItemCriticaPedidoCompra;
import br.intelidata.commons.domain.pojo.compras.RequisicaoCompra;
import br.intelidata.commons.domain.pojo.compras.RequisicaoCompraItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.compras.regranegocio.CotacaoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.PedidoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.RequisicaoCompraItemRN;
import br.intelidata.commons.modulo.compras.regranegocio.RequisicaoCompraRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImpressaoCrudWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.compras.requisicaocompra.RequisicaoCompraWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/requisicao-compras"})
@SubMenuMapping(MENU="SubMenuComprasGeral", NOME="Requisi\u00e7\u00e3o de compras", ROTA="/compras/requisicao-compras", ICONE="icon-em-pedido", PROGRAMA=703)
public class RequisicaoCompraCrudController
extends CrudController<RequisicaoCompra, RequisicaoCompraRN> {
    public RequisicaoCompraCrudController() {
        super((AbstractRegraNegocio)RequisicaoCompraRN.getInstance(), RequisicaoCompra::new, true, true);
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("status", "status_default", "Status", 0, false, new String[0]));
        colunas.add(new ColunaSQL("codigo", "Requisi\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("nome", "usuario", "Usu\u00e1rio", 0, true, new String[]{"fk_requisicaocompra_usuario"}));
        colunas.add(new ColunaSQL("dataemissao", "Emiss\u00e3o", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 0, true));
        GridBuilder grid = new GridBuilder(((RequisicaoCompraRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addOrdem(new Ordem("id"));
        return grid;
    }

    @RequestMapping(value={"/processar"})
    @DBTransaction
    public Map<String, Object> processar(@RequestBody RequisicaoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        List criticas;
        HashMap<String, Object> mapRetorno = new HashMap<String, Object>();
        Sessao sessao = SessaoUtil.getSessao();
        HashMap mapPedidoCompra = new HashMap();
        HashMap mapCotacoes = new HashMap();
        RequisicaoCompraRN.getInstance().separaPedidoCompraCotacao(mapPedidoCompra, mapCotacoes, wrapper.getIds());
        if (!Util.mapNullOrEmpty(mapPedidoCompra) && !Util.listNullOrEmpty((List)(criticas = RequisicaoCompraRN.getInstance().getCriticasItensPedidoCompra(mapPedidoCompra, sessao.getFilial().getEstado(), sessao.getFilial()))) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CALCULAR_IMPOSTOS_PEDIDO_COMPRA)) {
            if (!Util.listNullOrEmpty((List)wrapper.getCriticas())) {
                for (ItemCriticaPedidoCompra critica : wrapper.getCriticas()) {
                    for (ItemCriticaPedidoCompra itemCriticaPedidoCompra : criticas) {
                        if (!itemCriticaPedidoCompra.getChave().equals(critica.getChave())) continue;
                        ((RequisicaoCompraItem)itemCriticaPedidoCompra.getObjetoOriginal()).setIdCfop(Long.valueOf(((Integer)((Map)critica.getObjetoOriginal()).get("idCfop")).longValue()));
                    }
                }
            } else {
                mapRetorno.put("criticas", criticas);
                return mapRetorno;
            }
        }
        if (!Util.mapNullOrEmpty(mapPedidoCompra) || !Util.mapNullOrEmpty(mapCotacoes)) {
            if (!Util.mapNullOrEmpty(mapPedidoCompra)) {
                PedidoCompraRN.getInstance().gerarPedidoCompraItensRequisicaoPorFornecedor(sessao, mapPedidoCompra);
            }
            Long idCotacao = null;
            if (!Util.mapNullOrEmpty(mapCotacoes)) {
                idCotacao = CotacaoCompraRN.getInstance().criarCotacoesRequisicaoCompra(sessao, (List)mapCotacoes.get("itensCotacao"), (List)mapCotacoes.get("fornecedores"));
            }
            for (Long idRequisicao : wrapper.getIds()) {
                RequisicaoCompraRN.getInstance().marcarProcessada(sessao, idRequisicao);
            }
            if (!Util.longNullOuZero(idCotacao)) {
                mapRetorno.put("idCotacao", idCotacao);
            }
        } else {
            throw new UnicoMensagemUsuarioException("WCMP102", "Processamento n\u00e3o realizado! Verifique se os produtos da requisi\u00e7\u00e3o possuem fornecedor.");
        }
        Set idsPedidos = mapPedidoCompra.values().stream().flatMap(Collection::stream).map(RequisicaoCompraItem::getIdPedidoCompra).filter(id -> !Util.longNullOuZero((Long)id)).collect(Collectors.toSet());
        if (idsPedidos.size() == 1) {
            mapRetorno.put("idPedidoCompra", idsPedidos.iterator().next());
        }
        return mapRetorno;
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelar(@RequestBody RequisicaoCompraWrapper wrapper) throws UnicoMensagemUsuarioException {
        RequisicaoCompraRN.getInstance().cancelarRequisicoes(SessaoUtil.getSessao(), wrapper.getIds());
    }

    protected void beforeRead(RequisicaoCompra requisicaoCompra, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        requisicaoCompra.setItens(RequisicaoCompraItemRN.getInstance().buscarListaPorIdRequisicaoCompra(requisicaoCompra.getId()));
    }

    protected void afterImprimirCrud(UViewer uViewer, ImpressaoCrudWrapper impressaoCrudWrapper) {
        if (impressaoCrudWrapper.getDados().containsKey("itens")) {
            uViewer.saltaLinha();
            uViewer.inicioNivel(new int[]{20, 30, 20, 20});
            uViewer.inicioTitulo();
            uViewer.escreveTitulo("Produto", false);
            uViewer.escreveTitulo("Descri\u00e7\u00e3o", false);
            uViewer.escreveTitulo("UN", false);
            uViewer.escreveTitulo("Quantidade", true);
            uViewer.fimTitulo();
            List listaItens = (List)impressaoCrudWrapper.getDados().get("itens");
            for (Map mapItem : listaItens) {
                uViewer.inicioLinha();
                uViewer.escreveColuna((String)mapItem.get("produto"));
                uViewer.escreveColuna((String)mapItem.get("descricao"));
                uViewer.escreveColuna((String)mapItem.get("unidadeMedida"));
                int casasDecimais = mapItem.get("decimaisUN") != null ? (Integer)mapItem.get("decimaisUN") : 2;
                uViewer.escreveColuna(this.tratarNumeroImpressaoCrud(mapItem.get("quantidade"), casasDecimais));
                uViewer.fimLinha();
            }
            uViewer.fimNivel();
        }
    }

    protected String getCacheId() {
        return "requisicao-compras";
    }
}

