/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.compras.tomadaprecos;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.logtracker.cotacaoonline.CotacaoOnlineResponse;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompra;
import br.intelidata.commons.domain.pojo.compras.CotacaoCompraEmail;
import br.intelidata.commons.domain.pojo.compras.ImportacaoTomadaPrecoCotacao;
import br.intelidata.commons.domain.pojo.compras.TomadaPreco;
import br.intelidata.commons.domain.pojo.compras.TomadaPrecoItem;
import br.intelidata.commons.domain.pojo.crm.EntidadeContato;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.cotacaoonline.CotacaoOnlineRNSimplificada;
import br.intelidata.commons.modulo.compras.regranegocio.CotacaoCompraRN;
import br.intelidata.commons.modulo.compras.regranegocio.TomadaPrecoRN;
import br.intelidata.commons.modulo.crm.regranegocio.EntidadeContatoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/tomada-precos"})
public class TomadaPrecoCrudController
extends SimpleCrudController<CotacaoCompra, CotacaoCompraRN> {
    @Autowired
    protected ResponseEntityService responseEntityService;

    public TomadaPrecoCrudController() {
        super((AbstractRegraNegocio)CotacaoCompraRN.getInstance());
    }

    @DBAutoCommit
    public CotacaoCompra get(Long parentId) {
        Sessao sessao = SessaoUtil.getSessao();
        CotacaoCompra cotacaoCompra = (CotacaoCompra)CotacaoCompraRN.getInstance().buscarPorId(parentId);
        cotacaoCompra.setTomadaPrecos(new ArrayList(TomadaPrecoRN.getInstance().carregaMapaTomadaPrecoPorFornecedorEVendedor(cotacaoCompra).values()));
        cotacaoCompra.setIdsProdutosTomadaPreco(TomadaPrecoRN.getInstance().getIdsProdutosCotacao(sessao, cotacaoCompra));
        for (TomadaPreco tomadaPreco : cotacaoCompra.getTomadaPrecos()) {
            if (Util.listNullOrEmpty((List)tomadaPreco.getTomadaPrecoItens())) continue;
            for (TomadaPrecoItem item : tomadaPreco.getTomadaPrecoItens()) {
                Map dadosPro = ProdutoRN.getInstance().buscarDadosPorID(item.getIdProduto());
                Long idUnidadeM = (Long)dadosPro.get("idunidademedida");
                int casasPreco = dadosPro.getOrDefault("casasdecimais", 2);
                int casasUnidadeMedida = 2;
                if (!Util.longNullOuZero((Long)idUnidadeM)) {
                    casasUnidadeMedida = UnidademedidaRN.getInstance().getCasasDecimais(idUnidadeM);
                }
                item.setDecimaisPreco(casasPreco);
                item.setDecimaisQtd(casasUnidadeMedida);
            }
        }
        return cotacaoCompra;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody CotacaoCompra cotacaoCompra) throws UnicoMensagemUsuarioException {
        TomadaPrecoRN.getInstance().gravaTomadaPreco(SessaoUtil.getSessao(), cotacaoCompra, cotacaoCompra.getTomadaPrecos());
        return null;
    }

    @RequestMapping(value={"/buscar-link-cotacao-online"})
    @DBAutoCommit
    public String buscarLinkCotacaoOnline(@RequestParam String uuidTomadaPreco) {
        return CotacaoOnlineRNSimplificada.getInstance().getLinkCotacaoOnline(uuidTomadaPreco, SessaoUtil.getSessao().getFilial().getCnpj());
    }

    @PostMapping(value={"/calcular-preco"})
    @DBAutoCommit
    public TomadaPreco calcularPreco(@RequestBody TomadaPreco tomadaPreco) {
        Sessao sessao = SessaoUtil.getSessao();
        TomadaPrecoRN.getInstance().calculaPrecos(sessao, sessao.getFilial(), tomadaPreco);
        return tomadaPreco;
    }

    @RequestMapping(value={"/importar-cotacao-online"})
    @DBAutoCommit
    public Map<String, Object> importarCotacaoOnline(@RequestParam Long idCotacao) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        CotacaoOnlineResponse response = CotacaoOnlineRNSimplificada.getInstance().importarTomadaPrecoCotacaoOnline(sessao, sessao.getFilial().getId(), idCotacao, null);
        HashMap<String, Object> retorno = new HashMap<String, Object>();
        retorno.put("sucesso", response.isSucesso());
        retorno.put("mensagem", response.isSucesso() ? "As tomadas de pre\u00e7o foram atualizadas." : "N\u00e3o foi poss\u00edvel atualizar as tomadas de pre\u00e7o.");
        if (response.isSucesso()) {
            CotacaoCompra cotacaoCompra = CotacaoCompraRN.getInstance().buscaCotacaoCompraCompleta(sessao, idCotacao);
            retorno.put("tomadasPreco", new ArrayList(TomadaPrecoRN.getInstance().carregaMapaTomadaPrecoPorFornecedorEVendedor(cotacaoCompra).values()));
        }
        return retorno;
    }

    @ResponseBody
    @RequestMapping(value={"/importar-arquivos"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public Map<String, Object> importarArquivos(@RequestPart MultipartFile[] files, @RequestParam Long idCotacao) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        HashMap<String, byte[]> bytesArquivos = new HashMap<String, byte[]>();
        for (MultipartFile arquivo : files) {
            try {
                bytesArquivos.put(arquivo.getOriginalFilename(), arquivo.getBytes());
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("CMP231", "Erro ao ler arquivo " + arquivo.getName());
            }
        }
        HashMap<String, Object> mapRetorno = new HashMap<String, Object>();
        ImportacaoTomadaPrecoCotacao retorno = CotacaoCompraRN.getInstance().importarArquivos(sessao, bytesArquivos, idCotacao);
        if (!Util.listNullOrEmpty((List)retorno.getTomadaPrecos())) {
            mapRetorno.put("sucesso", true);
            mapRetorno.put("mensagem", "Importa\u00e7\u00e3o realizada com sucesso.");
            mapRetorno.put("tomadasPreco", retorno.getTomadaPrecos());
        } else {
            mapRetorno.put("sucesso", false);
            mapRetorno.put("mensagem", "Importa\u00e7\u00e3o n\u00e3o realizada. " + retorno.getMensagemRetorno().replace(Util.newLine(), " "));
        }
        return mapRetorno;
    }

    @RequestMapping(value={"/gerar-arquivos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarArquivoContacaoFornecedor(@RequestBody TomadaPreco tomadaPreco) throws UnicoMensagemUsuarioException {
        DataSource[] arquivos;
        CotacaoCompraEmail fornecedor = new CotacaoCompraEmail();
        fornecedor.setFornecedor((Entidade)EntidadeRN.getInstance().buscarPorId(tomadaPreco.getIdFornecedor()));
        if (!Util.longNullOuZero((Long)tomadaPreco.getIdEntidadeContato())) {
            fornecedor.setVendedorDoFornecedor((EntidadeContato)EntidadeContatoRN.getInstance().buscarPorId(tomadaPreco.getIdEntidadeContato()));
        }
        HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
        for (DataSource arquivo : arquivos = TomadaPrecoRN.getInstance().getDocumentosPdfExcelCotacao(SessaoUtil.getSessao(), fornecedor, tomadaPreco.getIdCotacaoCompra())) {
            try (InputStream inputStream = arquivo.getInputStream();){
                mapArquivos.put(arquivo.getName(), Util.inputStream2ByteArray((InputStream)arquivo.getInputStream()));
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("CMP208", "Erro ao ler o arquivo " + arquivo.getName(), (Throwable)e);
            }
        }
        if (mapArquivos.size() > 1) {
            File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Arquivos da tomada de pre\u00e7o");
            return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Arquivos da tomada de pre\u00e7o");
        }
        return this.responseEntityService.createFileResponse((byte[])mapArquivos.values().toArray()[0], MediaType.APPLICATION_OCTET_STREAM, mapArquivos.keySet().toArray()[0].toString());
    }
}

