/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.configuracaoordemservico;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.ConfiguracaoOrdemServico;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ExtrasCommonRN;
import br.intelidata.commons.modulo.ordemservico.regranegocio.ConfiguracaoOrdemServicoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/configuracao-ordem-servico"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliarOrdemServico", NOME="Configurar Ordem Servi\u00e7o", ROTA="/ordens-servicos/configuracao-ordem-servico", PROGRAMA=609)
public class ConfiguracaoOrdemServicoCrudController
extends SimpleCrudController<ConfiguracaoOrdemServico, ConfiguracaoOrdemServicoRN> {
    private final ResponseEntityService responseEntityService;

    @Autowired
    public ConfiguracaoOrdemServicoCrudController(ResponseEntityService responseEntityService) {
        super((AbstractRegraNegocio)ConfiguracaoOrdemServicoRN.getInstance());
        this.responseEntityService = responseEntityService;
    }

    @DBAutoCommit
    public ConfiguracaoOrdemServico get(@RequestParam(required=false) Long parentId) throws UnicoMensagemUsuarioException {
        ConfiguracaoOrdemServico config = ConfiguracaoOrdemServicoRN.getInstance().buscarPorIdFilial(SessaoUtil.getSessao());
        if (config == null) {
            config = new ConfiguracaoOrdemServico();
        }
        return config;
    }

    @RequestMapping(value={"/exportar-configuracao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> exportar(@RequestBody ConfiguracaoOrdemServico config) {
        config.setCurrentTimeMillis(Long.valueOf(0L));
        ConfiguracaoOrdemServicoRN.getInstance().popularDadosAdicionaisExportacao(config, SessaoUtil.getSessao().getIdFilial());
        byte[] bArray = Util.serializarObjeto((Object)config);
        String nomeArquivo = ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getFilial().getId()) + ".obj";
        return this.responseEntityService.createFileResponse(bArray, MediaType.APPLICATION_OCTET_STREAM, nomeArquivo);
    }

    @RequestMapping(value={"/importar-configuracao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ConfiguracaoOrdemServico importar(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            ConfiguracaoOrdemServico conf = (ConfiguracaoOrdemServico)Util.getObjetoSerializadoDeInputStream((InputStream)file.getInputStream());
            conf.setCurrentTimeMillis(Long.valueOf(0L));
            ConfiguracaoOrdemServicoRN.getInstance().popularDadosAdicionaisImportacao(conf, SessaoUtil.getSessao().getIdFilial());
            return conf;
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("COM2366954", "N\u00e3o \u00e9 poss\u00edvel importar a configura\u00e7\u00e3o de ordem de servi\u00e7o.");
        }
    }

    public void afterSave(ConfiguracaoOrdemServico conf) throws UnicoMensagemUsuarioException {
        if (conf.getExtrasOS() != null) {
            conf.getExtrasOS().setNometabela(ConfiguracaoOrdemServicoRN.getInstance().getTabelaCampoExtra(SessaoUtil.getSessao().getIdFilial()));
            Extras extrasOsOriginal = ExtrasCommonRN.getInstance().buscarPorNomeTabela(conf.getExtrasOS().getNometabela());
            if (extrasOsOriginal != null) {
                conf.getExtrasOS().setId(extrasOsOriginal.getId());
                ExtrasCommonRN.getInstance().gravar(1, (AbstractPojo)conf.getExtrasOS(), SessaoUtil.getSessao());
            } else {
                ExtrasCommonRN.getInstance().gravar(0, (AbstractPojo)conf.getExtrasOS(), SessaoUtil.getSessao());
            }
        }
        if (conf.getExtrasObjeto() != null) {
            Extras extrasObjOriginal = ExtrasCommonRN.getInstance().buscarPorNomeTabela("objeto");
            if (extrasObjOriginal != null) {
                conf.getExtrasObjeto().setId(extrasObjOriginal.getId());
                ExtrasCommonRN.getInstance().gravar(1, (AbstractPojo)conf.getExtrasObjeto(), SessaoUtil.getSessao());
            } else {
                ExtrasCommonRN.getInstance().gravar(0, (AbstractPojo)conf.getExtrasObjeto(), SessaoUtil.getSessao());
            }
        }
    }
}

