/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.cartacorrecao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.cte3.impressao.CCeCTe;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.conhecimento.CartaCorrecaoConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusCartaCorrecaoConhecimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.regranegocio.CartaCorrecaoConhecimentoComponenteRN;
import br.intelidata.commons.modulo.cte.regranegocio.CartaCorrecaoConhecimentoTransporteRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoComponenteRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.cartacorrecao.CartaCorrecaoInclusaoWrapper;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carta-correcao-cte"})
public class CartaCorrecaoCteCrudController
extends CrudController<CartaCorrecaoConhecimentoTransporte, CartaCorrecaoConhecimentoTransporteRN> {
    @Autowired
    public CartaCorrecaoCteCrudController() {
        super((AbstractRegraNegocio)CartaCorrecaoConhecimentoTransporteRN.getInstance(), CartaCorrecaoConhecimentoTransporte::new, true, true);
        this.dependsOn("idConhecimentoTransporte");
    }

    protected String getCacheId() {
        return "carta-correcao-cte";
    }

    protected GridBuilder<CartaCorrecaoConhecimentoTransporteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 50, false));
        colunas.add(new ColunaSQL("idConhecimentoTransporte", "ID CT-e", 0, false));
        colunas.add(new ColunaSQL("sequencia", "Sequencia", 0, false));
        colunas.add(new ColunaSQL("datahora", "Data", 0, true));
        colunas.add(new ColunaSQL("status", "Status", 200, true));
        colunas.add(new ColunaSQL("mensagemRetorno", "Mensagem de retorno da transmiss\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(((CartaCorrecaoConhecimentoTransporteRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id", true));
        return grid;
    }

    @RequestMapping(value={"/dados-inclusao"})
    @DBAutoCommit
    public CartaCorrecaoInclusaoWrapper buscarConhecimentoUltimaCartaCorrecao(@RequestParam Long idConhecimento) {
        CartaCorrecaoInclusaoWrapper wrapper = new CartaCorrecaoInclusaoWrapper();
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idConhecimento);
        conhecimento.setComponentes(ConhecimentoComponenteRN.getInstance().buscarComponentesPorConhecimento(idConhecimento));
        wrapper.setExibirExpedidor(!Util.longNullOuZero((Long)conhecimento.getIdExpedidor()));
        wrapper.setExibirRecebedor(!Util.longNullOuZero((Long)conhecimento.getIdRecebedor()));
        wrapper.setExibirTomador(!Util.longNullOuZero((Long)conhecimento.getIdTomadorOutros()));
        wrapper.setNt2024001OuSuperior(ConhecimentoTransporteRN.getInstance().isNT2024001OuSuperior(idConhecimento));
        wrapper.setIdRemetente(conhecimento.getIdRemetente());
        wrapper.setIdExpedidor(conhecimento.getIdExpedidor());
        wrapper.setIdRecebedor(conhecimento.getIdRecebedor());
        wrapper.setIdDestinatario(conhecimento.getIdDestinatario());
        wrapper.setIdTomadorOutros(conhecimento.getIdTomadorOutros());
        wrapper.setIdEstadoOrigem(conhecimento.getIdEstadoOrigem());
        wrapper.setIdEstadoDestino(conhecimento.getIdEstadoDestino());
        CartaCorrecaoConhecimentoTransporte ultimaCarta = CartaCorrecaoConhecimentoTransporteRN.getInstance().getUltimaCartaCorrecaoPorIdConhecimento(idConhecimento);
        wrapper.setUltimaCartaCorrecao(ultimaCarta);
        return wrapper;
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        CartaCorrecaoConhecimentoTransporte cartaCorrecao = (CartaCorrecaoConhecimentoTransporte)CartaCorrecaoConhecimentoTransporteRN.getInstance().buscarPorId(id);
        if (cartaCorrecao == null) {
            throw new UnicoMensagemUsuarioException("CTE156", "Carta de corre\u00e7\u00e3o n\u00e3o encontrada.");
        }
        if (cartaCorrecao.getArquivoTransmitido() == null) {
            throw new UnicoMensagemUsuarioException("CTE157", "Nenhum arquivo xml foi encontrado para esse CT-e.");
        }
        String chaveCte = ConhecimentoTransporteRN.getInstance().buscarValoresPorID(cartaCorrecao.getIdConhecimentoTransporte(), new String[]{"chaveAcesso"}).getOrDefault("chaveAcesso", "").toString();
        return this.responseEntityService.createXMLResponse(cartaCorrecao.getArquivoTransmitido(), "CCe-" + chaveCte + "-eve.xml");
    }

    @RequestMapping(value={"/gerar-impressao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> gerarImpressao(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        CartaCorrecaoConhecimentoTransporte cartaCorrecao = (CartaCorrecaoConhecimentoTransporte)CartaCorrecaoConhecimentoTransporteRN.getInstance().buscarPorId(id);
        if (cartaCorrecao == null) {
            throw new UnicoMensagemUsuarioException("CTE158", "Carta de corre\u00e7\u00e3o n\u00e3o encontrada.");
        }
        if (cartaCorrecao.getArquivoTransmitido() == null) {
            throw new UnicoMensagemUsuarioException("CTE159", "Nenhum arquivo xml foi encontrado para esse CT-e.");
        }
        String chaveCte = ConhecimentoTransporteRN.getInstance().buscarValoresPorID(cartaCorrecao.getIdConhecimentoTransporte(), new String[]{"chaveAcesso"}).getOrDefault("chaveAcesso", "").toString();
        return this.responseEntityService.createPDFResponse(CCeCTe.getInstance().geraCCeCTe(SessaoUtil.getSessao(), cartaCorrecao), "CCE-".concat(chaveCte));
    }

    protected void beforeCreate(CartaCorrecaoConhecimentoTransporte cartaCorrecaoConhecimentoTransporte, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeCreate((AbstractPojo)cartaCorrecaoConhecimentoTransporte, parentId);
        cartaCorrecaoConhecimentoTransporte.setCodigoRetorno(null);
        cartaCorrecaoConhecimentoTransporte.setMensagemRetorno(null);
        cartaCorrecaoConhecimentoTransporte.setArquivoTransmitido(null);
        cartaCorrecaoConhecimentoTransporte.setStatus(StatusCartaCorrecaoConhecimento.NORMAL);
    }

    protected void beforeRead(CartaCorrecaoConhecimentoTransporte carta, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeRead((AbstractPojo)carta, modo, parentId);
        if (carta != null) {
            carta.setComponentes(CartaCorrecaoConhecimentoComponenteRN.getInstance().buscaListaPorCartaCorrecao(carta.getId()));
        }
    }
}

