/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.complementoviagem;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoComplementoViagem;
import br.intelidata.commons.domain.pojo.conhecimento.ConhecimentoTransporte;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.conhecimento.StatusConhecimentoComplementoViagem;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoComplementoViagemRN;
import br.intelidata.commons.modulo.cte.regranegocio.ConhecimentoTransporteRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/complemento-viagem"})
public class ConhecimentoComplementoViagemCrudController
extends CrudController<ConhecimentoComplementoViagem, ConhecimentoComplementoViagemRN> {
    @Autowired
    public ConhecimentoComplementoViagemCrudController() {
        super((AbstractRegraNegocio)ConhecimentoComplementoViagemRN.getInstance(), ConhecimentoComplementoViagem::new, true, true);
        this.dependsOn("idConhecimento");
    }

    protected String getCacheId() {
        return "complemento-viagem".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<ConhecimentoComplementoViagemRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idConhecimento", "ID do conhecimento", 0, false));
        colunas.add(new ColunaSQL("nome", "descricaoServico", "Servi\u00e7o", 300, true, new String[]{"fk_conhec_compl_servico"}));
        ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 100, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("observacao", "Observa\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(((ConhecimentoComplementoViagemRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("id"));
        return grid;
    }

    @RequestMapping(value={"/gerar-notafiscal"})
    @DBTransaction
    public NotaFiscal gerarNofiscal(Long idConhecimento) throws UnicoMensagemUsuarioException {
        return NotaFiscalRN.getInstance().importarComplementosViagemConhecimento(SessaoUtil.getSessao(), idConhecimento, TipoNotaFiscal.SAIDA, null);
    }

    @RequestMapping(value={"/permite-manipular"})
    @DBAutoCommit
    public boolean permiteManipular(Long idConhecimento) {
        ConhecimentoTransporte conhecimento = (ConhecimentoTransporte)ConhecimentoTransporteRN.getInstance().buscarPorId(idConhecimento);
        return conhecimento != null && !StatusConhecimentoComplementoViagem.FECHADO.equals((Object)conhecimento.getStatusComplementoViagem());
    }
}

