/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransportesaida.inutilizacao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.conhecimento.InutilizacaoCte;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cte.regranegocio.InutilizacaoCteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/inutilizacoes-cte"})
public class InutilizacaoCteCrudController
extends CrudController<InutilizacaoCte, InutilizacaoCteRN> {
    @Autowired
    public InutilizacaoCteCrudController() {
        super((AbstractRegraNegocio)InutilizacaoCteRN.getInstance(), InutilizacaoCte::new, true, true);
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        InutilizacaoCte inutilizacao = (InutilizacaoCte)InutilizacaoCteRN.getInstance().buscarPorId(id);
        if (inutilizacao == null) {
            throw new UnicoMensagemUsuarioException("CTE161", "Inutiliza\u00e7\u00e3o n\u00e3o encontrada.");
        }
        if (inutilizacao.getArquivoXml() == null) {
            throw new UnicoMensagemUsuarioException("CTE162", "Nenhum arquivo xml foi encontrado para esse CT-e.");
        }
        String nomeArquivo = Util.formataDataHora((Temporal)inutilizacao.getAno(), (String)"yy") + Util.apenasNumeros((String)inutilizacao.getCnpj()) + inutilizacao.getModelo().getModeloSpedFiscal() + inutilizacao.getSerie() + inutilizacao.getNumeroInicial() + inutilizacao.getNumeroFinal();
        return this.responseEntityService.createXMLResponse(inutilizacao.getArquivoXml(), nomeArquivo + "-inut.xml");
    }

    protected String getCacheId() {
        return "inutilizacoes-cte";
    }

    protected GridBuilder<InutilizacaoCteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("dataInutilizacao", "Data", 0, true));
        colunas.add(new ColunaSQL("modelo", "Modelo", 100, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 100, true));
        colunas.add(new ColunaSQL("numeroInicial", "N\u00famero inicial", 200, true));
        colunas.add(new ColunaSQL("numeroFinal", "N\u00famero final", 200, true));
        colunas.add(new ColunaSQL("mensagemRetorno", "Mensagem", 0, true));
        colunas.add(new ColunaSQL("protocolo", "Protocolo", 0, true));
        colunas.add(new ColunaSQL("tipoAmbiente", "Ambiente", 0, true));
        GridBuilder grid = new GridBuilder(((InutilizacaoCteRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("datainutilizacao", "datainutilizacao"));
        grid.addOrdemDefault(new Ordem("datainutilizacao", true));
        return grid;
    }
}

