/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contacorrente;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.uboleto.UBoleto;
import br.intelidata.commons.core.uboleto.enums.BancoDisponivel;
import br.intelidata.commons.core.uboleto.enums.InstrucaoCobranca;
import br.intelidata.commons.core.uboleto.enums.LayoutArquivo;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.ConfiguracaoCobrancaNotificacao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.TipoContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ArquivoRemessa;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cobrancaescritural.regranegocio.ArquivoRemessaRN;
import br.intelidata.commons.modulo.financeiro.enums.OperacaoLancamentoFinanceiro;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteAcaoCobrancaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteUsuarioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ParametroCobrancaRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.CarteiraWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.CodigoMovimentoRemessaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.ConfiguracaoBancoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.EspecieDocumentoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.InstrucaoCobrancaWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contas-correntes"})
@SubMenuMapping(MENU="SubMenuFinanceiroAuxiliar", NOME="Contas correntes", ROTA="/financeiros/contas-correntes", PROGRAMA=404)
public class ContaCorrenteCrudController
extends CrudController<ContaCorrente, ContaCorrenteRN> {
    private final Boolean caixa;
    private final StorageService storageService;
    private final FuncionalidadeService funcionalidadeService;

    @Autowired
    public ContaCorrenteCrudController(StorageService storageService, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)ContaCorrenteRN.getInstance(), ContaCorrente::new, true, true, TipoArquivoArmazenado.ContaCorrente);
        this.storageService = storageService;
        this.funcionalidadeService = funcionalidadeService;
        this.caixa = null;
    }

    public ContaCorrenteCrudController(StorageService storageService, ContaCorrenteRN contaCorrenteRN, Boolean caixa, FuncionalidadeService funcionalidadeService) {
        super((AbstractRegraNegocio)contaCorrenteRN, ContaCorrente::new, true, true, TipoArquivoArmazenado.ContaCorrente);
        this.storageService = storageService;
        this.caixa = caixa;
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"/dias-instrucoes"})
    @DBAutoCommit
    public Integer getNumeroDiasInstrucao(@RequestParam Long idContaCorrente, @RequestParam Integer idInstrucao) {
        Integer dias = 0;
        InstrucaoCobranca instrucao = InstrucaoCobranca.getPorId((Integer)idInstrucao);
        ArquivoRemessa arquivoRemessa = ArquivoRemessaRN.getInstance().buscarUltimaRemessaGeradaPorContaInstrucaoCobranca(idContaCorrente, instrucao);
        if (arquivoRemessa != null) {
            dias = arquivoRemessa.getNumeroDiasInstrucao();
        } else {
            ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaCorrente);
            if (contaCorrente != null) {
                dias = contaCorrente.getDiasProtesto();
            }
        }
        if (dias < 3 && InstrucaoCobranca.NEGATIVACAO_AUTOMATICA.equals((Object)instrucao)) {
            return 3;
        }
        return dias;
    }

    @RequestMapping(value={"/instrucoes"})
    @DBAutoCommit
    public ConfiguracaoBancoWrapper getInstrucoes(@RequestParam Long idContaCorrente, @RequestParam Long idCarteira) throws UnicoMensagemUsuarioException {
        ContaCorrenteCarteira carteira;
        Banco banco;
        ContaCorrente conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaCorrente);
        if (conta != null && (banco = (Banco)BancoRN.getInstance().buscarPorId(conta.getIdbanco())) != null && (carteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(idCarteira)) != null) {
            UBoleto uBoleto = new UBoleto(banco.getCodigo(), carteira.getCarteira());
            uBoleto.populaDiferencasEntreArquivoRemessaEBoleto(conta.getLayoutArquivoRemessa().contains("240") ? LayoutArquivo.CNAB240 : LayoutArquivo.CNAB400);
            List instrucoes = Stream.of(uBoleto.getInstrucoesCobrancaDisponiveis()).map(i -> new InstrucaoCobrancaWrapper(i.getId(), i.getDescricao())).collect(Collectors.toList());
            return new ConfiguracaoBancoWrapper(instrucoes, Integer.valueOf(conta.getTipoProtesto()), conta.getTipoImpressaoUBoleto());
        }
        return null;
    }

    @RequestMapping(value={"/configuracoes-banco"})
    @DBAutoCommit
    public ConfiguracaoBancoWrapper configuracaoBanco(@RequestParam Long idBanco, @RequestParam(required=false) String carteira, @RequestParam(required=false) LayoutArquivo layoutArquivo) throws UnicoMensagemUsuarioException {
        Object[] carteiras;
        Optional<BancoDisponivel> filter;
        List carteirasDisponiveis = null;
        Banco banco = (Banco)BancoRN.getInstance().buscarPorId(idBanco);
        if (banco != null && (filter = Stream.of(BancoDisponivel.getBancos()).filter(bancoDisponivel -> bancoDisponivel.getNumeroDoBanco().equals(banco.getCodigo())).findFirst()).isPresent() && !ListMapUtil.arrayNullOrEmpty((Object[])(carteiras = UBoleto.getCarteiras((BancoDisponivel)filter.get())))) {
            carteirasDisponiveis = Stream.of(carteiras).map(c -> new CarteiraWrapper(c.getNomeDaCarteira())).collect(Collectors.toList());
        }
        List especies = null;
        List acoesCobranca = null;
        List instrucoes = null;
        if (!ListMapUtil.listNullOrEmpty(carteirasDisponiveis)) {
            UBoleto uBoleto = new UBoleto(banco.getCodigo(), !StringUtil.stringNullOrEmpty((String)carteira) ? carteira : ((CarteiraWrapper)carteirasDisponiveis.get(0)).getNomeDaCarteira());
            uBoleto.populaDiferencasEntreArquivoRemessaEBoleto(layoutArquivo);
            especies = Stream.of(uBoleto.getEspeciesDocumentoDisponiveis()).map(e -> new EspecieDocumentoWrapper(e.toString())).collect(Collectors.toList());
            acoesCobranca = Stream.of(uBoleto.getAcoesCobrancaDisponiveis()).map(a -> new CodigoMovimentoRemessaWrapper(a.toString())).collect(Collectors.toList());
            instrucoes = Stream.of(uBoleto.getInstrucoesCobrancaDisponiveis()).map(i -> new InstrucaoCobrancaWrapper(i.getId(), i.getDescricao())).collect(Collectors.toList());
        }
        return new ConfiguracaoBancoWrapper(idBanco, layoutArquivo, carteirasDisponiveis, especies, acoesCobranca, instrucoes);
    }

    @RequestMapping(value={"/configuracoes-cobranca-notificacao"})
    @DBAutoCommit
    public ConfiguracaoCobrancaNotificacao configuracaoCobrancaNotificacao(@RequestParam Long idContaCorrente) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List listaAcoes = ContaCorrenteAcaoCobrancaRN.getInstance().buscarListaPorContaCorrente(sessao, idContaCorrente);
        List listaCarteiras = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(idContaCorrente, true);
        ConfiguracaoCobrancaNotificacao configuracaoBancoWrapper = new ConfiguracaoCobrancaNotificacao();
        configuracaoBancoWrapper.setAcoes(listaAcoes);
        configuracaoBancoWrapper.setCarteiras(listaCarteiras);
        return configuracaoBancoWrapper;
    }

    @RequestMapping(value={"/configuracoes-cobranca-notificacao-lista-nf"})
    @DBAutoCommit
    public ConfiguracaoCobrancaNotificacao configuracaoCobrancaNotificacaoPorListaNotas(@RequestParam List<Long> idsNotas) {
        ContaCorrente contaCorrente;
        Sessao sessao = SessaoUtil.getSessao();
        List notasFiscais = idsNotas.stream().map(idNf -> (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNf)).collect(Collectors.toList());
        ConfiguracaoCobrancaNotificacao configuracao = ArquivoRemessaRN.getInstance().configuracaoCobrancaNotificacao(sessao.getFilial(), notasFiscais);
        if (configuracao == null && (contaCorrente = ContaCorrenteRN.getInstance().buscaContaCorrenteFilial(sessao.getIdFilial(), false)) != null) {
            configuracao = new ConfiguracaoCobrancaNotificacao();
            configuracao.setIdContaCorrente(contaCorrente.getId());
        }
        return configuracao;
    }

    @RequestMapping(value={"/contas-financeiro"})
    @DBAutoCommit
    public List<ContaCorrente> getCombo(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        return ContaCorrenteRN.getInstance().getSelectAutocompleteWeb(SessaoUtil.getSessao(), query, limit);
    }

    @RequestMapping(value={"/caixas"})
    @DBAutoCommit
    public List<ContaCorrente> getComboContaCaixa() {
        return ContaCorrenteRN.getInstance().getComboContaCaixaWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/todas"})
    @DBAutoCommit
    public List<ContaCorrente> getComboContaCorrenteTodas() {
        return ContaCorrenteRN.getInstance().getComboContaCorrenteTodasWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/contas"})
    @DBAutoCommit
    public List<ContaCorrente> getComboContaCorrente() {
        return ContaCorrenteRN.getInstance().getComboContaCorrenteWeb(SessaoUtil.getSessao()).stream().peek(conta -> {
            Banco banco = (Banco)BancoRN.getInstance().buscarPorId(conta.getIdbanco());
            if (banco != null) {
                conta.setAsaas(BancoDisponivel.isAsaas((String)banco.getCodigo()));
            }
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/combo-lancamentos-caixa-banco"})
    @DBAutoCommit
    public List<ContaCorrente> getComboLancamentosCaixaBancoContaCorrente(@RequestParam OperacaoLancamentoFinanceiro operacao, @RequestParam TipoContaCorrente tipo) {
        if (operacao.equals((Object)OperacaoLancamentoFinanceiro.TRANFERENCIA)) {
            return this.getCombo(null, 0);
        }
        if (tipo.equals((Object)TipoContaCorrente.BANCOS)) {
            return this.getComboContaCorrente();
        }
        return this.getComboContaCaixa();
    }

    @RequestMapping(value={"/por-filial-logada"})
    @DBAutoCommit
    public ContaCorrente buscaContaCorrenteFilial(@RequestParam(required=false, defaultValue="false") boolean caixa) {
        return ContaCorrenteRN.getInstance().buscaContaCorrenteFilial(SessaoUtil.getSessao().getFilial().getId(), caixa);
    }

    @RequestMapping(value={"/fluxo-caixa-saldo"})
    @DBAutoCommit
    public BigDecimal getSaldoInicial(@RequestParam List<Long> idsFilial) {
        return ContaCorrenteRN.getInstance().getSaldoInicial(idsFilial.toArray(new Long[0]));
    }

    protected void beforeUpdate(ContaCorrente contaCorrente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        String caminhoOriginal;
        if (contaCorrente.getId().equals(-1L)) {
            ContaCorrente original = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(contaCorrente.getId());
            contaCorrente.setDescricao(original.getDescricao());
        }
        if (!StringUtil.stringNullOrEmpty((String)(caminhoOriginal = ContaCorrenteRN.getInstance().getCaminhoImagemWeb(contaCorrente.getId())))) {
            String arquivoRelativo = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ContaCorrente, TipoImagem.Pequena, caminhoOriginal);
            if (StringUtil.stringNullOrEmpty((String)contaCorrente.getCaminhoImagemBoleto()) || !contaCorrente.getCaminhoImagemBoleto().equals(arquivoRelativo)) {
                this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ContaCorrente, caminhoOriginal);
            } else {
                contaCorrente.setCaminhoImagemBoleto(caminhoOriginal);
            }
        }
        if (StringUtil.stringNullOrEmpty((String)contaCorrente.getCaminhoImagemBoleto())) {
            contaCorrente.setImagemBoleto(null);
        }
        ContaCorrenteAcaoCobrancaRN.getInstance().buscarListaPorContaCorrente(SessaoUtil.getSessao(), contaCorrente.getId());
    }

    protected void afterCreate(ContaCorrente contaCorrente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ContaCorrenteAcaoCobrancaRN.getInstance().buscarListaPorContaCorrente(SessaoUtil.getSessao(), contaCorrente.getId());
    }

    protected void beforeRead(ContaCorrente contaCorrente, int modo, Optional<Long> parentId) {
        if (!StringUtil.stringNullOrEmpty((String)contaCorrente.getCaminhoImagemBoleto())) {
            String url = this.storageService.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ContaCorrente, TipoImagem.Pequena, contaCorrente.getCaminhoImagemBoleto(), contaCorrente.getImagemBoleto());
            contaCorrente.setCaminhoImagemBoleto(url);
        }
        contaCorrente.setParametrosCobranca(ParametroCobrancaRN.getInstance().buscarListaPorContaCorrente(contaCorrente.getId()));
    }

    protected void beforeDelete(ContaCorrente contaCorrente) throws UnicoMensagemUsuarioException {
        if (!StringUtil.stringNullOrEmpty((String)contaCorrente.getCaminhoImagemBoleto())) {
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.ContaCorrente, contaCorrente.getCaminhoImagemBoleto());
        }
    }

    protected void beforeSave(ContaCorrente contaCorrente, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Banco banco;
        if (!NumberUtil.longNullOuZero((Long)contaCorrente.getIdbanco()) && (banco = (Banco)BancoRN.getInstance().buscarPorId(contaCorrente.getIdbanco())) != null && !banco.getCodigo().equals("748")) {
            contaCorrente.setPostoBeneficiario("");
        }
    }

    protected GridBuilder<ContaCorrenteRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("nome", "nomeBanco", "Banco", 0, true, new String[]{"fk_contacorrente_banco"}));
        colunas.add(new ColunaSQL("agencia", "Ag\u00eancia", 120, true));
        colunas.add(new ColunaSQL("numeroConta", "Conta", 120, true));
        colunas.add(new ColunaSQL("gerente", "Gerente", 150, true));
        colunas.add(new ColunaSQL("telefoneGerente", "Fone Gerente", 150, true));
        colunas.add(new ColunaSQL("tipoIntegracao", "tipoIntegracao", 0, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 0, false));
        colunas.add(new ColunaSQL("chaveAPI", "chaveAPI", 0, false));
        colunas.add(new ColunaSQL("inativo", "inativo", 0, false));
        GridBuilder grid = new GridBuilder(ContaCorrenteRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("caixa", "caixa"));
        grid.addReferenciaDefault(new Referencia("inativo", "contaInativa"));
        if (this.caixa != null) {
            List contasCorrentesDoUsuario = ContaCorrenteUsuarioRN.getInstance().buscarIdsContasPorUsuario(SessaoUtil.getSessao().getIdUsuario());
            int comportamentoFiltro = PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 472);
            if (Util.listNullOrEmpty((List)contasCorrentesDoUsuario) && LicencaManager.getInstance().isEnterprise() && comportamentoFiltro < 2) {
                Filial filial = FilialCommonRN.getInstance().buscaMatriz();
                Long idFilial = SessaoUtil.getSessao().getFilial().getId();
                if (comportamentoFiltro == 0 && filial.getId().equals(idFilial)) {
                    if (!this.caixa.booleanValue()) {
                        grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, 0));
                        grid.addCodicaoDefault(new Condicao("id", Operador.MAIOR_QUE, 0));
                    } else {
                        grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                        grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, 1));
                        grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
                        grid.addCodicaoDefault(new Condicao("id", Operador.IGUAL, -1));
                        grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                    }
                } else {
                    grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                    grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, this.caixa != false ? 1 : 0));
                    grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
                    grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                    grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, idFilial));
                    grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
                    grid.addCodicaoDefault(new Condicao("idFilial", Operador.IS_NULL));
                    grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                    grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                }
            } else if (Util.listNullOrEmpty((List)contasCorrentesDoUsuario) && comportamentoFiltro == 3) {
                grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, this.caixa != false ? 1 : 0));
                grid.addCodicaoDefault(new Condicao(OperadorLogico.E));
                grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.CONTIDO_EM, FilialRN.getInstance().getIdsFiliaisUsuario(SessaoUtil.getSessao())));
                grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.IS_NULL));
                grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
            } else {
                if (this.caixa.booleanValue()) {
                    grid.addCodicaoDefault(new Condicao(Separador.ABRE_PARENTESIS));
                    grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, 1));
                    grid.addCodicaoDefault(new Condicao(OperadorLogico.OU));
                    grid.addCodicaoDefault(new Condicao("id", Operador.IGUAL, -1));
                    grid.addCodicaoDefault(new Condicao(Separador.FECHA_PARENTESIS));
                } else {
                    grid.addCodicaoDefault(new Condicao("caixa", Operador.IGUAL, 0));
                    grid.addCodicaoDefault(new Condicao("id", Operador.MAIOR_QUE, 0));
                }
                if (!Util.listNullOrEmpty((List)contasCorrentesDoUsuario)) {
                    grid.addCodicaoDefault(new Condicao("id", Operador.CONTIDO_EM, contasCorrentesDoUsuario.toArray(new Long[0])));
                }
            }
        }
        return grid;
    }

    protected String getCacheId() {
        return "contas-correntes".concat(this.caixa != null ? (this.caixa.booleanValue() ? "_caixa" : "_banco") : "").concat("_").concat(SessaoUtil.getSessao().getIdFilial().toString());
    }

    public boolean isGravarArquivoTabela() {
        return true;
    }

    @RequestMapping(value={"/validar-convenio"})
    @DBAutoCommit
    public int validarConvenio(@RequestParam Long idBanco, @RequestParam String codigo) {
        return ContaCorrenteRN.getInstance().validaTamanhoConvenioBanco(idBanco, Integer.valueOf(codigo.length()));
    }
}

