/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contacorrente.carteira;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carteiras"})
public class ContaCorrenteCarteiraCrudController
extends CrudController<ContaCorrenteCarteira, ContaCorrenteCarteiraRN> {
    public ContaCorrenteCarteiraCrudController() {
        super((AbstractRegraNegocio)ContaCorrenteCarteiraRN.getInstance(), ContaCorrenteCarteira::new);
        this.dependsOn("idContaCorrente");
    }

    @RequestMapping(value={"/ativas"})
    @DBAutoCommit
    public List<ContaCorrenteCarteira> buscarCarteirasAtivas(@RequestParam Long idContaCorrente) {
        List carteiras = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(idContaCorrente, true);
        if (!ListMapUtil.listNullOrEmpty((List)carteiras)) {
            carteiras.forEach(contaCorrenteCarteira -> contaCorrenteCarteira.setCarteira(contaCorrenteCarteira.toString()));
        }
        return carteiras;
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idContaCorrente", "idContaCorrente", 0, false));
        colunas.add(new ColunaSQL("carteira", "Carteira", 30, true));
        colunas.add(new ColunaSQL("especie", "Esp\u00e9cie", 30, true));
        colunas.add(new ColunaSQL("inativo", "Inativo", 30, true));
        return new GridBuilder(ContaCorrenteCarteiraRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(ContaCorrenteCarteira contaCorrenteCarteira, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)contaCorrenteCarteira.getIdContaCorrente())) {
            throw new UnicoMensagemUsuarioException("WWW71", "Informe a conta corrente.");
        }
        if (StringUtil.stringNullOrEmpty((String)contaCorrenteCarteira.getCarteira())) {
            throw new UnicoMensagemUsuarioException("WFIN54", "Informe a carteira.");
        }
        if (StringUtil.stringNullOrEmpty((String)contaCorrenteCarteira.getEspecie())) {
            throw new UnicoMensagemUsuarioException("WFIN55", "Informe a esp\u00e9cie.");
        }
        List listContaCarteira = ContaCorrenteCarteiraRN.getInstance().buscarListaPorContaCorrente(contaCorrenteCarteira.getIdContaCorrente(), true);
        for (ContaCorrenteCarteira ccc : listContaCarteira) {
            if (!ccc.getCarteira().equals(contaCorrenteCarteira.getCarteira()) || !ccc.getEspecie().equals(contaCorrenteCarteira.getEspecie()) || !NumberUtil.longNullOuZero((Long)contaCorrenteCarteira.getId()) && contaCorrenteCarteira.getId().equals(ccc.getId())) continue;
            throw new UnicoMensagemUsuarioException("WFIN56", "Carteira " + contaCorrenteCarteira.getCarteira() + " e esp\u00e9cie " + contaCorrenteCarteira.getEspecie() + ", j\u00e1 foram adicionados.");
        }
    }

    protected String getCacheId() {
        return "carteiras";
    }
}

