/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusJobItem;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoEntidade;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.domain.pojo.vendas.StatusContrato;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaItemRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaNotaFiscalRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.SubRevendaRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.UsuarioSiteRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.MultipartUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TratarPesquisaRapida;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoFiltroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoPesquisaRapida;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoVendaItemWeb;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.ContratoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.entidade.EntidadeDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ConfiguracaoCampoExtra(TABELA="cad_contratovenda", QUANTIDADE=QuantidadeCampoExtra.CONTRATO_VENDA)
@RestController(value="contratos")
@RequestMapping(value={"/api/contratos"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Contratos", ROTA="/vendas/contratos", ICONE="icon-comanda", PROGRAMA=130)
public class ContratoCrudController
extends CrudController<ContratoVenda, ContratoVendaRN>
implements ProdutoItemInterface<ContratoVendaItemWeb> {
    @Autowired
    public ContratoCrudController() {
        super((AbstractRegraNegocio)ContratoVendaRN.getInstance(), ContratoVenda::new, true, true, TipoArquivoArmazenado.Contrato);
        this.setItemSupplier(ContratoVendaItemWeb::new);
    }

    @RequestMapping(value={"/buscar-notas-por-contrato"})
    @DBAutoCommit
    public List<HashMap<String, Object>> buscaDadosContratoNotaFiscal(@RequestParam(value="idOrigem") Long idContrato) {
        return ContratoVendaNotaFiscalRN.getInstance().buscaDadosContratoNotaFiscal(idContrato);
    }

    @RequestMapping(value={"/bloquear"}, method={RequestMethod.POST})
    @DBTransaction
    public void bloquearContrato(@RequestBody ContratoWrapper wrapper) throws UnicoMensagemUsuarioException {
        ContratoVenda contrato = (ContratoVenda)((ContratoVendaRN)this.rn).buscarPorId(wrapper.getIdContrato());
        if (contrato != null) {
            if (!contrato.getStatus().isPodeBloquear()) {
                throw new UnicoMensagemUsuarioException("WWW426", "N\u00e3o \u00e9 poss\u00edvel bloquear esse contrato.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW213", "Contrato n\u00e3o encontrado");
        }
        this.permiteBloquearContrato(contrato);
        this.bloquearContrato(contrato, wrapper.getIdMotivo(), wrapper.getJustificativa());
    }

    @RequestMapping(value={"/encerrar"}, method={RequestMethod.POST})
    @DBTransaction
    public void encerrarContrato(@RequestBody ContratoWrapper wrapper) throws UnicoMensagemUsuarioException {
        ContratoVenda contrato = (ContratoVenda)((ContratoVendaRN)this.rn).buscarPorId(wrapper.getIdContrato());
        if (contrato != null) {
            if (!contrato.getStatus().isPodeEncerrar()) {
                throw new UnicoMensagemUsuarioException("WWW214", "N\u00e3o \u00e9 poss\u00edvel encerrar esse contrato.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW215", "Contrato n\u00e3o encontrado");
        }
        this.permiteEncerrarContrato(contrato);
        this.encerrarContrato(contrato, wrapper.getIdMotivo(), wrapper.getJustificativa());
    }

    @RequestMapping(value={"/reativar"})
    @DBTransaction
    public void reativarContrato(@RequestParam Long idContrato, @RequestParam int diasAberto, @RequestParam Long idMotivo, @RequestParam String observacao) throws UnicoMensagemUsuarioException {
        ContratoVenda contrato = (ContratoVenda)((ContratoVendaRN)this.rn).buscarPorId(idContrato);
        if (contrato != null) {
            if (!contrato.getStatus().isPodeReativar()) {
                throw new UnicoMensagemUsuarioException("WWW216", "N\u00e3o \u00e9 poss\u00edvel desbloquear esse contrato.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW217", "Contrato n\u00e3o encontrado");
        }
        ContratoVendaRN.getInstance().reativarContrato(SessaoUtil.getSessao(), contrato, DataHoraFactory.getData(), diasAberto, idMotivo, observacao);
    }

    @RequestMapping(value={"/desbloquear"})
    @DBTransaction
    public void desbloquearContrato(@RequestParam Long idContrato) throws UnicoMensagemUsuarioException {
        ContratoVenda contrato = (ContratoVenda)((ContratoVendaRN)this.rn).buscarPorId(idContrato);
        if (contrato != null) {
            if (!contrato.getStatus().isPodeDesbloquear()) {
                throw new UnicoMensagemUsuarioException("WWW218", "N\u00e3o \u00e9 poss\u00edvel desbloquear esse contrato.");
            }
        } else {
            throw new UnicoMensagemUsuarioException("WWW219", "Contrato n\u00e3o encontrado");
        }
        ContratoVendaRN.getInstance().desbloquearContrato(SessaoUtil.getSessao(), contrato, DataHoraFactory.getData());
    }

    @RequestMapping(value={"/buscar-contratos-reajuste"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ContratoVenda> buscarContratosAptosParaReajustar(@RequestBody ContratoFiltroWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (wrapper.getDataBase() == null) {
            throw new UnicoMensagemUsuarioException("WWW224", "Data base n\u00e3o informada.");
        }
        LocalDate ultimoDiaMesBaseReajuste = DataHoraFactory.of((int)wrapper.getDataBase().getYear(), (Month)wrapper.getDataBase().getMonth(), (int)wrapper.getDataBase().lengthOfMonth());
        return ((ContratoVendaRN)this.rn).buscarContratosAptosParaReajustar(SessaoUtil.getSessao(), wrapper.getEmissaoInicial(), wrapper.getEmissaoFinal(), wrapper.getVencimentoInicial(), wrapper.getVencimentoFinal(), wrapper.getIdCliente(), null, null, wrapper.getPercentualReajuste(), ultimoDiaMesBaseReajuste, wrapper.getQtdDiasSemReajuste(), wrapper.getContratos());
    }

    @RequestMapping(value={"/buscar-contratos-prorrogacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ContratoVenda> buscarContratosParaProrrogacao(@RequestBody ContratoFiltroWrapper wrapper) throws UnicoMensagemUsuarioException {
        return ((ContratoVendaRN)this.rn).buscarContratosParaProrrogacao(wrapper.getEmissaoInicial(), wrapper.getEmissaoFinal(), wrapper.getVencimentoInicial(), wrapper.getVencimentoFinal(), wrapper.getIdCliente(), null, null, wrapper.getContratos());
    }

    @RequestMapping(value={"/buscar-contratos-faturamento"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ContratoVenda> buscarContratosAptosParaFaturar(@RequestBody ContratoFiltroWrapper wrapper) throws UnicoMensagemUsuarioException {
        List contratoVendas = ((ContratoVendaRN)this.rn).buscarContratosAptosParaFaturar(SessaoUtil.getSessao(), null, wrapper.getIdCliente(), null, wrapper.getDiaFaturamento(), wrapper.getContratos());
        contratoVendas.removeIf(contrato -> StatusJobItem.PENDENTE.equals((Object)contrato.getStatusJob()));
        return contratoVendas;
    }

    @RequestMapping(value={"/buscar-por-ids"})
    @DBAutoCommit
    public List<ContratoVenda> buscarContratosPorIds(@RequestBody List<Long> ids) {
        return ContratoVendaRN.getInstance().buscarPorIdsWeb(ids);
    }

    @RequestMapping(value={"/buscar-sub-revenda"})
    @DBAutoCommit
    public List<EntidadeDTO> buscarSubRevenda(@RequestParam Long idRevenda) {
        Long[] ids = SubRevendaRN.getInstance().getIdsSubrevendaPorIdRevenda(idRevenda);
        List entidades = EntidadeRN.getInstance().buscaDadosSelectComboWeb(SessaoUtil.getSessao(), false, false, false, 0, null, Arrays.asList(ids), false, null, true, new TipoEntidade[0]);
        if (!ListMapUtil.listNullOrEmpty((List)entidades)) {
            return entidades.stream().map(entidade -> {
                EntidadeDTO dto = new EntidadeDTO();
                BeanUtil.copiarValores((Object)entidade, (Object)dto, (boolean)false, (boolean)true, null);
                return dto;
            }).collect(Collectors.toList());
        }
        return null;
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(ContratoVendaRN.getInstance().getTabela())) {
            return ExtrasRN.getInstance().buscarPorNomeTabela("cad_contratovenda");
        }
        return null;
    }

    @RequestMapping(value={"/validar-estoque"})
    @DBAutoCommit
    public void validarEstoque(@RequestParam Long idCliente, @RequestParam Long idProduto, @RequestParam BigDecimal qtd, @RequestParam String nomeProduto) throws UnicoMensagemUsuarioException {
        ContratoVendaRN.getInstance().validarEstoque(idCliente, idProduto, qtd, nomeProduto);
    }

    protected void bloquearContrato(ContratoVenda contrato, Long idMotivo, String justificativa) throws UnicoMensagemUsuarioException {
        ContratoVendaRN.getInstance().bloquearContrato(SessaoUtil.getSessao(), contrato, DataHoraFactory.getData(), idMotivo, justificativa);
    }

    protected void encerrarContrato(ContratoVenda contrato, Long idMotivo, String justificativa) throws UnicoMensagemUsuarioException {
        ContratoVendaRN.getInstance().encerrarContrato(SessaoUtil.getSessao(), contrato, DataHoraFactory.getData(), idMotivo, justificativa);
    }

    protected void permiteBloquearContrato(ContratoVenda contratoVenda) throws UnicoMensagemUsuarioException {
    }

    protected void permiteEncerrarContrato(ContratoVenda contratoVenda) throws UnicoMensagemUsuarioException {
    }

    protected String getCacheId() {
        return "contratos_ID_FILIAL_" + SessaoUtil.getSessao().getIdFilial() + "ID_USUARIO_" + SessaoUtil.getSessao().getUsuario().getId();
    }

    protected GridBuilder<ContratoVendaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 120, true));
        colunas.add(new ColunaSQL("idCliente", "ID Cliente", 0, false));
        colunas.add(new ColunaSQL("diaFaturamento", "Dia de Faturamento", 0, false));
        colunas.add(new ColunaSQL("caminhoArquivoContrato", "Caminho arquivo", 0, false));
        ColunaSQL dataFaturamento = new ColunaSQL("dataParaUltimoFaturamento", "Data faturamento", 0, false);
        dataFaturamento.setVirtual(true);
        colunas.add(dataFaturamento);
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 0, true, new String[]{"fk_contratovenda_entidade"}));
        colunas.add(new ColunaSQL("dataInicial", "Data inicial", 140, true));
        colunas.add(new ColunaSQL("dataFinal", "Data final", 140, true));
        ColunaSQL colunaValor = new ColunaSQL("valorTotal", "Valor total", 140, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("status", "Status", 140, true));
        colunas.add(new ColunaSQL("status", "statusFiltro", "Status", 140, false, new String[0]));
        GridBuilder grid = new GridBuilder(((ContratoVendaRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idFilial", "idFilial"));
        grid.addReferenciaDefault(new Referencia("status", "status"));
        grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        if (SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario().isFiltrarFatVendedorUsuario() && !NumberUtil.longNullOuZero((Long)SessaoUtil.getSessao().getUsuario().getIdEntidade())) {
            USelect uSelect = new USelect("entidade");
            uSelect.add(new ColunaSQL("id"));
            uSelect.add((ColunaSQL)new Referencia("idrepresentante"));
            uSelect.add(new Condicao("idrepresentante", Operador.IGUAL, SessaoUtil.getSessao().getUsuario().getIdEntidade()));
            grid.addCodicaoDefault(new Condicao("idCliente", Operador.CONTIDO_EM, uSelect));
        }
        grid.addOrdemDefault(new Ordem("id", true));
        grid.setTratarPesquisaRapida((TratarPesquisaRapida)new ContratoPesquisaRapida());
        return grid;
    }

    protected void beforeRead(ContratoVenda contratoVenda, int modo, Optional<Long> parentId) {
        contratoVenda.setItens(ContratoVendaItemRN.getInstance().buscaListaPorContrato(contratoVenda.getId()));
        contratoVenda.getItens().forEach(item -> {
            Map dados;
            if (!NumberUtil.longNullOuZero((Long)item.getIdServico()) && (dados = ProdutoRN.getInstance().getDadosProdutos(Collections.singletonList(item.getIdServico()))) != null) {
                Produto servico = (Produto)dados.get(item.getIdServico());
                item.setCodigoServico(servico.getCodigo());
                item.setDescricaoServico(servico.getNome());
            }
        });
        if (ModuloManager.getInstance().isAtivo(Modulo.INTELIDATA)) {
            Map dadosContrato;
            String usuario;
            if (!Util.longNullOuZero((Long)contratoVenda.getIdUsuarioCriacao())) {
                usuario = UsuarioSiteRN.getInstance().buscarValoresPorID(contratoVenda.getIdUsuarioCriacao(), new String[]{"nome"}).getOrDefault("nome", "");
                contratoVenda.setUsuarioOrigem(usuario);
            }
            if (!Util.longNullOuZero((Long)contratoVenda.getIdUsuarioMigracao())) {
                usuario = UsuarioSiteRN.getInstance().buscarValoresPorID(contratoVenda.getIdUsuarioMigracao(), new String[]{"nome"}).getOrDefault("nome", "");
                contratoVenda.setUsuarioMigracao(usuario);
            }
            if (!Util.longNullOuZero((Long)contratoVenda.getIdContratoOrigem()) && !(dadosContrato = ContratoVendaRN.getInstance().buscarValoresPorID(contratoVenda.getIdContratoOrigem(), new String[]{"codigo", "valortotal"})).isEmpty()) {
                contratoVenda.setCodigoContratoOrigem(dadosContrato.getOrDefault("codigo", ""));
                contratoVenda.setValorContratoOrigem(dadosContrato.getOrDefault("valortotal", BigDecimal.ZERO));
            }
            if (!Util.longNullOuZero((Long)contratoVenda.getIdContratoDestino()) && !(dadosContrato = ContratoVendaRN.getInstance().buscarValoresPorID(contratoVenda.getIdContratoDestino(), new String[]{"codigo", "valortotal"})).isEmpty()) {
                contratoVenda.setCodigoContratoDestino(dadosContrato.getOrDefault("codigo", ""));
                contratoVenda.setValorContratoDestino(dadosContrato.getOrDefault("valortotal", BigDecimal.ZERO));
            }
        }
    }

    protected void beforeSave(ContratoVenda contratoVenda, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)contratoVenda.getItens())) {
            throw new UnicoMensagemUsuarioException("WWW210", "Itens n\u00e3o informados para o contrato.");
        }
        if (StringUtil.stringNullOrEmpty((String)contratoVenda.getCaminhoArquivoContrato()) && contratoVenda.getArquivoContrato() != null) {
            MultipartFile file = MultipartUtil.montaMultiPartiPorBytes((byte[])contratoVenda.getArquivoContrato(), (String)(contratoVenda.getCodigo() + ".doc"));
            String url = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Contrato, file, false);
            contratoVenda.setCaminhoArquivoContrato(url);
        }
    }

    protected void beforeUpdate(ContratoVenda contratoVenda, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!contratoVenda.getStatus().equals((Object)StatusContrato.ABERTO)) {
            throw new UnicoMensagemUsuarioException("WCTR15", "N\u00e3o \u00e9 poss\u00edvel alterar um contrato encerrado!");
        }
        String caminhoOriginal = ((ContratoVendaRN)this.rn).getCaminhoArquivoWeb(contratoVenda.getId());
        if (!(StringUtil.stringNullOrEmpty((String)caminhoOriginal) || !StringUtil.stringNullOrEmpty((String)contratoVenda.getCaminhoArquivoContrato()) && contratoVenda.getCaminhoArquivoContrato().equals(caminhoOriginal))) {
            this.saveFile.excluirArquivo(ContextoHolder.getTenant(), TipoArquivoArmazenado.Contrato, caminhoOriginal, false);
        }
        if (ModuloManager.getInstance().isAtivo(Modulo.INTELIDATA)) {
            ContratoVendaItemRN.getInstance().verificarSeMovimentaItens(SessaoUtil.getSessao(), contratoVenda, contratoVenda.getItens());
        }
        contratoVenda.setDataUltimoFaturamento(ContratoVendaNotaFiscalRN.getInstance().buscaMaiorDataParaFaturamentoContrato(contratoVenda.getId()));
    }

    protected void beforeDelete(ContratoVenda contratoVenda) throws UnicoMensagemUsuarioException {
        if (!contratoVenda.getStatus().equals((Object)StatusContrato.ABERTO)) {
            throw new UnicoMensagemUsuarioException("WCTR13", "N\u00e3o \u00e9 poss\u00edvel excluir um contrato encerrado!");
        }
        if (ContratoVendaNotaFiscalRN.getInstance().possuiFaturamentoWeb(contratoVenda.getId())) {
            throw new UnicoMensagemUsuarioException("WCTR14", "N\u00e3o \u00e9 poss\u00edvel excluir um contrato que possui faturamento!");
        }
        if (!StringUtil.stringNullOrEmpty((String)contratoVenda.getCaminhoArquivoContrato())) {
            this.saveFile.excluirArquivo(ContextoHolder.getTenant(), TipoArquivoArmazenado.Contrato, contratoVenda.getCaminhoArquivoContrato(), false);
        }
    }

    public ProdutoItemWeb<ContratoVendaItemWeb> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Entidade cliente = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        if (!parametros.containsKey((Object)"idCliente")) {
            throw new UnicoMensagemUsuarioException("WWW211", "Por favor informe o cliente antes de informar o servi\u00e7o.");
        }
        Long idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente");
        if (!NumberUtil.longNullOuZero((Long)idCliente)) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        ContratoVendaItemWeb contrato = new ContratoVendaItemWeb();
        contrato.setQuantidade(BigDecimal.ONE);
        produtoItem.setItem((ItemWeb)contrato);
        produtoItem.setProduto(produto);
        new ProdutoItemRN().carregaItem(SessaoUtil.getSessao(), produtoItem, cliente, null, null, Long.valueOf(0L), false, true, true, TipoValorPreco.PRECO, false, false, false, null, tipos, false, null, 20, false);
        return produtoItem;
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        dados.forEach(registro -> {
            int indexCaminho;
            String caminhoOriginal;
            int idxDataFinal = this.getIndexColuna("dataFinal", colunas);
            int idxUltimoFaturamento = this.getIndexColuna("dataParaUltimoFaturamento", colunas);
            if (idxDataFinal > -1 && idxUltimoFaturamento > -1) {
                int ultimoDiaMes;
                LocalDate dataParaUltimoFaturamento = DataHoraFactory.date2LocalDate((Date)((Date)registro[idxDataFinal])).plusMonths(1L);
                int diaFaturamento = (Integer)registro[this.getIndexColuna("diaFaturamento", colunas)];
                if (diaFaturamento <= 0) {
                    diaFaturamento = 1;
                }
                if (diaFaturamento > (ultimoDiaMes = dataParaUltimoFaturamento.getMonth().length(dataParaUltimoFaturamento.isLeapYear()))) {
                    diaFaturamento = ultimoDiaMes;
                }
                dataParaUltimoFaturamento = DataHoraFactory.of((int)dataParaUltimoFaturamento.getYear(), (int)dataParaUltimoFaturamento.getMonthValue(), (int)diaFaturamento);
                registro[idxUltimoFaturamento] = dataParaUltimoFaturamento;
            }
            if (!StringUtil.stringNullOrEmpty((String)(caminhoOriginal = (String)registro[indexCaminho = this.getIndexColuna("caminhoArquivoContrato", colunas)]))) {
                registro[indexCaminho] = this.saveFile.publishArquivo(caminhoOriginal);
            }
        });
    }

    public List<Coluna> getColunasCustomizaveis() {
        return ((ContratoVendaRN)this.rn).getColunaGridCustomozaveisWW();
    }
}

