/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.crescevendas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.integracaocrescevendas.EnvioPendentesCresceVendas;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.pafecf.EnvioCresceVendas;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.EnvioCresceVendasRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/envio-cresce-vendas"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliar", NOME="Envios Cresce Vendas", ROTA="/vendas/envio-cresce-vendas", PROGRAMA=1000080)
public class EnvioCresceVendasCrudController
extends CrudController<EnvioCresceVendas, EnvioCresceVendasRN> {
    public EnvioCresceVendasCrudController() {
        super((AbstractRegraNegocio)EnvioCresceVendasRN.getInstance(), EnvioCresceVendas::new, true, true, false);
    }

    protected GridBuilder<EnvioCresceVendasRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("horafinal", "operacao_horafinal", "Emiss\u00e3o", 0, true, new String[]{"fk_enviocrescevendas_operacao"}));
        colunas.add(new ColunaSQL("pdv", "operacao_pdv", "PDV", 0, true, new String[]{"fk_enviocrescevendas_operacao"}));
        colunas.add(new ColunaSQL("numeronfce", "operacao_numeronfce", "Documento fiscal", 0, true, new String[]{"fk_enviocrescevendas_operacao"}));
        colunas.add(new ColunaSQL("datahora", "Data/Hora envio", 200, true));
        colunas.add(new ColunaSQL("pendente", "Pendente", 100, true));
        colunas.add(new ColunaSQL("erro", "Erro", 100, true));
        colunas.add(new ColunaSQL("cancelar", "Cancelado", 100, true));
        colunas.add(new ColunaSQL("codigoerro", "C\u00f3digo do erro", 150, true));
        colunas.add(new ColunaSQL("mensagemexcecao", "Mensagem do erro", 0, true));
        GridBuilder controler = new GridBuilder(EnvioCresceVendasRN.getInstance().getTabela(), colunas);
        controler.addCondicao(new Condicao("idfilial_", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        controler.addReferenciaDefault(new Referencia("idfilial", "idfilial_"));
        controler.addReferenciaDefault(new Referencia("pendente", "pendente_"));
        controler.addReferenciaDefault(new Referencia("pdv", "pdv_", new String[]{"fk_enviocrescevendas_operacao"}));
        controler.addReferenciaDefault(new Referencia("data", "data_", new String[]{"fk_enviocrescevendas_operacao"}));
        controler.addOrdem(new Ordem("data_"));
        controler.addOrdem(new Ordem("pdv_"));
        return controler;
    }

    @PostMapping(value={"/enviar-pendentes"})
    @DBTransaction
    public void enviarPendentes() throws UnicoMensagemUsuarioException {
        new EnvioPendentesCresceVendas().enviar(SessaoUtil.getSessao().getFilial());
    }

    protected String getCacheId() {
        return "envio-cresce-vendas";
    }
}

