/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.customediodiario;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.estoque.SituacaoCustoMedio;
import br.intelidata.commons.domain.pojo.estoque.CustoMedioDiario;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.EmpresaCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.relatorio.ProdutosIncorretosCustoMedioRelatorio;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/custos-medio-diario"})
@SubMenuMapping(MENU="SubMenuEstoqueAuxiliar", NOME="C\u00e1lculo de custo m\u00e9dio", ROTA="/estoques/custos-medio-diario", ICONE="icon-e-moeda", PROGRAMA=1321)
public class CustoMedioDiarioCrudController
extends CrudController<CustoMedioDiario, CustoMedioDiarioRN> {
    private final ResponseEntityService responseService;

    @Autowired
    public CustoMedioDiarioCrudController(ResponseEntityService responseService) {
        super((AbstractRegraNegocio)CustoMedioDiarioRN.getInstance(), CustoMedioDiario::new, true, false);
        this.responseService = responseService;
    }

    protected GridBuilder<CustoMedioDiarioRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idEmpresa", "idEmpresa", 0, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 0, false));
        colunas.add(new ColunaSQL("idUsuarioUltimoCalculo", "idUsuarioUltimoCalculo", 0, false));
        colunas.add(new ColunaSQL("idUsuarioAbertura", "idUsuarioAbertura", 0, false));
        colunas.add(new ColunaSQL("razaosocial", "razaosocial", "Filial", 400, true, new String[]{"fk_custo_m_diario_filial"}));
        colunas.add(new ColunaSQL("ano", "Ano", 70, true));
        colunas.add(new ColunaSQL("mes", "M\u00eas", 70, true));
        colunas.add(new ColunaSQL("nome", "usuarioAbertura", "\u00daltima abertura", 130, true, new String[]{"fk_custo_m_diario_usu_aber"}));
        colunas.add(new ColunaSQL("dataUltimaAbertura", "Data da \u00faltima abertura", 200, true));
        colunas.add(new ColunaSQL("nome", "usuarioCalculo", "\u00daltimo c\u00e1lculo", 130, true, new String[]{"fk_custo_m_diario_usu_calc"}));
        colunas.add(new ColunaSQL("dataUltimoCalculo", "Data do \u00faltimo c\u00e1lculo", 200, true));
        colunas.add(new ColunaSQL("observacoes", "Motivo de abertura", 300, true));
        colunas.add(new ColunaSQL("resultado", "Resultado do \u00faltimo c\u00e1lculo", 250, true));
        colunas.add(new ColunaSQL("situacao", "Situa\u00e7\u00e3o", 100, true));
        GridBuilder grid = new GridBuilder(CustoMedioDiarioRN.getInstance().getTabela(), colunas);
        if (EmpresaCommonRN.getInstance().isHabilitarEmpresaNoSistema() && SessaoUtil.getSessao().getFilial().getIdEmpresa() != 0L) {
            grid.addCodicaoDefault(new Condicao("idEmpresa", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getIdEmpresa()));
        }
        grid.setOrdemDefault(new Ordem("idFilial"));
        grid.setOrdemDefault(new Ordem("ano", true));
        grid.setOrdemDefault(new Ordem("mes"));
        return grid;
    }

    protected String getCacheId() {
        String retorno = "custos-medio-diario";
        if (EmpresaCommonRN.getInstance().isHabilitarEmpresaNoSistema() && SessaoUtil.getSessao().getFilial().getIdEmpresa() != 0L) {
            retorno = retorno + "&idEmpresa=" + SessaoUtil.getSessao().getFilial().getIdEmpresa();
        }
        return retorno;
    }

    @RequestMapping(value={"/verifica-inicializacao"})
    @DBTransaction
    public void verificaInicializacaoCustoMedio() throws UnicoMensagemUsuarioException {
        List filiais = FilialRN.getInstance().getFiliaisPorEmpresa(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        for (Filial filial : filiais) {
            boolean isInicializado = CustoMedioDiarioRN.getInstance().isCustoMedioInicializado(filial);
            if (isInicializado) continue;
            CustoMedioDiarioRN.getInstance().verificaInicializacaoRegistroCustoMedio(SessaoUtil.getSessao(), filial);
        }
        CustoMedioDiarioRN.getInstance().populaEmpresaRegistro(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/reabrir-calculo"})
    @DBTransaction
    public void reabrirCalculo(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)id)) {
            throw new UnicoMensagemUsuarioException("WCST41", "Por favor selecione o registro.");
        }
        CustoMedioDiario custoMedioDiario = (CustoMedioDiario)CustoMedioDiarioRN.getInstance().buscarPorId(id);
        if (custoMedioDiario.getSituacao() == SituacaoCustoMedio.CONCLUIDO) {
            CustoMedioDiarioRN.getInstance().reabrirCalculo(SessaoUtil.getSessao(), custoMedioDiario);
        }
    }

    @RequestMapping(value={"/produtos-incorretos"})
    @DBAutoCommit
    public ResponseEntity<byte[]> buscarProdutosIncorretos(@RequestBody CustoMedioDiario custoMedioDiario) throws UnicoMensagemUsuarioException {
        Remessa remessa = new ProdutosIncorretosCustoMedioRelatorio().getRelatorio(custoMedioDiario);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"Produtos incorretos");
    }
}

