/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.customediodiario;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.estoque.CustoMedioDiario;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.customediodiario.JobCalculoCustoMedioDiario;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/custos-medio-diario"})
public class CustoMedioDiarioJobSimpleCrudController
extends SimpleCrudController<CustoMedioDiario, CustoMedioDiarioRN>
implements ICreateTask {
    private final TaskManager taskManager;
    private String name;
    private TipoJob tipoJob;
    private final NotificationService notificationService;

    public CustoMedioDiarioJobSimpleCrudController(TaskManager taskManager, NotificationService notificationService) {
        this.taskManager = taskManager;
        this.notificationService = notificationService;
    }

    public TipoJob getTipoJob() {
        return this.tipoJob;
    }

    public String getDescricao() {
        return this.name;
    }

    public Class<? extends AbstractJob> job() {
        return JobCalculoCustoMedioDiario.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/calcular-todos"})
    @DBTransaction
    public void calcularTodosRegistros() throws UnicoMensagemUsuarioException {
        List registros = CustoMedioDiarioRN.getInstance().buscarListaPorEmpresaOrdenadaAnoMes(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        this.criarJob(registros, TipoJob.CALCULO_CUSTO_MEDIO_TODOS);
    }

    @RequestMapping(value={"/calcular-pendentes"})
    @DBTransaction
    public void calcularRegistrosPendente() throws UnicoMensagemUsuarioException {
        List registrosPendentes = CustoMedioDiarioRN.getInstance().buscarRegistrosPendentesEmpresaOrdenadaAnoMes(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        this.criarJob(registrosPendentes, TipoJob.CALCULO_CUSTO_MEDIO_PENDENTES);
    }

    @RequestMapping(value={"/calcular-proximo-pendente"})
    @DBTransaction
    public void calcularProximoPendente() throws UnicoMensagemUsuarioException {
        CustoMedioDiario registro = CustoMedioDiarioRN.getInstance().buscarProximoMesPendente(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        this.criarJob(Collections.singletonList(registro), TipoJob.CALCULO_CUSTO_MEDIO_PROXIMO_PENDENTE);
        String msg = "C\u00e1lculo do custo m\u00e9dio do m\u00eas " + registro.getMes().getDescricao() + " de " + registro.getAno() + " agendado com sucesso";
        this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.SUCCESS, msg);
    }

    private void criarJob(List<CustoMedioDiario> registros, TipoJob tipoJob) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty(registros)) {
            throw new UnicoMensagemUsuarioException("WWW206", "N\u00e3o existe registros para serem calculados");
        }
        String nome = "Calcular custo m\u00e9dio ";
        nome = tipoJob == TipoJob.CALCULO_CUSTO_MEDIO_PENDENTES ? nome + "(pendentes)" : (tipoJob == TipoJob.CALCULO_CUSTO_MEDIO_PROXIMO_PENDENTE ? nome + "do m\u00eas " + registros.get(0).getMes().getDescricao() + " de " + registros.get(0).getAno() : nome + "(Todos registros)");
        this.name = nome;
        this.tipoJob = tipoJob;
        this.createTask(registros);
    }
}

